//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXMessage.cpp
 * @brief		directX bZ[WNXt@C
 *
 * @note		GȃNX݌vɂȂĂ܂BBB
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXMessage_CPP_

//======================================================================
// include
#include "DXMessage.h"
#include "../DXDevice.h"

namespace iris {
namespace dx
{

//======================================================================
// declare

//======================================================================
// class

//======================================================================
// CDXMessageMgr
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXMessageMgr::CDXMessageMgr(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXMessageMgr::~CDXMessageMgr(void)
{
	Release();
}

/**********************************************************************//**
 *
 * 
 * 
*//***********************************************************************/
void CDXMessageMgr::Release(void)
{
	for( CResMap::iterator it = m_Resource.begin(); it != m_Resource.end(); )
	{
		IDXFontResource* res = it->second;
		it = m_Resource.erase(it);
		delete res;
	}
	for( CMsgMap::iterator it = m_Message.begin(); it != m_Message.end(); )
	{
		CDXMessage* msg = it->second;
		it = m_Message.erase(it);
		delete msg;
	}
}

/**********************************************************************//**
 *
 * XV
 * 
 ----------------------------------------------------------------------
 * @param [in]	time	= XV
*//***********************************************************************/
void CDXMessageMgr::Update(f32 time)
{
	for( CMsgMap::iterator it = m_Message.begin(); it != m_Message.end(); ++it )
	{
		it->second->Update(time);
	}
}

/**********************************************************************//**
 *
 * `
 * 
*//***********************************************************************/
void CDXMessageMgr::Draw(void)
{
	for( CMsgMap::iterator mit = m_Message.begin(); mit != m_Message.end(); ++mit )
	{
		CDXMessage* msg = mit->second;
		CDXMessage::CDataMap& data_map = msg->GetMessageData();
		for( CDXMessage::CDataMap::iterator it = data_map.begin(), end = data_map.end(); it != end; ++it )
		{
			CDXMessageData* data = it->second;
			CDXMessageData::vecCode& code = data->GetCode();
			UINT id = (UINT)eERROR_ID;
			IDXFontResource* res = nullptr;
			IDXFontTexture* font = nullptr;
			int w=0, h=0;

			for( int i=0, loop=data->GetCalcLoopCount(); i < loop; ++i )
			{
				// `ʒu
				D3DXVECTOR3 pos(0.0f,0.0f,0.0f);
				for( int j=0, len=data->GetShowLength(); j < len; ++j )
				{
					UINT c = code[j];
					UINT tmp = msg->GetCodeResID(c);
					if( id != tmp )
					{
						id = tmp;
						res = GetResource(id);	// tHg\[X擾
						if( res != nullptr )
						{
							font = res->GetFont();
							w = font->GetFontWidth();
							h = font->GetFontHeight();
							// Ԑݒ
							font->CopyRenderState( data->GetRenderState() );
						}
					}
					if( res != nullptr ) 
					{
						// `ʒu擾
						data->CalcPosition( i, j, w, h, pos );
						if( i == loop-1 )
						{
							data->CalcState(c, font);
							font->SetWorldPos(&pos);
							res->DrawCode(c);
						}
					}
				}
			}
		}
	}
}

/**********************************************************************//**
 *
 * bZ[W폜
 * 
 ----------------------------------------------------------------------
 * @param [in]	uID	= bZ[WID
 * @return	
*//***********************************************************************/
bool CDXMessageMgr::DeleteMessage(UINT uID)
{
	CMsgMap::iterator it = m_Message.find(uID);
	if( it == m_Message.end() ) return false;
	if( it->first != uID ) return false;
	CDXMessage* msg = it->second;
	if( msg == nullptr ) return false;
	m_Message.erase(it);
	delete msg;
	return true;
}

/**********************************************************************//**
 *
 * bZ[W擾
 * 
 ----------------------------------------------------------------------
 * @param [in]	uID	= bZ[WID
 * @return	bZ[WNX
*//***********************************************************************/
CDXMessage* CDXMessageMgr::GetMessage(UINT uID)
{
	CMsgMap::iterator it = m_Message.find(uID);
	if( it == m_Message.end() ) return nullptr;
	if( it->first != uID ) return nullptr;
	return it->second;
}

/**********************************************************************//**
 *
 * tHg\[X폜
 * 
 ----------------------------------------------------------------------
 * @param [in]	uID	= \[XID
 * @return	
*//***********************************************************************/
bool CDXMessageMgr::DeleteResource(UINT uID)
{
	CResMap::iterator it = m_Resource.find(uID);
	if( it == m_Resource.end() ) return false;
	if( it->first != uID ) return false;
	IDXFontResource* res = it->second;
	if( res == nullptr ) return false;
	m_Resource.erase(it);
	delete res;
	return true;
}

/**********************************************************************//**
 *
 * tHg\[X擾
 * 
 ----------------------------------------------------------------------
 * @param [in]	uID	= \[XID
 * @return	tHg\[XNX
*//***********************************************************************/
IDXFontResource* CDXMessageMgr::GetResource(UINT uID) const
{
	CResMap::const_iterator it = m_Resource.find(uID);
	if( it == m_Resource.end() ) return nullptr;
	if( it->first != uID ) return nullptr;
	return it->second;
}

/**********************************************************************//**
 *
 * \[X
 * 
 ----------------------------------------------------------------------
 * @param [in]	uID		= \[XID
 * @param [in]	pString	= ޕ
 * @param [in]	size	= ރTCY
 * @return	
*//***********************************************************************/
bool CDXMessageMgr::WriteResourceA(UINT uID, LPCSTR  pString, size_t size)
{
	IDXFontResource* res = GetResource(uID);
	if( res == nullptr ) return false;
	return res->WriteResourceA(pString, size);
}
/// CDXMessageMgr::WriteResourceA Q
bool CDXMessageMgr::WriteResourceW(UINT uID, LPCWSTR pString, size_t size)
{
	IDXFontResource* res = GetResource(uID);
	if( res == nullptr ) return false;
	return res->WriteResourceW(pString, size);
}

/**********************************************************************//**
 *
 * \[Xo^
 * 
 ----------------------------------------------------------------------
 * @param [in]	uID			= \[XID
 * @param [in]	width		= 
 * @param [in]	height		= 
 * @param [in]	lpInfo		= tHg
 * @param [in]	pResFont	= \[X
 * @return	
*//***********************************************************************/
bool CDXMessageMgr::RegisterResource (UINT uID, UINT width, UINT height, const CDXFontInfo* lpInfo, IDXFontResource* pResFont)
{
#ifdef UNICODE
	return RegisterResourceW(uID, width, height, lpInfo, pResFont);
#else
	return RegisterResourceA(uID, width, height, lpInfo, pResFont);
#endif
}
/// CDXMessageMgr::RegisterResource Q
bool CDXMessageMgr::RegisterResourceA(UINT uID, UINT width, UINT height, const CDXFontInfo* lpInfo, IDXFontResource* pResFont)
{
	if( pResFont == nullptr ) return false;
	CDXDevice* pDxDevice = GetDXDevice();
	if( pDxDevice == nullptr )	return false;
	IDXSwapChain* pSwapChain = GetDXSwapChain();
	pDxDevice->RegisterDeviceObject(pResFont->GetFont(), pSwapChain);
	if( !pResFont->CreateResourceA(width, height, lpInfo) )
	{
		pDxDevice->EraseDeviceObject(pResFont->GetFont());
		return false;
	}
	m_Resource.insert( CResPair(uID, pResFont) );
	return true;
}
/// CDXMessageMgr::RegisterResource Q
bool CDXMessageMgr::RegisterResourceW(UINT uID, UINT width, UINT height, const CDXFontInfo* lpInfo, IDXFontResource* pResFont)
{
	if( pResFont == nullptr ) return false;
	CDXDevice* pDxDevice = GetDXDevice();
	if( pDxDevice == nullptr )	return false;
	pDxDevice->RegisterDeviceObject(pResFont->GetFont());
	if( !pResFont->CreateResourceW(width, height, lpInfo) )
	{
		pDxDevice->EraseDeviceObject(pResFont->GetFont());
		return false;
	}
	m_Resource.insert( CResPair(uID, pResFont) );
	return true;
}

}	// end of namespace dx
}	// end of namespace iris


#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../debug/DXDebugUnitTest.h"
#include "../DXObjectManager.h"
#include "../scene/DXCamera.h"
#include "iris_iostream.h"
#include "iris_using.h"

//======================================================================
// function
static LRESULT CALLBACK WindowProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

//======================================================================
// test
IRIS_UNITTEST_B(CDXMessageUnitTest, iris::dx::dbg::CDXUnitTestBase, DXMessageUnitTest)
{
	static const UINT WINDOW_STYLE		= WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX;
	static const UINT WINDOW_STYLEEX	= WS_EX_OVERLAPPEDWINDOW;
	HWND hWnd = nullptr;
	RECT src = {0, 0, 640, 480};

	// EBhEg̒
	AdjustWindowRectEx(
		&src,
		WINDOW_STYLE,
		FALSE,
		WINDOW_STYLEEX );

	hWnd = wx::dbg::CreateUnitTestWindow(WINDOW_STYLEEX, m_TestName, m_TestName, WINDOW_STYLE
		, src.right, src.bottom, WindowProc);

	// EBhE̍쐬Ɏs
	if( hWnd == nullptr ) return;

	iris::dx::CDXFontInfo info;
	CDXDevice dev(hWnd);
	CDXObjectManager objMan(&dev.GetDXSwapChain());

	if( !dev.CreateDevice(src.right, src.bottom, false, false, false, false, false, false) )
	{
		return;
	}
	dev.CreateSprite();
	objMan.CreateLayer<CDXDefaultLayer>(0);
	//CDXCamera* pCamera = objMan.CreateObject<CDXCamera>();
	//pCamera->SetPos(D3DXVECTOR3(0.0f, 0.0f, -10.0f));
	//pCamera->SetViewport();
	//pCamera->Activate();

	CDXMessageMgr* pMsgMan = objMan.CreateLayerObject<CDXMessageMgr>(0);

	CHAR res_buf[256] = "abcdefghijklmnopqrs";
	CHAR msg_buf[256] = "test";
#ifndef _IRIS_SUPPORT_AUTO_UNITTEST
	std::cout << "\[X͂ĂB" << std::endl;
	std::cin >> res_buf;
	std::cout << "bZ[W͂ĂB" << std::endl;
	std::cin >> msg_buf;
#endif

	IDXFontResource* pResFont[2] = { nullptr };
	info.SetHeight(30).SetFaceName(TEXT("lr "));
	pResFont[0] = pMsgMan->CreateResource(0, 256, 256, &info);
	pResFont[1] = pMsgMan->CreateResource< CDXFontResource<CDXFont> >(1, 256, 256, &info);
	for( UINT i=0; i < 2; ++i )
	{
		if( pResFont[i] != nullptr )
		{
			pResFont[i]->WriteResourceA( res_buf, strlen(res_buf) );
			CDXMessage* msg = pMsgMan->CreateMessage(i, i);
			CDXMessageData* data = msg->CreateMessageData(0);
			data->SetCodeA( msg_buf, strlen(msg_buf) );
			data->EnableRenderState(DXRS_DRAWSPRITE);
			data->SetMin( &D3DXVECTOR3(0.0f, i*src.bottom/2.0f, 0.0f) );
		}
	}

	// EBhE\
	ShowWindow(hWnd, SW_SHOW);
	// EBhE̍XV
	UpdateWindow(hWnd);

	this->SetDevice(&dev);
	// őOʂ
	SetForegroundWindow(hWnd);

	// bZ[W[v
	wx::dbg::UnitTestMainLoop(hWnd);
}

/**********************************************************************//**
 *
 * eXgpEBhEvV[W
 * 
 ----------------------------------------------------------------------
 * @param	hWnd	EBhEnh
 * @param	uMsg	sꂽbZ[W
 * @param	wParam	sꂽbZ[W@
 * @param	lParam	sꂽbZ[WA
 * @return	LRESULTl
*//***********************************************************************/
LRESULT CALLBACK WindowProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	// bZ[W̏
	switch( uMsg )
	{
	case WM_DESTROY:
		PostQuitMessage( 0 );
		break;
	case WM_CLOSE:
		DestroyWindow( hWnd );
		break;
	case WM_KEYUP:
		switch( wParam )
		{
		case VK_ESCAPE:
			DestroyWindow( hWnd );
			break;
		}
		break;
	case WM_PAINT:
		{
			iris::dx::dbg::CDXUnitTestBase* pUT = iris::dx::dbg::CDXUnitTestBase::GetCurrent();
			pUT->Draw();
		}
		break;
	default:
		return DefWindowProc( hWnd, uMsg, wParam, lParam );
		break;
	}

	return 0L;
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
