//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXTexFrame.cpp
 * @brief		directX eNX`tbVReit@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXTexFrame_CPP_

//======================================================================
// include
#include "DXTexFrame.h"

#include "../../../../win/debug/WXDebug.h"
#include "../../../../win/debug/WXDebugLeakCheckMacro.h"

namespace iris {
namespace dx
{

//======================================================================
// class
// CDXTexFrameAllocHierarchy
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXTexFrameAllocHierarchy::CDXTexFrameAllocHierarchy(void)
: m_pfnCreateTexture(DXMeshDefaultCreateTexture)
, m_pfnDeleteTexture(DXMeshDefaultDeleteTexture)
{
}

/**********************************************************************//**
 *
 * fXgN^
 * 
*//***********************************************************************/
CDXTexFrameAllocHierarchy::~CDXTexFrameAllocHierarchy(void)
{
}

/**********************************************************************//**
 *
 * bV Rei IuWFNg̊蓖ĉv
 * 
 -----------------------------------------------------------------------
 * @param [in]	pMeshContainerToFree	= 
 * @return	HRESULTl
*//***********************************************************************/
HRESULT CDXTexFrameAllocHierarchy::DestroyMeshContainer(LPD3DXMESHCONTAINER pMeshContainerToFree)
{
	if( pMeshContainerToFree == nullptr ) return S_FALSE;
	LPD3DXMESHCONTAINEREX pD3DXMeshContainer = (LPD3DXMESHCONTAINEREX)pMeshContainerToFree;

	for( DWORD i = 0; i < pD3DXMeshContainer->NumMaterials; ++ i )
	{
		DX_SAFE_DELETE_ARRAY( pD3DXMeshContainer->pMaterials[i].pTextureFilename );
		if( m_pfnDeleteTexture != nullptr )
		{
			(*m_pfnDeleteTexture)(&pD3DXMeshContainer->pTextures[i]);
		}
		else
		{
			DX_SAFE_RELEASE( pD3DXMeshContainer->pTextures[i] );
		}
	}
	DX_SAFE_DELETE_ARRAY( pD3DXMeshContainer->pTextures );

	return CDXFrameAllocHierarchy::DestroyMeshContainer(pMeshContainerToFree);
}

/**********************************************************************//**
 *
 * Rei\̂̊m
 * 
 -----------------------------------------------------------------------
 * @return	D3DXMESHCONTAINER*
*//***********************************************************************/
D3DXMESHCONTAINER* CDXTexFrameAllocHierarchy::AllocateContainer(void)
{
	D3DXMESHCONTAINEREX* pD3DXMeshContainer = new D3DXMESHCONTAINEREX;
	if( pD3DXMeshContainer == nullptr ) return nullptr;
	pD3DXMeshContainer->Name				= nullptr;
	pD3DXMeshContainer->MeshData.Type		= D3DXMESHTYPE_MESH;
	pD3DXMeshContainer->MeshData.pMesh		= nullptr;
	pD3DXMeshContainer->MeshData.pPMesh		= nullptr;
	pD3DXMeshContainer->MeshData.pPatchMesh	= nullptr;
	pD3DXMeshContainer->pMaterials			= nullptr;
	pD3DXMeshContainer->pEffects			= nullptr;
	pD3DXMeshContainer->NumMaterials		= 0;
	pD3DXMeshContainer->pAdjacency			= nullptr;
	pD3DXMeshContainer->pSkinInfo			= nullptr;
	pD3DXMeshContainer->pNextMeshContainer	= nullptr;
	pD3DXMeshContainer->pTextures			= nullptr;

	return pD3DXMeshContainer;
}


/**********************************************************************//**
 *
 * }eA̍쐬
 * 
 -----------------------------------------------------------------------
 * @param [out]	pContainer		= Rei
 * @param [in]	pMaterials		= }eAf[^
 * @param [in]	NumMaterials	= }eA
 * @return	
*//***********************************************************************/
bool CDXTexFrameAllocHierarchy::CreateMaterials(D3DXMESHCONTAINER* pContainer, const D3DXMATERIAL *pMaterials, DWORD NumMaterials)
{
	D3DXMESHCONTAINEREX* pD3DXMeshContainer = static_cast<D3DXMESHCONTAINEREX*>(pContainer);
	LPDXTEXTURE* pD3DXTextures  = new LPDXTEXTURE [NumMaterials];
	if( pD3DXTextures == nullptr ) return false;
	pD3DXMeshContainer->pTextures = pD3DXTextures;
	return CDXFrameAllocHierarchy::CreateMaterials(pContainer, pMaterials, NumMaterials);
}

/**********************************************************************//**
 *
 * eNX`̍쐬
 * 
 -----------------------------------------------------------------------
 * @param [io]	pContainer		= Rei
 * @param [in]	lpFileName		= eNX`̃t@C
 * @param [in]	dwIndex			= CfbNX
 * @return	
*//***********************************************************************/
bool CDXTexFrameAllocHierarchy::CreateTexture(D3DXMESHCONTAINER* pContainer, LPCSTR lpFileName, DWORD dwIndex)
{
	D3DXMESHCONTAINEREX* pD3DXMeshContainer = static_cast<D3DXMESHCONTAINEREX*>(pContainer);
	pD3DXMeshContainer->pTextures[dwIndex] = nullptr;

	if( !CDXFrameAllocHierarchy::CreateTexture(pContainer, lpFileName, dwIndex) ) return false;;

	if( m_pfnCreateTexture != nullptr && lpFileName != nullptr )
	{
		CDXDeviceX pDevice = nullptr;
		pContainer->MeshData.pMesh->GetDevice(&pDevice);
		if( pDevice == nullptr ) return false;

		if(FAILED( (*m_pfnCreateTexture)(pDevice, lpFileName, &pD3DXMeshContainer->pTextures[dwIndex] ) ))
		{
			dprintfA("failed D3DXCreateTextureFromFileEx <%s>.\n", lpFileName );
			pD3DXMeshContainer->pTextures[dwIndex] = nullptr;
		}
	}
	return true;
}


}	// end of namespace dx
}	// end of namespace iris
