//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXPrimitive.h
 * @brief		DXPrimitive t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXPrimitive_H_
#define INCG_IRIS_DXPrimitive_H_

//======================================================================
// include
#include "../layer/DXLayerObject.h"
#include "DXVertexBuffer.h"
#include "DXIndexBuffer.h"
#include "../../DXFlags.h"

namespace iris {
namespace dx
{

//======================================================================
// class
/**
 * @brief	Primitive C^[tF[XNX
*/
class IDXPrimitive : public IDXMtxLayerObject, public CRenderState
{
public:
	static const u32	DXRS_DEFAULT	= (DXRS_ENABLELIGHT);
public:
	typedef CDXDeviceObject<LPDXTEXTURE>	TEXTURE;
protected:
	TEXTURE				m_pTexture;	//!< eNX`
	DXPRIMITIVETYPE		m_Type;		//!< v~eBu^Cv
	UINT				m_Count;	//!< v~eBuJEg

public:
	// RXgN^
	IDXPrimitive(void);
	// fXgN^
	virtual ~IDXPrimitive(void);

public:
	// XV
	virtual void	Update(f32 time);
	// `
	virtual	void	Draw(void);
	// 
	virtual	void	Release(void);

public:
	//! eNX`̐ݒ
	void			SetTexture(const TEXTURE& tex)	{ m_pTexture = tex; }
	//! eNX`̎擾
	const TEXTURE&	GetTexture(void)	const		{ return m_pTexture; }

protected:
	// v~eBu`
	virtual	void	DrawPrimitive(void)	= 0;
};

/**
 * @brief	o[ebNXobt@[v~eBu NX
*/
class CDXPrimitive : public IDXPrimitive, public CDXVertexBuffer
{
protected:
	DXPRIMITIVETYPE		m_Type;		//!< v~eBu^Cv
	UINT				m_Count;	//!< v~eBuJEg

public:
	// RXgN^
	CDXPrimitive(void);
	// fXgN^
	virtual ~CDXPrimitive(void);

public:
	//! 쐬
	virtual bool	Create(void) { return true; }
	// 쐬
			bool	Create(UINT uLength, DWORD dwUsage, DWORD dwFVF, UINT uStride, DXPOOL Pool)	
								{ return CDXVertexBuffer::Create(uLength, dwUsage, dwFVF, uStride, Pool); }
	// 
	virtual	void	Release(void);
protected:
	// Zbg
	virtual	void	Reset(void);
	// XgA
	virtual	void	Restore(void);

public:
	//! ^Cvݒ
	void			SetType(DXPRIMITIVETYPE type)	{ m_Type = type; }
	//! ^Cv擾
	DXPRIMITIVETYPE	GetType(void)	const			{ return m_Type; }

	//! v~eBuJEg̐ݒ
	void			SetCount(UINT count)			{ m_Count = count; }
	//! v~eBuJEg̎擾
	UINT			SetCount(void)	const			{ return m_Count; }

public:
	//! o[ebNXobt@[̐ݒ
	void			SetVertexBuffer(const CDXVertexBuffer& vertex)	{ *((CDXVertexBuffer*)this) = vertex; }

protected:
	// v~eBu`
	virtual	void	DrawPrimitive(void);
};

/**
 * @brief	CfbNXobt@[v~eBu NX
*/
class CDXIndexPrimitive : public CDXPrimitive
{
public:
	typedef CDXDeviceObject<LPDXINDEXBUFFER>	INDEXBUFFER;

protected:
	INDEXBUFFER	m_lpIB;	//!< CfbNXobt@[

public:
	// RXgN^
	CDXIndexPrimitive(void);
	// fXgN^
	virtual ~CDXIndexPrimitive(void);

public:
	// 
	virtual	void	Release(void);

public:
	//! eNX`̐ݒ
	void				SetIndexBuffer(const INDEXBUFFER& idx)	{ m_lpIB = idx; }
	//! eNX`̎擾
	const INDEXBUFFER&	GetIndexBuffer(void)	const			{ return m_lpIB; }

protected:
	// v~eBu`
	virtual	void	DrawPrimitive(void);
};


}	// end of namespace dx
}	// end of namespace iris

#endif
