//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXLayer.cpp
 * @brief		directX C[NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXLayer_CPP_

//======================================================================
// include
#include "DXLayer.h"
#include "../DXDevice.h"

#include "../../../win/debug/WXDebug.h"

namespace iris {
namespace dx
{

//======================================================================
// class

//======================================================================
// IDXLayer
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
IDXLayer::IDXLayer(void)
: m_pManager(nullptr)
, m_LayerID(LAYERID_NONE)
, m_RenderState(DXLYRS_DEFAULT)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
IDXLayer::~IDXLayer(void)
{
	if( m_pManager != nullptr )
	{
		m_pManager->EraseLayer(this);
	}
}

/**********************************************************************//**
 *
 * IuWFNg̒ǉ
 *
 ----------------------------------------------------------------------
 * @param [in]	obj	= IuWFNg
*//***********************************************************************/
void IDXLayer::PushBack(IDXLayerObject* obj)
{
	RegisterUpdater(obj);
	RegisterDrawer(obj);
}

/**********************************************************************//**
 *
 * IuWFNg̍폜
 *
 ----------------------------------------------------------------------
 * @param [in]	obj	= IuWFNg
*//***********************************************************************/
bool IDXLayer::Erase(IDXLayerObject* obj)
{
	bool ret = false;
	ret |= EraseUpdater(obj);
	ret |= EraseDrawer(obj);
	return ret;
}

/**********************************************************************//**
 *
 * Updaterɒǉ
 *
 ----------------------------------------------------------------------
 * @param [in]	obj	= IuWFNg
*//***********************************************************************/
void IDXLayer::RegisterUpdater(IDXLayerObject* obj)
{
	m_Updater.push_back(obj->GetUpdateNode());
}

/**********************************************************************//**
 *
 * Drawerɒǉ
 *
 ----------------------------------------------------------------------
 * @param [in]	obj	= IuWFNg
*//***********************************************************************/
void IDXLayer::RegisterDrawer(IDXLayerObject* obj)
{
	m_Drawer.push_back(obj->GetDrawNode());
}

/**********************************************************************//**
 *
 * Updater폜
 *
 ----------------------------------------------------------------------
 * @param [in]	obj	= IuWFNg
*//***********************************************************************/
bool IDXLayer::EraseUpdater(IDXLayerObject* obj)
{
	for( Updater::iterator it = m_Updater.begin(), end = m_Updater.end(); it != end; ++it )
	{
		if( &it == obj->GetUpdateNode() )
		{
			m_Updater.erase(it);
			return true;
		}
	}
	return false;
}

/**********************************************************************//**
 *
 * Drawer폜
 *
 ----------------------------------------------------------------------
 * @param [in]	obj	= IuWFNg
*//***********************************************************************/
bool IDXLayer::EraseDrawer(IDXLayerObject* obj)
{
	for( Drawer::iterator it = m_Drawer.begin(), end = m_Drawer.end(); it != end; ++it )
	{
		if( &it == obj->GetDrawNode() )
		{
			m_Drawer.erase(it);
			return true;
		}
	}
	return false;
}

/**********************************************************************//**
 *
 * Drawer̃\[g
 *
*//***********************************************************************/
void IDXLayer::SortDrawer(void)
{
	m_Drawer.sort();
}

/**********************************************************************//**
 *
 * XV
 * 
 ----------------------------------------------------------------------
 * @param [in]	time	= XV
*//***********************************************************************/
void IDXLayer::UpdateLayer(f32 time)
{
	for( Updater::iterator it = m_Updater.begin(), end = m_Updater.end(); it != end; ++it )
	{
		(*it)->Update(time);
	}
}

/**********************************************************************//**
 *
 * `
 * 
*//***********************************************************************/
void IDXLayer::DrawLayer(void)
{
	for( Drawer::iterator it = m_Drawer.begin(), end = m_Drawer.end(); it != end; )
	{
		IDXLayerObject* p = dcast<IDXLayerObject*>(it->value());
#if 0
		if( p->GetDXDevice() == nullptr )
		{
			it = m_Objects.erase(it);
			continue;
		}
#endif
		p->PreDraw();
		p->Draw();
		p->PostDraw();
		++it;
	}
}


//======================================================================
// CDXDefaultLayer
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXDefaultLayer::CDXDefaultLayer(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXDefaultLayer::~CDXDefaultLayer(void)
{
}

/**********************************************************************//**
 *
 * `Jn
 *
*//***********************************************************************/
void CDXDefaultLayer::Begin(void)
{
}

/**********************************************************************//**
 *
 * `I
 *
*//***********************************************************************/
void CDXDefaultLayer::End(void)
{
}

//======================================================================
// CDXLayer
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXLayer::CDXLayer(void)
: m_pPreSurface(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXLayer::~CDXLayer(void)
{
}

/**********************************************************************//**
 *
 * 쐬
 * 
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CDXLayer::Create(void)
{
	LPCDXPRESENT_PARAMETERS present = GetPresent();
	if( present == nullptr ) return false;
	return CDXRenderTarget::Create(D3DFMT_A8R8G8B8, present->BackBufferWidth, present->BackBufferHeight);
}

/**********************************************************************//**
 *
 * XgA
 *
*//***********************************************************************/
void CDXLayer::Restore(void)
{
	// width,heightXV
	LPCDXPRESENT_PARAMETERS present = GetPresent();
	if( present == nullptr ) return;
	m_Width = present->BackBufferWidth;
	m_Height= present->BackBufferHeight;
	CDXRenderTarget::Restore();
}

/**********************************************************************//**
 *
 * `Jn
 *
*//***********************************************************************/
void CDXLayer::Begin(void)
{
	CDXDeviceX pDevice = GetDevice();
	if( pDevice == nullptr ) return;
	pDevice.GetRenderTarget(0, &m_pPreSurface);
	pDevice.GetDepthStencilSurface(&m_pPreStencil);
	SetRenderTarget(0);
	// eNX`T[tFCX̃NA
	pDevice.Clear( 0, nullptr, 
		D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER,
		D3DCOLOR_ARGB(0,0,0,0), 1.0f, 0 );
}

/**********************************************************************//**
 *
 * `I
 *
*//***********************************************************************/
void CDXLayer::End(void)
{
	CDXDeviceX pDevice = GetDevice();
	if( pDevice == nullptr ) return;
	pDevice.SetRenderTarget(0, m_pPreSurface);
	pDevice.SetDepthStencilSurface(m_pPreStencil);
	DX_SAFE_RELEASE(m_pPreSurface);
	DX_SAFE_RELEASE(m_pPreStencil);
	Draw2D();
}

/**********************************************************************//**
 *
 * IDo^
 *		CDXLayerMgrĂяo܂B
 * 
 ----------------------------------------------------------------------
 * @param [in]	pDevice	= foCXǗNX̃|C^
*//***********************************************************************/
bool CDXLayer::AttachDevice(IDXSwapChain* pSwapChain)
{
	bool ret = false;
	if( pSwapChain != nullptr ) ret = pSwapChain->RegisterDeviceObject(this);
	return ret;
}



//======================================================================
// CDXLayerMgr
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXLayerMgr::CDXLayerMgr(void)
: m_pEvent(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXLayerMgr::~CDXLayerMgr(void)
{
}

/**********************************************************************//**
 *
 * XV
 *
 ----------------------------------------------------------------------
 * @param [in]	time	= XV
*//***********************************************************************/
void CDXLayerMgr::Update(f32 time)
{
	for( mapLayer::iterator it = m_Layers.begin(), end = m_Layers.end(); it != end; ++it )
	{
		IDXLayer* layer = it->second;
		layer->UpdateLayer(time);
	}
}

/**********************************************************************//**
 *
 * `
 *
*//***********************************************************************/
void CDXLayerMgr::Draw(void)
{
	for( mapLayer::iterator it = m_Layers.begin(), end = m_Layers.end(); it != end; ++it )
	{
		IDXLayer* layer = it->second;
		layer->Begin();
		layer->DrawLayer();
		if( m_pEvent != nullptr ) m_pEvent->OnDrawLayer(layer);
		layer->End();
	}
}

/**********************************************************************//**
 *
 * IuWFNgC[ɓo^
 *
 ----------------------------------------------------------------------
 * @param [in]	LayerID	= C[ID
 * @param [in]	obj		= IuWFNg|C^
 * @return	
*//***********************************************************************/
bool CDXLayerMgr::RegisterLayerObject(int LayerID, IDXLayerObject* obj)
{
	if( obj == nullptr ) return false;
	//if( obj->GetDXDevice() != nullptr ) return false;
	IDXLayer* layer = GetLayer(LayerID);
	if( layer == nullptr ) return false;
	layer->PushBack(obj);
	return true;
}

/**********************************************************************//**
 *
 * IuWFNgC[폜
 *
 ----------------------------------------------------------------------
 * @param [in]	LayerID	= C[ID
 * @param [in]	obj		= IuWFNg|C^
 * @return	
*//***********************************************************************/
bool CDXLayerMgr::EraseLayerObject(int LayerID, IDXLayerObject* obj)
{
	if( obj == nullptr ) return false;
	IDXLayer* layer = GetLayer(LayerID);
	if( layer == nullptr ) return false;
	layer->Erase(obj);
	return true;
}

/**********************************************************************//**
 *
 * IuWFNgC[狭폜
 *
 ----------------------------------------------------------------------
 * @param [in]	obj		= IuWFNg|C^
 * @return	
*//***********************************************************************/
void CDXLayerMgr::EraseLayerObjectForce(IDXLayerObject* obj)
{
	if( obj == nullptr ) return;
	for( mapLayer::iterator it = m_Layers.begin(); it != m_Layers.end(); ++it )
	{
		IDXLayer* layer = it->second;
		if( layer == nullptr ) continue;
		while( layer->Erase(obj) ) {}
	}
}

/**********************************************************************//**
 *
 * C[̒ǉ
 *		IDXSwapChainĂяo܂B
 *
 ----------------------------------------------------------------------
 * @param [in]	LayerID		= C[ID
 * @param [in]	layer		= C[
 * @param [in]	pSwapChain	= Xbv`FCNX
 * @return	
*//***********************************************************************/
bool CDXLayerMgr::RegisterLayer(int LayerID, IDXLayer* layer, IDXSwapChain* pSwapChain)
{
	IRIS_ASSERT( LayerID != IDXLayer::LAYERID_NONE );

	// łɓo^ς݂̏ꍇ͓o^s
	if( layer->GetLayerID() != IDXLayer::LAYERID_NONE ) 
	{
		dprintf(TEXT("failed RegisterLayer. The LPDXLayer has already been registered.\n") );
		return false;
	}
	// łɓIDꍇ͓o^s
	mapLayer::iterator it = m_Layers.find(LayerID);
	if( it != m_Layers.end() && it->first == LayerID ) 
	{
		dprintf(TEXT("failed RegisterLayer. The ID(%d) has already been registered.\n"), LayerID );
		return false;
	}
	layer->SetLayerID(LayerID,this);
	if( !layer->AttachDevice(pSwapChain) ) return false;
	// IDŃ\[g
	it = m_Layers.begin();
	for( mapLayer::iterator end = m_Layers.end(); it != end; ++it )
	{
		if( it->first > LayerID ) break;
	}
	m_Layers.insert(it,pairLayer(LayerID,layer));
	return true;
}

/**********************************************************************//**
 *
 * C[̍폜
 *
 ----------------------------------------------------------------------
 * @param [in]	LayerID	= C[ID
 * @return	
*//***********************************************************************/
bool CDXLayerMgr::EraseLayer(int LayerID)
{
	mapLayer::iterator it = m_Layers.find(LayerID);
	if( it == m_Layers.end() ) return false;
	if( it->first != LayerID )
	{
		dprintf( TEXT("ID(%d!=%d) was not corresponding."), it->first, LayerID );
		return false;
	}
	IDXLayer* layer = it->second;
	layer->DetachDevice();
	layer->SetLayerID(IDXLayer::LAYERID_NONE);
	m_Layers.erase(it);
	return true;
}

/**********************************************************************//**
 *
 * C[̍폜
 *
 ----------------------------------------------------------------------
 * @param [in]	layer	= C[
 * @return	
*//***********************************************************************/
bool CDXLayerMgr::EraseLayer(IDXLayer* layer)
{
	mapLayer::iterator it = m_Layers.find(layer->GetLayerID());
	if( it == m_Layers.end() ) return false;
	if( it->second != layer )
	{
		dprintf( TEXT("layer was not corresponding.") );
		return false;
	}
	layer->DetachDevice();
	layer->SetLayerID(IDXLayer::LAYERID_NONE);
	m_Layers.erase(it);
	return true;
}

/**********************************************************************//**
 *
 * C[̑S폜
 *
*//***********************************************************************/
void CDXLayerMgr::EraseLayerAll(void)
{
	for( mapLayer::iterator it = m_Layers.begin(); it != m_Layers.end(); )
	{
		IDXLayer* layer = it->second;
		layer->DetachDevice();
		layer->SetLayerID(IDXLayer::LAYERID_NONE);
		it = m_Layers.erase(it);
	}
}

/**********************************************************************//**
 *
 * C[̍폜Ɖ
 *
 ----------------------------------------------------------------------
 * @param [in]	LayerID	= C[ID
 * @return	
*//***********************************************************************/
bool CDXLayerMgr::ReleaseLayer(int LayerID)
{
	mapLayer::iterator it = m_Layers.find(LayerID);
	if( it == m_Layers.end() ) return false;
	if( it->first != LayerID )
	{
		dprintf( TEXT("ID(%d!=%d) was not corresponding."), it->first, LayerID );
		return false;
	}
	IDXLayer* layer = it->second;
	layer->DetachDevice();
	layer->SetLayerID(IDXLayer::LAYERID_NONE);
	m_Layers.erase(it);
	delete layer;
	return true;
}
/**********************************************************************//**
 *
 * C[̍폜Ɖiׂāj
 *
*//***********************************************************************/
void CDXLayerMgr::ReleaseLayerAll(void)
{
	for( mapLayer::iterator it = m_Layers.begin(); it != m_Layers.end(); )
	{
		IDXLayer* layer = it->second;
		layer->DetachDevice();
		layer->SetLayerID(IDXLayer::LAYERID_NONE);
		it = m_Layers.erase(it);
		delete layer;
	}
}

/**********************************************************************//**
 *
 * C[̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	LayerID	= C[ID
 * @return	C[
*//***********************************************************************/
IDXLayer* CDXLayerMgr::GetLayer(int LayerID) const
{
	mapLayer::const_iterator it = m_Layers.find(LayerID);
	if( it == m_Layers.end() ) return nullptr;
	if( it->first != LayerID )
	{
		dprintf( TEXT("ID(%d!=%d) was not corresponding."), it->first, LayerID );
		return nullptr;
	}
	return it->second;
}

/**********************************************************************//**
 *
 * ̃C[݂邩ǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	layer	= C[
 * @return	true
*//***********************************************************************/
bool CDXLayerMgr::IsRegisteredLayer(IDXLayer* layer) const
{
	for( mapLayer::const_iterator it = m_Layers.begin(), end = m_Layers.end(); it != end; ++it )
	{
		if( it->second == layer && it->first == layer->m_LayerID )
		{
			return true;
		}
	}
	return false;
}

}	// end of namespace dx
}	// end of namespace iris
