//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXFontResource.h
 * @brief		directX tHg\[XNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXFontResource_H_
#define INCG_IRIS_DXFontResource_H_

//======================================================================
// include
#include <map>
#include "DXGlyphFont.h"

namespace iris {
namespace dx
{

//======================================================================
// declare
template<class _TC>class CDXFontResource;

//======================================================================
// typedef
//! tHgŃtHg\[X
typedef CDXFontResource<CDXGlyphFont>	CDXHFontResource;

//======================================================================
// class

//======================================================================
//! tHg\[XNXC^[tFCX
class IDXFontResource : public IIrisObject
{
public:
	typedef std::map<UINT, POINT>	CodeMap;
	typedef std::pair<UINT, POINT>	CodePair;
	typedef CodeMap::iterator		iterator;
protected:
	CodeMap		m_CodeMap;	//!< R[hXg
	POINT		m_Current;	//!< Jg`ʒu

public:
	// RXgN^
	IDXFontResource(void);
	// fXgN^
	virtual ~IDXFontResource(void);

public:
	// R[hNA
	virtual void	ClearCode(void);
	// \[X쐬
	virtual	bool	CreateResourceA(UINT width, UINT height, const CDXFontInfo* lpInfo) = 0;
	virtual	bool	CreateResourceW(UINT width, UINT height, const CDXFontInfo* lpInfo) = 0;
#ifdef UNICODE
	virtual bool	CreateResource(UINT width, UINT height, const CDXFontInfo* lpInfo)	{ return CreateResourceW(width, height, lpInfo); }
#else
	virtual bool	CreateResource(UINT width, UINT height, const CDXFontInfo* lpInfo)	{ return CreateResourceA(width, height, lpInfo); }
#endif

	// tHgNX擾
	virtual	IDXFontTexture*	GetFont(void) = 0;
public:
	// \[X
	virtual bool	WriteResourceA(LPCSTR  pString, size_t size);
	virtual bool	WriteResourceW(LPCWSTR pString, size_t size);
	virtual bool	WriteResource(LPCWSTR pString, size_t size)	{ return WriteResourceW(pString,size); }
	virtual bool	WriteResource(LPCSTR  pString, size_t size)	{ return WriteResourceA(pString,size); }

protected:
	virtual bool	WriteCodeA(LPCSTR  c, UINT code) = 0;
	virtual bool	WriteCodeW(LPCWSTR c, UINT code) = 0;

public:
	// `
	virtual bool	DrawCodeA(LPCSTR c);
	virtual bool	DrawCodeW(LPCWSTR c);
	virtual bool	DrawCode(UINT code)	= 0;
	virtual bool	DrawCode(LPCWSTR c)	{ return DrawCodeW(c); }
	virtual bool	DrawCode(LPCSTR  c)	{ return DrawCodeA(c); }

protected:
	// R[h}bvXg擾
	virtual iterator	FindCodeMap(UINT code);
	// eNX`W擾
	virtual bool		GetCodePoint(UINT code, POINT& point) const;
};

//======================================================================
//! tHg\[XNX
template<class _TC>
class CDXFontResource : public _TC, public IDXFontResource
{
public:
	typedef _TC		_CFont;
	typedef _TC		*_LPCFont;

public:
	/// RXgN^
	CDXFontResource(void)			{ m_FontColor = 0xFFFFFFFF; }
	/// fXgN^
	virtual ~CDXFontResource(void)	{}

public:

	/// tHg폜
	virtual void	DeleteFont(void)
	{
		// ̃tHgǗłȂ̂ŃNA
		Clear();
		_CFont::DeleteFont();
	}
	/// \[XNA
	virtual void	Clear(void)	{ _CFont::Clear(); ClearCode(); }
	/// \[X쐬
	virtual	bool	CreateResourceA(UINT width, UINT height, const CDXFontInfo* lpInfo)
	{
		if( !_CFont::Create(width, height) )		return false;
		if( !_CFont::CreateFontFromInfoA(lpInfo) )	return false;
		_CFont::Clear();
		return true;
	}
	/// \[X쐬
	virtual	bool	CreateResourceW(UINT width, UINT height, const CDXFontInfo* lpInfo)
	{
		if( !_CFont::Create(width, height) )		return false;
		if( !_CFont::CreateFontFromInfoW(lpInfo) )	return false;
		_CFont::Clear();
		return true;
	}

public:
	// tHgNX擾
	virtual	IDXFontTexture*	GetFont(void)						{ return this; }

public:
	// tHgJ[
	void			SetFontColor(const intr::DXICOLOR& color)	{ _CFont::SetFontColor(color); }
	intr::DXICOLOR	GetFontColor(void)		const				{ return _CFont::GetFontColor(); }
	// eNX`J[
	void			SetTextureColor(const intr::DXICOLOR& color)	{ _CFont::SetColor(color); }
	intr::DXICOLOR	GetTextureColor(void)	const					{ return _CFont::GetColor(); }

public:
	/// 1
	virtual bool	DrawCode(UINT code)	
	{
		POINT pnt;
		if( !GetCodePoint(code,pnt) ) return false;
		D3DXVECTOR2 size((f32)_CFont::GetFontWidth(), (f32)_CFont::GetFontHeight());
		SetUV( (f32)pnt.x, (f32)pnt.y, (f32)(pnt.x+size.x), (f32)(pnt.y+size.y) );
		SetTextureSize( &size );
		Draw();
		return true;
	}
protected:
	/// \[X
	virtual bool	WriteCodeA(LPCSTR  c, UINT code)
	{
		switch( *c )
		{
		case '\r':
		case '\n':
		case '\0':
			return true;
		}
		// Xg猟
		if( FindCodeMap(code) != m_CodeMap.end() ) return true;	// łɂ
		// 
		if( !_CFont::TextOutA( m_Current.x, m_Current.y, c, 1 ) ) return false;
		// R[hXgɓo^
		m_CodeMap.insert( CodePair(code,m_Current) );

		// |WVXV
		int width = _CFont::GetFontWidth();
		m_Current.x += width;
		if( (UINT)m_Current.x > m_Width - width )
		{
			m_Current.x = 0;
			m_Current.y += _CFont::GetFontHeight();
		}
		return false;
	}
	/// \[X
	virtual bool	WriteCodeW(LPCWSTR c, UINT code)
	{
		switch( *c )
		{
		case '\r':
		case '\n':
		case '\0':
			return true;
		}
		// Xg猟
		if( FindCodeMap(code) != m_CodeMap.end() ) return true;	// łɂ
		// 
		if( !_CFont::TextOutW( m_Current.x, m_Current.y, c, 1 ) ) return false;
		// R[hXgɓo^
		m_CodeMap.insert( CodePair(code,m_Current) );

		// |WVXV
		int width = _CFont::GetFontWidth();
		m_Current.x += width;
		if( (UINT)m_Current.x > m_Width - width )
		{
			m_Current.x = 0;
			m_Current.y += _CFont::GetFontHeight();
		}
		return false;
	}

private:
	// B
	// 񏑂݁ieNX`ɕށj
	virtual bool	TextOutA( int , int , LPCSTR  , size_t ) { return false; }
	virtual bool	TextOutW( int , int , LPCWSTR , size_t ) { return false; }
};

}	// end of namespace dx
}	// end of namespace iris

#endif
