//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXFont.h
 * @brief		directX tHgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXFont_H_
#define INCG_IRIS_DXFont_H_

//======================================================================
// include
#include "DXFontTexture.h"

namespace iris {
namespace dx
{

#if	!defined(_IRIS_SUPPORT_DXMOBILE)

//======================================================================
// declare
class CDXFont;

//======================================================================
// class
/**
 * @brief	D3DXFONTNX
 * @note	foCXZbgɃeLXgݒ肵Ȃ΂ȂȂB
*/
class CDXFont : public IDXFontTexture
{
protected:
	CDXDeviceObject<LPDXSURFACE>	m_pStencil;	//!< XeVobt@
	CDXDeviceObject<LPDXFONT>		m_pFont;	//!< tHg
	DWORD		m_Format;	//!< tH[}bg

public:
	// RXgN^
	CDXFont(void);
	// fXgN^
	~CDXFont(void);

public:
	virtual bool	Create(UINT width, UINT height);
	// 
	virtual void	Release(void);

public:
	// ̈̃NA
	virtual void	Clear(void);

	// 񏑂݁ieNX`ɕށj
	virtual bool	TextOutA(int x, int y, LPCSTR  pString, size_t size);
	virtual bool	TextOutW(int x, int y, LPCWSTR pString, size_t size);

	// `
	virtual bool	TextOutDirectA(int x1, int y1, int x2, int y2, LPCSTR  pString, size_t size);
	virtual bool	TextOutDirectW(int x1, int y1, int x2, int y2, LPCWSTR pString, size_t size);
public:
	// tHg쐬
	virtual	bool	CreateFontA( int height, int width, int weight, DWORD bItalic, DWORD /*bUnderline*/, DWORD /*bStrikeOut*/
								, DWORD iCharSet, DWORD iOutputPrecision, DWORD iQuality, DWORD iPitchAndFamily
								, LPCSTR  pszFaceName)
	{
		return CreateFontA( height, width, static_cast<UINT>(weight), 1u, static_cast<BOOL>(bItalic)
			, iCharSet, iOutputPrecision, iQuality, iPitchAndFamily, pszFaceName );
	}
	virtual	bool	CreateFontW( int height, int width, int weight, DWORD bItalic, DWORD /*bUnderline*/, DWORD /*bStrikeOut*/
								, DWORD iCharSet, DWORD iOutputPrecision, DWORD iQuality, DWORD iPitchAndFamily
								, LPCWSTR pszFaceName)
	{
		return CreateFontW( height, width, static_cast<UINT>(weight), 1u, static_cast<BOOL>(bItalic)
			, iCharSet, iOutputPrecision, iQuality, iPitchAndFamily, pszFaceName );
	}

	virtual	bool CreateFontA( int height, int width, UINT weight, UINT MipLevel
					, BOOL Italic, DWORD CharSet, DWORD OutputPrecision, DWORD Quality, DWORD PitchAndFamily
					, LPCSTR pszFaceName);
	virtual	bool CreateFontW( int height, int width, UINT weight, UINT MipLevel
					, BOOL Italic, DWORD CharSet, DWORD OutputPrecision, DWORD Quality, DWORD PitchAndFamily
					, LPCWSTR pszFaceName);
	virtual bool CreateFontIndirectA( const DXFONT_DESCA* lplf );
	virtual bool CreateFontIndirectW( const DXFONT_DESCW* lplf );

	virtual bool	CreateFontFromInfoA( const CDXFontInfo* lpInfo ) { DXFONT_DESCA fd; lpInfo->GetFontDescaA(fd); return CreateFontIndirectA(&fd); }
	virtual bool	CreateFontFromInfoW( const CDXFontInfo* lpInfo ) { DXFONT_DESCW fd; lpInfo->GetFontDescaW(fd); return CreateFontIndirectW(&fd); }

	// tHg폜
	virtual void	DeleteFont(void);

protected:
	// Zbg
	virtual void Reset(void);
	// XgA
	virtual void Restore(void);
};

#endif

}	// end of namespace dx
}	// end of namespace iris

#endif
