//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXFont.cpp
 * @brief		directX tHgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXFont_CPP_

//======================================================================
// include
#include "DXFont.h"
#include "../DXDevice.h"
#include "../../DXError.h"

#include "../../../win/debug/WXDebug.h"
#include "../../../win/debug/WXDebugLeakCheckMacro.h"

namespace iris {
namespace dx
{

//======================================================================
// class

#if	!defined(_IRIS_SUPPORT_DXMOBILE)

// CDXFont
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXFont::CDXFont(void)
: m_pStencil(nullptr)
, m_pFont(nullptr)
, m_Format(DT_LEFT|DT_NOCLIP)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXFont::~CDXFont(void)
{
	Release();
}

/**********************************************************************//**
 *
 * ̈̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	width	= 
 * @param [in]	height	= 
 * @return	
*//***********************************************************************/
bool CDXFont::Create(UINT width, UINT height)
{
	if( !CDXTexture::CreateTexture(width, height, 1, D3DUSAGE_RENDERTARGET, D3DFMT_A8R8G8B8, D3DPOOL_DEFAULT) )
	{
		return false;
	}
	DX_DO_CHECK_RESULT( m_pTexture->GetSurfaceLevel(0, &m_pSurface), return false );

	// XeVobt@
	DX_DO_CHECK_RESULT( GetDevice()->CreateDepthStencilSurface(width, height, GetPresent()->AutoDepthStencilFormat
		, D3DMULTISAMPLE_NONE, 0, 0, &m_pStencil, nullptr ), return false );
	return true;
}

/**********************************************************************//**
 *
 * 
 * 
*//***********************************************************************/
void CDXFont::Release(void)
{
	DX_SAFE_RELEASE( m_pStencil );
	DX_SAFE_RELEASE( m_pFont );
	IDXFontTexture::Release();
}

/**********************************************************************//**
 *
 * ̈̃NA
 * 
*//***********************************************************************/
void CDXFont::Clear(void)
{
	CDXDeviceX pDevice = GetDevice();
	if( pDevice == nullptr ) return;

	LPDXSURFACE pBackSurface = nullptr;
	LPDXSURFACE pPreStencil = nullptr;
	// _O^[QbgύX
	DX_DO_CHECK_RESULT( pDevice.GetRenderTarget(0, &pBackSurface), goto clear_end );
	DX_DO_CHECK_RESULT( pDevice.GetDepthStencilSurface(&pPreStencil), goto clear_end );

	DX_DO_CHECK_RESULT( pDevice.SetRenderTarget(0, m_pSurface), goto clear_end );
	DX_CHECK_RESULT( pDevice.SetDepthStencilSurface(m_pStencil) );

	// eNX`T[tFCX̃NA
	DX_CHECK_RESULT( pDevice.Clear(0, nullptr, 
		D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER,
		D3DCOLOR_ARGB(0,0,0,0), 1.0f, 0) );

	DX_CHECK_RESULT( pDevice.SetRenderTarget(0, pBackSurface) );
	DX_CHECK_RESULT( pDevice.SetDepthStencilSurface(pPreStencil) );

clear_end:
	DX_SAFE_RELEASE( pBackSurface );
	DX_SAFE_RELEASE( pPreStencil );
}

/**********************************************************************//**
 *
 * `(eNX`ɕ`)
 * 
 ----------------------------------------------------------------------
 * @param [in]	x,y		= `ʒuij
 * @param [in]	pString	= 
 * @param [in]	size	= 
 * @return	
*//***********************************************************************/
bool CDXFont::TextOutA(int x, int y, LPCSTR  pString, size_t size)
{
	bool ret = false;
	CDXDeviceX pDevice = GetDevice();
	if( pDevice == nullptr ) return false;

	LPDXSURFACE pBackSurface = nullptr;
	LPDXSURFACE pPreStencil = nullptr;
	DX_DO_CHECK_RESULT( pDevice.BeginScene(), return false );

	// _O^[QbgύX
	DX_DO_CHECK_RESULT( pDevice.GetRenderTarget(0, &pBackSurface), goto textout_end );
	DX_DO_CHECK_RESULT( pDevice.GetDepthStencilSurface(&pPreStencil), goto textout_end );

	DX_DO_CHECK_RESULT( pDevice.SetRenderTarget(0, m_pSurface), goto textout_end );
	DX_CHECK_RESULT( pDevice.SetDepthStencilSurface(m_pStencil) );

	// `
	ret = TextOutDirectA(x, y, 0, 0, pString, size);

	// ɖ߂
	DX_CHECK_RESULT( pDevice.SetRenderTarget(0, pBackSurface) );
	DX_CHECK_RESULT( pDevice.SetDepthStencilSurface(pPreStencil) );

textout_end:
	DX_SAFE_RELEASE( pBackSurface );
	DX_SAFE_RELEASE( pPreStencil );
	pDevice.EndScene();
	return ret;
}
/// CDXFont::TextOutA Q
bool CDXFont::TextOutW(int x, int y, LPCWSTR pString, size_t size)
{
	bool ret = false;
	CDXDeviceX pDevice = GetDevice();
	if( pDevice == nullptr ) return false;

	LPDXSURFACE pBackSurface = nullptr;
	LPDXSURFACE pPreStencil = nullptr;
	DX_DO_CHECK_RESULT( pDevice.BeginScene(), return false );

	// _O^[QbgύX
	DX_DO_CHECK_RESULT( pDevice.GetRenderTarget(0, &pBackSurface), goto textout_end );
	DX_DO_CHECK_RESULT( pDevice.GetDepthStencilSurface(&pPreStencil), goto textout_end );

	DX_DO_CHECK_RESULT( pDevice.SetRenderTarget(0, m_pSurface), goto textout_end );
	DX_CHECK_RESULT( pDevice.SetDepthStencilSurface(m_pStencil) );

	// `
	ret = TextOutDirectW(x, y, 0, 0, pString, size);

	// ɖ߂
	DX_CHECK_RESULT( pDevice.SetRenderTarget(0, pBackSurface) );
	DX_CHECK_RESULT( pDevice.SetDepthStencilSurface(pPreStencil) );

textout_end:
	DX_SAFE_RELEASE( pBackSurface );
	DX_SAFE_RELEASE( pPreStencil );
	pDevice.EndScene();
	return ret;
}

/**********************************************************************//**
 *
 * `(_O^[Qbgɕ`)
 * 
 ----------------------------------------------------------------------
 * @param [in]	x1,y1,x2,y2	= `̈
 * @param [in]	pString		= 
 * @param [in]	size		= 
 * @return	
*//***********************************************************************/
bool CDXFont::TextOutDirectA(int x1, int y1, int x2, int y2, LPCSTR  pString, size_t size)
{
	if( m_pFont == nullptr ) return false;
	LPCDXSPRITE pSprite = GetSprite();
	if( pSprite == nullptr ) return false;
	pSprite->Begin(0);
	RECT rc = { x1, y1, x2, y2 };
	int ret = m_pFont->DrawTextA(pSprite
		, pString
		, (int)size
		, &rc
		, m_Format
		, m_FontColor
		);
	pSprite->End();
	return (ret != 0);
}
/// CDXFont::TextOutDirectA Q
bool CDXFont::TextOutDirectW(int x1, int y1, int x2, int y2, LPCWSTR pString, size_t size)
{
	if( m_pFont == nullptr ) return false;
	LPCDXSPRITE pSprite = GetSprite();
	if( pSprite == nullptr ) return false;
	pSprite->Begin(0);
	RECT rc = { x1, y1, x2, y2 };
	int ret = m_pFont->DrawTextW(pSprite
		, pString
		, (int)size
		, &rc
		, m_Format
		, m_FontColor
		);
	pSprite->End();
	return (ret != 0);
}

/**********************************************************************//**
 *
 * tHg쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	height			= 
 * @param [in]	width			= 
 * @param [in]	weight			= 
 * @param [in]	MipLevel		= ~bv}bvx
 * @param [in]	Italic			= Α
 * @param [in]	CharSet			= LZbg
 * @param [in]	OutputPrecision	= 
 * @param [in]	Quality			= 
 * @param [in]	PitchAndFamily	= 
 * @param [in]	pszFaceName		= tHg
 * @return	
*//***********************************************************************/
bool CDXFont::CreateFontA(  int height
						  , int width
						  , UINT weight
						  , UINT MipLevel
						  , BOOL Italic
						  , DWORD CharSet
						  , DWORD OutputPrecision
						  , DWORD Quality
						  , DWORD PitchAndFamily
						  , LPCSTR pszFaceName
						  )
{
	DXFONT_DESCA fd = { height
						, width
						, weight
						, MipLevel
						, Italic
						, (BYTE)CharSet
						, (BYTE)OutputPrecision
						, (BYTE)Quality
						, (BYTE)PitchAndFamily
						, ""
	};
	strcpy_s( fd.FaceName, sizeof(fd.FaceName), pszFaceName);
	return CreateFontIndirectA(&fd);
}
/// CDXFont::CreateFontA Q
bool CDXFont::CreateFontW(  int height
						  , int width
						  , UINT weight
						  , UINT MipLevel
						  , BOOL Italic
						  , DWORD CharSet
						  , DWORD OutputPrecision
						  , DWORD Quality
						  , DWORD PitchAndFamily
						  , LPCWSTR pszFaceName
						  )
{
	DXFONT_DESCW fd = { height
						, width
						, weight
						, MipLevel
						, Italic
						, (BYTE)CharSet
						, (BYTE)OutputPrecision
						, (BYTE)Quality
						, (BYTE)PitchAndFamily
						, L""
	};
	wcscpy_s( fd.FaceName, sizeof(fd.FaceName)/sizeof(WCHAR), pszFaceName);
	return CreateFontIndirectW(&fd);
}

/**********************************************************************//**
 *
 * tHg쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	lplf	= tHg
 * @return	
*//***********************************************************************/
bool CDXFont::CreateFontIndirectA(const DXFONT_DESCA* lplf)
{
	if( m_pFont != nullptr ) return false;
	LPCDXDEVICE pDevice = GetDevice();
	HRESULT hr = D3DXCreateFontIndirectA(pDevice
		, lplf
		, &m_pFont
		);
	if( FAILED(hr) ) return false;
	TEXTMETRICA tm;
	m_pFont->GetTextMetricsA(&tm);
	m_FontWidth = tm.tmMaxCharWidth;
	m_FontHeight= tm.tmHeight + tm.tmExternalLeading*2;
	return true;
}
/// CDXFont::CreateFontIndirectA Q
bool CDXFont::CreateFontIndirectW(const DXFONT_DESCW* lplf)
{
	if( m_pFont != nullptr ) return false;
	LPCDXDEVICE pDevice = GetDevice();
	HRESULT hr = D3DXCreateFontIndirectW(pDevice
		, lplf
		, &m_pFont
		);
	if( FAILED(hr) ) return false;
	TEXTMETRICW tm;
	m_pFont->GetTextMetricsW(&tm);
	m_FontWidth = tm.tmMaxCharWidth;
	m_FontHeight= tm.tmHeight + tm.tmExternalLeading*2;
	return true;
}

/**********************************************************************//**
 *
 * tHg폜
 *
*//***********************************************************************/
void CDXFont::DeleteFont(void)
{
	DX_SAFE_RELEASE( m_pFont );
}

/**********************************************************************//**
 *
 * Zbg
 *
*//***********************************************************************/
void CDXFont::Reset(void)
{
	m_pFont->OnLostDevice();
	DX_SAFE_RELEASE( m_pStencil );
	IDXFontTexture::Reset();
	CDXTexture::Release();
}

/**********************************************************************//**
 *
 * XgA
 *
*//***********************************************************************/
void CDXFont::Restore(void)
{
	m_pFont->OnResetDevice();
	IDXFontTexture::Restore();
	Create(m_Width, m_Height);
	Clear();
}

#endif

}	// end of namespace dx
}	// end of namespace iris


#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../debug/DXDebugUnitTest.h"
#include "../DXObjectManager.h"
#include "../scene/DXCamera.h"
#include "iris_iostream.h"
#include "iris_using.h"

//======================================================================
// function
static LRESULT CALLBACK WindowProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

//======================================================================
// test
IRIS_UNITTEST_B(CDXFontUnitTest, iris::dx::dbg::CDXUnitTestBase, Func)
{
	static const UINT WINDOW_STYLE		= WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX;
	static const UINT WINDOW_STYLEEX	= WS_EX_OVERLAPPEDWINDOW;
	HWND hWnd = nullptr;

	RECT src = {0, 0, 640, 480};

	// EBhEg̒
	AdjustWindowRectEx(&src, WINDOW_STYLE, FALSE, WINDOW_STYLEEX);

	hWnd = wx::dbg::CreateUnitTestWindow(WINDOW_STYLEEX, m_TestName, m_TestName, WINDOW_STYLE
		, src.right, src.bottom, WindowProc);

	// EBhE̍쐬Ɏs
	if( hWnd == nullptr )
		return;

	ShowWindow( hWnd, SW_HIDE );
	CDXDevice dev(hWnd);
	CDXObjectManager objMan(&dev.GetDXSwapChain());
	if( !dev.CreateDevice(src.right, src.bottom, false, false, false, false, false, false) )
	{
		return;
	}
	dev.CreateSprite();
	objMan.CreateLayer<CDXDefaultLayer>(0);
	//CDXCamera* pCamera = devEx.CreateObject<CDXCamera>();
	//pCamera->SetPos(D3DXVECTOR3(0.0f, 0.0f, -10.0f));
	//pCamera->SetViewport();
	//pCamera->Activate();

	IDXFontTexture* pFont = objMan.CreateLayerObject<CDXFont>(0);

	CHAR buf[256] = "TEST";
#ifndef _IRIS_SUPPORT_AUTO_UNITTEST
	std::cout << "͂ĂB" << std::endl;
	std::cin >> buf;
#endif

	pFont->Create(src.right, src.bottom);
	pFont->CreateFont(50,0,FW_NORMAL,0,0,0
		, SHIFTJIS_CHARSET
		, OUT_TT_PRECIS
		, PROOF_QUALITY
		, FIXED_PITCH | FF_MODERN
		, TEXT("lr ") );
	pFont->Clear();
	pFont->SetFontColor(0xFF22FF22);
	pFont->TextOutA(0, 0, buf, strlen(buf) ); 
	pFont->EnableRenderState(DXRS_DRAWSPRITE);
	pFont->SetWorldPos( &D3DXVECTOR3(0.0f, 0.0f, 0.0f) );

	this->SetDevice(&dev);

	// EBhE`
	ShowWindow( hWnd, SW_SHOW );
	// EBhE̍XV
	UpdateWindow( hWnd );
	// őOʂ
	SetForegroundWindow(hWnd);

	wx::dbg::UnitTestMainLoop(hWnd);
}


//**********************************************************************
//
// eXgpEBhEvV[W
// 
//----------------------------------------------------------------------
// @param	hWnd	EBhEnh
// @param	uMsg	sꂽbZ[W
// @param	wParam	sꂽbZ[W@
// @param	lParam	sꂽbZ[WA
// @return	LRESULTl
//**********************************************************************
LRESULT CALLBACK WindowProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	// bZ[W̏
	switch( uMsg )
	{
	case WM_DESTROY:
		PostQuitMessage( 0 );
		break;
	case WM_CLOSE:
		DestroyWindow( hWnd );
		break;
	case WM_KEYUP:
		switch( wParam )
		{
		case VK_ESCAPE:
			DestroyWindow( hWnd );
			break;
		}
		break;
	case WM_PAINT:
		{
			iris::dx::dbg::CDXUnitTestBase* pUT = iris::dx::dbg::CDXUnitTestBase::GetCurrent();
			pUT->Draw();
		}
		break;
	default:
		return DefWindowProc( hWnd, uMsg, wParam, lParam );
		break;
	}

	return 0L;
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
