//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXObjectManager.h
 * @brief		DirectXfoCXǗ(@\g)t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXObjectManager_H_
#define INCG_IRIS_DXObjectManager_H_

//======================================================================
// include
#include "DXDevice.h"
#include "DXSwapChain.h"

namespace iris {
namespace dx
{

//======================================================================
// class
//! DXObjectǗNX
class CDXObjectManager : public INonCopyable<>
{
public:
	typedef std::vector<IDXLayer*>	vecLayer;
	typedef CDXDevice::vecObj		vecObj;

protected:
	IDXSwapChain*	m_pSwapChain;	//!< Xbv`F[NX
	vecObj			m_newObj;		//!< ObjǗXg
	vecLayer		m_newLayer;		//!< LayerǗXg
public:

	// RXgN^
	explicit CDXObjectManager(IDXSwapChain* pSwapChain);
	// fXgN^
	virtual ~CDXObjectManager(void);

public:

	//
	// Object

	/// IuWFNg̍쐬
	template<class _TC>
	_TC*	CreateObject(void)
	{
		_TC* p = m_pSwapChain->CreateObject<_TC>();
		if( p != nullptr )	m_newObj.push_back(p);
		return p;
	}

	/// IuWFNg̍쐬iC[o^sj
	template<class _TC>
	_TC*	CreateLayerObject(int LayerID)
	{
		_TC* p = m_pSwapChain->CreateObject<_TC>();
		if( p != nullptr )	
		{
			if( !m_pSwapChain->RegisterObject(LayerID, p) )
			{
				DX_SAFE_DELETE(p);
				return nullptr;
			}
			m_newObj.push_back(p);
		}
		return p;
	}

	bool	DeleteObject(IDXGXObject* obj);
	void	DeleteObjectAll(void);
	bool	EraseLayerObject(int LayerID, IDXLayerObject* obj);

public:

	//
	// Layer

	/// C[̍쐬
	template<class _TC>
	_TC*	CreateLayer(int LayerID)
	{
		_TC* p = new _TC;
		if( !m_pSwapChain->RegisterLayer(LayerID, p) )
		{
			DX_SAFE_DELETE(p);
			return nullptr;
		}
		m_newLayer.push_back(p);
		return p;
	}

	// C[̍폜(Ǘ̃C[delete)
	virtual	bool	DeleteLayer(int LayerID);
	virtual	bool	DeleteLayer(IDXLayer* layer);
	virtual	void	DeleteLayerAll(void);

	/// S
	virtual void	Release(void)	{ DeleteObjectAll(); DeleteLayerAll(); }

public:
	// get
	IDXSwapChain*			GetDXSwapChain(void)	{ return m_pSwapChain; }	//!< get CDXSwapChain&.
			CDXDevice*		GetDXDevice(void)		{ return m_pSwapChain->GetDXDevice(); }	//!< get CDXDevice&.
	const	CDXDevice*		GetDXDevice(void) const	{ return m_pSwapChain->GetDXDevice(); }	//!< get CDXDevice&.
	
};

}	// end of namespace dx
}	// end of namespace iris

#endif
