//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXError.cpp
 * @brief		DirectXG[R[ht@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXError_CPP_

//======================================================================
// include
#include "DXError.h"

namespace iris {
namespace dx
{

/**********************************************************************//**
 *
 * G[擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hr		= HRESULTl
 * @param [out]	lpBuf	= o̓obt@
 * @param [in]	size	= o̓obt@TCY
*//***********************************************************************/
void DXFormatMessage (HRESULT hr, LPTSTR lpBuf, size_t size)
{
#ifdef UNICODE
	DXFormatMessageW(hr, lpBuf, size);
#else
	DXFormatMessageA(hr, lpBuf, size);
#endif
}

#ifdef _IRIS_DX_SUPPORT_DXERR

//======================================================================
// link
#if	defined(_IRIS_SUPPORT_DXMOBILE)
#  pragma comment( lib, "d3dmxerr.lib" )
#else
#  pragma comment( lib, "dxerr.lib" )
#endif

//======================================================================
// function

/// DXFormatMessage Q
void DXFormatMessageA(HRESULT hr, LPSTR lpBuf, size_t size)
{
	if( lpBuf == nullptr ) return;
	strcpy_s(lpBuf, size, DXGetErrorStringA(hr));
}
/// DXFormatMessage Q
void DXFormatMessageW(HRESULT hr, LPWSTR lpBuf, size_t size)
{
	if( lpBuf == nullptr ) return;
	wcscpy_s(lpBuf, size, DXGetErrorStringW(hr));
}

#else

//======================================================================
// include
#include <dsound.h>

//======================================================================
// define
#define TEXTA(t)	t
#define TEXTW(t)	L##t
#define CASE(_func, _text, _name)	case _name:		\
	_func(lpBuf, size, _text(#_name));				\
	break


#if	defined(_IRIS_SUPPORT_DXMOBILE)
#define _SWITCH_ERROR_MESSAGE(func, text)								\
	switch( hr )														\
	{																	\
	CASE(func, text, D3DM_OK);											\
	CASE(func, text, D3DM_GENERICFAILURE);								\
																		\
	CASE(func, text, D3DMERR_DRIVERINTERNALERROR);						\
	CASE(func, text, D3DMERR_INVALIDDEVICE);							\
	CASE(func, text, D3DMERR_INVALIDCALL);								\
	CASE(func, text, D3DMERR_DRIVERINVALIDCALL);						\
	CASE(func, text, D3DMERR_DRIVERUNSUPPORTED);						\
																		\
	CASE(func, text, D3DMERR_WRONGTEXTUREFORMAT);						\
	CASE(func, text, D3DMERR_UNSUPPORTEDCOLOROPERATION);				\
	CASE(func, text, D3DMERR_UNSUPPORTEDCOLORARG);						\
	CASE(func, text, D3DMERR_UNSUPPORTEDALPHAOPERATION);				\
	CASE(func, text, D3DMERR_UNSUPPORTEDALPHAARG);						\
	CASE(func, text, D3DMERR_TOOMANYOPERATIONS);						\
	CASE(func, text, D3DMERR_CONFLICTINGTEXTUREFILTER);					\
	CASE(func, text, D3DMERR_UNSUPPORTEDFACTORVALUE);					\
	CASE(func, text, D3DMERR_CONFLICTINGRENDERSTATE);					\
	CASE(func, text, D3DMERR_UNSUPPORTEDTEXTUREFILTER);					\
	CASE(func, text, D3DMERR_CONFLICTINGTEXTUREPALETTE);				\
																		\
	CASE(func, text, D3DMERR_NOTFOUND);									\
	CASE(func, text, D3DMERR_MOREDATA);									\
	CASE(func, text, D3DMERR_DEVICELOST);								\
	CASE(func, text, D3DMERR_DEVICENOTRESET);							\
	CASE(func, text, D3DMERR_NOTAVAILABLE);								\
	CASE(func, text, D3DMERR_MEMORYPOOLEMPTY);							\
	CASE(func, text, D3DMERR_ALREADYLOCKED);							\
	}																	\
	return

#else

#define _SWITCH_ERROR_MESSAGE(func, text)					\
	switch( hr ) {											\
	CASE(func, text, D3D_OK);								\
															\
	CASE(func, text, D3DERR_WRONGTEXTUREFORMAT);			\
	CASE(func, text, D3DERR_UNSUPPORTEDCOLOROPERATION);		\
	CASE(func, text, D3DERR_UNSUPPORTEDCOLORARG);			\
	CASE(func, text, D3DERR_UNSUPPORTEDALPHAOPERATION);		\
	CASE(func, text, D3DERR_UNSUPPORTEDALPHAARG);			\
	CASE(func, text, D3DERR_TOOMANYOPERATIONS);				\
	CASE(func, text, D3DERR_CONFLICTINGTEXTUREFILTER);		\
	CASE(func, text, D3DERR_UNSUPPORTEDFACTORVALUE);		\
	CASE(func, text, D3DERR_CONFLICTINGRENDERSTATE);		\
	CASE(func, text, D3DERR_UNSUPPORTEDTEXTUREFILTER);		\
	CASE(func, text, D3DERR_CONFLICTINGTEXTUREPALETTE);		\
	CASE(func, text, D3DERR_DRIVERINTERNALERROR);			\
															\
	CASE(func, text, D3DERR_NOTFOUND);						\
	CASE(func, text, D3DERR_MOREDATA);						\
	CASE(func, text, D3DERR_DEVICELOST);					\
	CASE(func, text, D3DERR_DEVICENOTRESET);				\
	CASE(func, text, D3DERR_NOTAVAILABLE);					\
	CASE(func, text, D3DERR_OUTOFVIDEOMEMORY);				\
	CASE(func, text, D3DERR_INVALIDDEVICE);					\
	CASE(func, text, D3DERR_INVALIDCALL);					\
	CASE(func, text, D3DERR_DRIVERINVALIDCALL);				\
	CASE(func, text, D3DERR_WASSTILLDRAWING);				\
	CASE(func, text, D3DOK_NOAUTOGEN);						\
															\
	CASE(func, text, DS_NO_VIRTUALIZATION);					\
	CASE(func, text, DSERR_ALLOCATED);						\
	CASE(func, text, DSERR_CONTROLUNAVAIL);					\
	CASE(func, text, DSERR_INVALIDPARAM);					\
	CASE(func, text, DSERR_INVALIDCALL);					\
	CASE(func, text, DSERR_GENERIC);						\
	CASE(func, text, DSERR_PRIOLEVELNEEDED);				\
	CASE(func, text, DSERR_OUTOFMEMORY);					\
	CASE(func, text, DSERR_BADFORMAT);						\
	CASE(func, text, DSERR_UNSUPPORTED);					\
	CASE(func, text, DSERR_NODRIVER);						\
	CASE(func, text, DSERR_ALREADYINITIALIZED);				\
	CASE(func, text, DSERR_BUFFERLOST);						\
	CASE(func, text, DSERR_OTHERAPPHASPRIO);				\
	CASE(func, text, DSERR_UNINITIALIZED);					\
	CASE(func, text, DSERR_NOINTERFACE);					\
	CASE(func, text, DSERR_ACCESSDENIED);					\
	CASE(func, text, DSERR_BUFFERTOOSMALL);					\
	CASE(func, text, DSERR_DS8_REQUIRED);					\
	CASE(func, text, DSERR_SENDLOOP);						\
	CASE(func, text, DSERR_BADSENDBUFFERGUID);				\
	CASE(func, text, DSERR_OBJECTNOTFOUND);					\
	CASE(func, text, DSERR_FXUNAVAILABLE);					\
	}																	\
	return
#endif

//======================================================================
// function

/// DXFormatMessage Q
void DXFormatMessageA(HRESULT hr, LPSTR lpBuf, size_t size)
{
	if( lpBuf == nullptr ) return;
	_SWITCH_ERROR_MESSAGE(strcpy_s, TEXTA);
}
/// DXFormatMessage Q
void DXFormatMessageW(HRESULT hr, LPWSTR lpBuf, size_t size)
{
	if( lpBuf == nullptr ) return;
	_SWITCH_ERROR_MESSAGE(wcscpy_s, TEXTW);
}

#endif

}	// end of namespace xdx
}	// end of namespace iris
