//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXDirectInput.cpp
 * @brief		DirectInput t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXDirectInput_CPP_

//======================================================================
// include
#include "DXDirectInput.h"
#include "DxError.h"
#include "iris_debug.h"

//======================================================================
// link
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
#  pragma comment (lib,"dinput8.lib")
#  pragma comment (lib, "dxguid.lib")
#else
#endif

//======================================================================
// define
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
#  define	DXINPUTLIB_NAME		"dinput8"
#else
#  define	DXINPUTLIB_NAME		"dinput8"
#endif

#define DXINPUTLIB_FILENAME		DXINPUTLIB_NAME IRIS_LIB_POSTFIX ".dll"

namespace iris {
namespace dx
{

//======================================================================
// variable
namespace 
{
	static CDirectInput	s_DirectInput;
}

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDirectInput::CDirectInput(void)
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
: m_lpDI8(nullptr)
#endif
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDirectInput::~CDirectInput(void)
{
	Unload();
}

/**********************************************************************//**
 *
 * [h
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CDirectInput::Load(void)
{
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	if( !m_Module.IsValid() )
	{
		if( !m_Module.Load(DXINPUTLIB_FILENAME) ) return false;
	}

	if( m_lpDI8 == nullptr )
	{
		typedef HRESULT (WINAPI *_DirectInput8Create)(HINSTANCE hinst, DWORD dwVersion, REFIID riidltf, LPVOID *ppvOut, LPUNKNOWN punkOuter);
		_DirectInput8Create DInputCreate = reinterpret_cast<_DirectInput8Create>(m_Module.GetProcAddress("DirectInput8Create"));
		if( DInputCreate == nullptr ) return false;

		HRESULT hr = (*DInputCreate)( GetModuleHandle(nullptr), DIRECTINPUT_VERSION, IID_IDirectInput8, (void**)&m_lpDI8, nullptr );
		if( FAILED(hr) )
		{
			DX_ERROR(hr);
			return false;
		}
	}
	return true;
#else
	return false;
#endif
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CDirectInput::Unload(void)
{
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	DX_SAFE_RELEASE( m_lpDI8 );
	m_Module.Release();
#endif
}

}	// end of namespace dx
}	// end of namespace iris

