//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXDirect3D.h
 * @brief		Direct3D t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXDirect3D_H_
#define INCG_IRIS_DXDirect3D_H_

//======================================================================
// include
#include "dx_inchead.h"
#include "../win/os/WXModule.h"
#include "fnd/container/FndSingleton.h"

namespace iris {
namespace dx
{

/**
 * @brief	Direct3D NX
*/
class CDirect3D : public fnd::CSingleton<CDirect3D>
{
private:
	LPDIRECT3D		m_lpD3D;
	wx::CModule		m_Module;	//!< W[

public:
	// RXgN^
	CDirect3D(void);
	// fXgN^
	~CDirect3D(void);

public:
	/**
	 * @name	operator
	 * @{
	*/
	LPDIRECT3D	operator -> (void)			{ return m_lpD3D; }
	LPCDIRECT3D	operator -> (void)	const	{ return m_lpD3D; }
	/**
	 * @}
	*/
public:
	// [h
	bool	Load(void);
	// 
	void	Unload(void);

public:
	HRESULT	CreateDevice(UINT Adapter, DXDEVTYPE DeviceType, HWND hFocusWindow, ULONG BehaviorFlags
		, LPDXPRESENT_PARAMETERS pPresentationParameters, LPDXDEVICE* ppReturnedDeviceInterface);

	HRESULT	CheckDeviceMultiSampleType(UINT Adapter, DXDEVTYPE DeviceType, D3DFORMAT SurfaceFormat
		, BOOL Windowed, D3DMULTISAMPLE_TYPE MultiSampleType, LPDWORD lpQualityLevels);

public:
	/// LPDIRECT3D 擾
	LPDIRECT3D	GetDirect3D(void)			{ return m_lpD3D; }
	LPCDIRECT3D	GetDirect3D(void)	const	{ return m_lpD3D; }
};

}	// end of namespace dx
}	// end of namespace iris

#endif
