//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WceWrapShell.h
 * @brief		shell ֌Wbv֐Q t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WceWrapShell_CPP_

//======================================================================
// include
#include "WceWrapShell.h"
#include <shlwapi.h>

#if	defined(IRIS_WIN32_WCE)

//======================================================================
// link
#if defined(IRIS_MSC)
#  pragma comment (lib, "ceshell.lib")
#  pragma comment (lib, "aygshell.lib")
#endif

#ifdef UNICODE
WINSHELLAPI BOOL WINAPI ShellExecuteEx(LPSHELLEXECUTEINFOA lpExecInfo);
#else
WINSHELLAPI BOOL WINAPI ShellExecuteEx(LPSHELLEXECUTEINFOW lpExecInfo);
#endif

//======================================================================
// function
/**********************************************************************//**
 * @internal
 *
 * SHBrowseForFolderA
 *
 -----------------------------------------------------------------------
 * @param [in]	lpbi = 
 * @return 
*//***********************************************************************/
EXTERN_C PIDLIST_ABSOLUTE SHBrowseForFolderA(LPBROWSEINFOA lpbi)
{
#if defined(UNDER_NT)
	return SHBrowseForFolder(lpbi);
#else
	return nullptr;
#endif
}

/**********************************************************************//**
 * @internal
 *
 * SHBrowseForFolderW
 *
 -----------------------------------------------------------------------
 * @param [in]	lpbi = 
 * @return 
*//***********************************************************************/
EXTERN_C PIDLIST_ABSOLUTE SHBrowseForFolderW(LPBROWSEINFOW lpbi)
{
#if defined(UNDER_NT)
	return SHBrowseForFolder(lpbi);
#else
	return nullptr;
#endif
}

#if defined(UNDER_NT)

/**********************************************************************//**
 * @internal
 *
 * SHGetFolderPath
 *
 -----------------------------------------------------------------------
 * @param [in]	hwnd		= EBhEnh
 * @param [in]	csidl		= CSIDLl
 * @param [in]	hToken		= 
 * @param [in]	dwFlags		= 
 * @param [out]	pszPath		= o̓obt@
 * @return 
*//***********************************************************************/
EXTERN_C HRESULT STDAPICALLTYPE SHGetFolderPathA(HWND hwnd, int csidl, HANDLE hToken, DWORD dwFlags, __out_ecount(MAX_PATH) LPSTR pszPath)
{
	LPITEMIDLIST lpidl;
	HRESULT hr = SHGetSpecialFolderLocation(hwnd, csidl, &lpidl);
	if( FAILED(hr) ) return hr;
	LPSHELLFOLDER lpshf;
	hr = SHGetDesktopFolder(&lpshf);
	if( FAILED(hr) ) return hr;
	STRRET str;
	hr = lpshf->GetDisplayNameOf(lpidl, dwFlags, &str);
	if( FAILED(hr) ) return hr;
#if 0
	LPSTR path;
	hr = StrRetToStrA(&str, lpidl, &path);
#else
	CHAR path[MAX_PATH];
	hr = StrRetToBufA(&str, lpidl, path, MAX_PATH);
#endif
	strcpy(pszPath, path);
	CoTaskMemFree(path);
	return hr;
}
EXTERN_C HRESULT STDAPICALLTYPE SHGetFolderPathW(HWND hwnd, int csidl, HANDLE hToken, DWORD dwFlags, __out_ecount(MAX_PATH) LPWSTR pszPath)
{
	LPITEMIDLIST lpidl;
	HRESULT hr = SHGetSpecialFolderLocation(hwnd, csidl, &lpidl);
	if( FAILED(hr) ) return hr;
	LPSHELLFOLDER lpshf;
	hr = SHGetDesktopFolder(&lpshf);
	if( FAILED(hr) ) return hr;
	STRRET str;
	hr = lpshf->GetDisplayNameOf(lpidl, dwFlags, &str);
	if( FAILED(hr) ) return hr;
#if 0
	LPWSTR path;
	hr = StrRetToStrW(&str, lpidl, &path);
#else
	WCHAR path[MAX_PATH];
	hr = StrRetToBufW(&str, lpidl, path, MAX_PATH);
#endif
	wcscpy(pszPath, path);
	CoTaskMemFree(path);
	return hr;
}

/**********************************************************************//**
 * @internal
 *
 * SHGetPathFromIDList
 *
 -----------------------------------------------------------------------
 * @param [in]	pidl		= 
 * @param [out]	pszPath		= o̓obt@
 * @return 
*//***********************************************************************/
EXTERN_C BOOL STDAPICALLTYPE SHGetPathFromIDListA(PCIDLIST_ABSOLUTE pidl, __out_ecount(MAX_PATH) LPSTR pszPath)
{
	HRESULT hr;
	LPSHELLFOLDER lpshf;
	hr = SHGetDesktopFolder(&lpshf);
	if( FAILED(hr) ) return FALSE;
	STRRET str;
	hr = lpshf->GetDisplayNameOf(pidl, SHGDN_NORMAL, &str);
	if( FAILED(hr) ) return FALSE;
#if 0
	LPSTR path;
	hr = StrRetToStrA(&str, pidl, &path);
#else
	CHAR path[MAX_PATH];
	hr = StrRetToBufA(&str, pidl, path, MAX_PATH);
#endif
	strcpy(pszPath, path);
	CoTaskMemFree(path);
	return TRUE;
}
EXTERN_C BOOL STDAPICALLTYPE SHGetPathFromIDListW(PCIDLIST_ABSOLUTE pidl, __out_ecount(MAX_PATH) LPWSTR pszPath)
{
	HRESULT hr;
	LPSHELLFOLDER lpshf;
	hr = SHGetDesktopFolder(&lpshf);
	if( FAILED(hr) ) return FALSE;
	STRRET str;
	hr = lpshf->GetDisplayNameOf(pidl, SHGDN_NORMAL, &str);
	if( FAILED(hr) ) return FALSE;
#if 0
	LPWSTR path;
	hr = StrRetToStrW(&str, pidl, &path);
#else
	WCHAR path[MAX_PATH];
	hr = StrRetToBufW(&str, pidl, path, MAX_PATH);
#endif
	wcscpy(pszPath, path);
	CoTaskMemFree(path);
	return TRUE;
}

#endif

/**********************************************************************//**
 * @internal
 *
 * SHGetFileInfo
 *
 -----------------------------------------------------------------------
 * @param [in]	pszPath				= pX
 * @param [in]	dwFileAttributes	= t@C
 * @param [in]	psfi				= 
 * @param [in]	cbFileInfo			= 
 * @param [in]	uFlags				= 
 * @return 
*//***********************************************************************/
EXTERN_C DWORD_PTR STDAPICALLTYPE SHGetFileInfoA(LPCSTR pszPath, DWORD dwFileAttributes, __inout_bcount_opt(cbFileInfo) SHFILEINFOA *psfi,
    UINT cbFileInfo, UINT uFlags)
{
#ifdef UNICODE
	WCHAR path[MAX_PATH];
	mbstowcs(path, pszPath, MAX_PATH);
	SHFILEINFOW shfi;
	DWORD_PTR ret = SHGetFileInfo(path, dwFileAttributes, &shfi, cbFileInfo, uFlags);
	if( psfi != nullptr )
	{
		psfi->hIcon = shfi.hIcon;
		psfi->iIcon = shfi.iIcon;
		psfi->dwAttributes = shfi.dwAttributes;
		wcstombs(psfi->szDisplayName, shfi.szDisplayName, IRIS_NumOfElements(psfi->szDisplayName));
		wcstombs(psfi->szTypeName, shfi.szTypeName, IRIS_NumOfElements(psfi->szTypeName));
	}
	return ret;
#else
	return SHGetFileInfo(pszPath, dwFileAttributes, psfi, cbFileInfo, uFlags);
#endif
}
EXTERN_C DWORD_PTR STDAPICALLTYPE SHGetFileInfoW(LPCWSTR pszPath, DWORD dwFileAttributes, __inout_bcount_opt(cbFileInfo) SHFILEINFOW *psfi,
    UINT cbFileInfo, UINT uFlags)
{
#ifdef UNICODE
	return SHGetFileInfo(pszPath, dwFileAttributes, psfi, cbFileInfo, uFlags);
#else
	CHAR path[MAX_PATH];
	wcstombs(path, pszPath, MAX_PATH);
	SHFILEINFOA shfi;
	DWORD_PTR ret = SHGetFileInfo(pszPath, dwFileAttributes, &shfi, cbFileInfo, uFlags);
	if( psfi != nullptr )
	{
		psfi->hIcon = shfi.hIcon;
		psfi->iIcon = shfi.iIcon;
		psfi->dwAttributes = shfi.dwAttributes;
		mbstowcs(psfi->szDisplayName, shfi.szDisplayName, IRIS_NumOfElements(psfi->szDisplayName));
		mbstowcs(psfi->szTypeName, shfi.szTypeName, IRIS_NumOfElements(psfi->szTypeName));
	}
	return ret;
#endif
}

/**********************************************************************//**
 * @internal
 *
 * ShellExecuteEx
 *
 -----------------------------------------------------------------------
 * @param [in]	lpExecInfo	= ݒ
 * @return 
*//***********************************************************************/
EXTERN_C BOOL STDAPICALLTYPE ShellExecuteExA(__inout LPSHELLEXECUTEINFOA lpExecInfo)
{
#if !defined(IRIS_WIN32_WCE)
	return ShellExecuteEx(lpExecInfo);
#else
	return FALSE;
#endif
}
EXTERN_C BOOL STDAPICALLTYPE ShellExecuteExW(__inout LPSHELLEXECUTEINFOW lpExecInfo)
{
	return ShellExecuteEx(lpExecInfo);
}

/**********************************************************************//**
 * @internal
 *
 * ShellExecute
 *
 -----------------------------------------------------------------------
 * @param [in]	hwnd			= eEBhE
 * @param [in]	lpOperation		= R}h
 * @param [in]	lpFile			= t@CpX
 * @param [in]	lpParameters	= 
 * @param [in]	lpDirectory		= ƃfBNg
 * @param [in]	nShowCmd		= \ݒ
 * @return CX^X
*//***********************************************************************/
EXTERN_C HINSTANCE STDAPICALLTYPE ShellExecuteA(HWND hwnd, LPCSTR lpOperation, LPCSTR lpFile, LPCSTR lpParameters,
    LPCSTR lpDirectory, INT nShowCmd)
{
	SHELLEXECUTEINFOA sei;
	ZeroMemory(&sei, sizeof(sei));
	sei.cbSize = sizeof(sei);
	sei.hwnd = hwnd;
	sei.lpVerb = lpOperation;
	sei.lpFile = lpFile;
	sei.lpParameters = lpParameters;
	sei.lpDirectory = lpDirectory;
	sei.nShow = nShowCmd;
	if( !ShellExecuteExA(&sei) ) return nullptr;
	CloseHandle(sei.hProcess);
	return sei.hInstApp;
}
EXTERN_C HINSTANCE STDAPICALLTYPE ShellExecuteW(HWND hwnd, LPCWSTR lpOperation, LPCWSTR lpFile, LPCWSTR lpParameters,
    LPCWSTR lpDirectory, INT nShowCmd)
{
	SHELLEXECUTEINFOW sei;
	ZeroMemory(&sei, sizeof(sei));
	sei.cbSize = sizeof(sei);
	sei.hwnd = hwnd;
	sei.lpVerb = lpOperation;
	sei.lpFile = lpFile;
	sei.lpParameters = lpParameters;
	sei.lpDirectory = lpDirectory;
	sei.nShow = nShowCmd;
	if( !ShellExecuteExW(&sei) ) return nullptr;
	CloseHandle(sei.hProcess);
	return sei.hInstApp;
}

#endif

