//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WceWrapMMSystem.h
 * @brief		mmsystem ֌Wbv֐Q t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WceWrapMMSystem_H_
#define INCG_IRIS_WceWrapMMSystem_H_

//======================================================================
// include
#include "iris_inchead.h"

#if	defined(IRIS_WIN32_WCE)

//======================================================================
// define
//#define __IRIS_WCEWRAP_MMSYSTEM	// TODO : T|[g

//======================================================================
// define
#ifdef UNICODE
#define mmioStringToFOURCC		mmioStringToFOURCCW
#define mmioInstallIOProc		mmioInstallIOProcW
#define mmioOpen				mmioOpenW
#define mmioRename				mmioRenameW
#else
#define mmioStringToFOURCC		mmioStringToFOURCCA
#define mmioInstallIOProc		mmioInstallIOProcA
#define mmioOpen				mmioOpenA
#define mmioRename				mmioRenameA
#endif

#ifndef MMIO_FHOPEN
#  define MMIO_FHOPEN			0x0010
#endif
#ifndef MMIO_EMPTYBUF
#  define MMIO_EMPTYBUF			0x0010
#endif
#ifndef MMIO_TOUPPER
#  define MMIO_TOUPPER			0x0010
#endif
#ifndef MMIO_INSTALLPROC
# define MMIO_INSTALLPROC		0x00010000
#endif
#ifndef MMIO_GLOBALPROC
# define MMIO_GLOBALPROC		0x10000000
#endif
#ifndef MMIO_REMOVEPROC
# define MMIO_REMOVEPROC		0x00020000
#endif
#ifndef MMIO_UNICODEPROC
# define MMIO_UNICODEPROC		0x01000000
#endif
#ifndef MMIO_FINDPROC
# define MMIO_FINDPROC			0x00040000
#endif
#ifndef MMIO_FINDCHUNK
# define MMIO_FINDCHUNK			0x0010
#endif
#ifndef MMIO_FINDRIFF
# define MMIO_FINDRIFF			0x0020
#endif
#ifndef MMIO_FINDLIST
# define MMIO_FINDLIST			0x0040
#endif
#ifndef MMIO_CREATERIFF
# define MMIO_CREATERIFF		0x0020
#endif
#ifndef MMIO_CREATELIST
# define MMIO_CREATELIST		0x0040
#endif

//======================================================================
// function

WINMMAPI FOURCC		WINAPI mmioStringToFOURCCA( LPCSTR sz, UINT uFlags);
WINMMAPI FOURCC		WINAPI mmioStringToFOURCCW( LPCWSTR sz, UINT uFlags);
#if 0	// TODO : 
WINMMAPI LPMMIOPROC WINAPI mmioInstallIOProcA( FOURCC fccIOProc, LPMMIOPROC pIOProc, DWORD dwFlags);
WINMMAPI LPMMIOPROC WINAPI mmioInstallIOProcW( FOURCC fccIOProc, LPMMIOPROC pIOProc, DWORD dwFlags);
WINMMAPI HMMIO		WINAPI mmioOpenA( LPSTR pszFileName,  LPMMIOINFO pmmioinfo,  DWORD fdwOpen);
WINMMAPI HMMIO		WINAPI mmioOpenW( LPWSTR pszFileName, LPMMIOINFO pmmioinfo,  DWORD fdwOpen);
WINMMAPI MMRESULT	WINAPI mmioRenameA( LPCSTR pszFileName, LPCSTR pszNewFileName, LPCMMIOINFO pmmioinfo, DWORD fdwRename);
WINMMAPI MMRESULT	WINAPI mmioRenameW( LPCWSTR pszFileName, LPCWSTR pszNewFileName, LPCMMIOINFO pmmioinfo, DWORD fdwRename);

WINMMAPI MMRESULT	WINAPI mmioClose( HMMIO hmmio, UINT fuClose);
WINMMAPI LONG		WINAPI mmioRead( HMMIO hmmio, HPSTR pch, LONG cch);
WINMMAPI LONG		WINAPI mmioWrite( HMMIO hmmio, const char _huge* pch, LONG cch);
WINMMAPI LONG		WINAPI mmioSeek( HMMIO hmmio, LONG lOffset, int iOrigin);
WINMMAPI MMRESULT	WINAPI mmioGetInfo( HMMIO hmmio, LPMMIOINFO pmmioinfo, UINT fuInfo);
WINMMAPI MMRESULT	WINAPI mmioSetInfo( HMMIO hmmio, LPCMMIOINFO pmmioinfo, UINT fuInfo);
WINMMAPI MMRESULT	WINAPI mmioSetBuffer( HMMIO hmmio, LPSTR pchBuffer, LONG cchBuffer, UINT fuBuffer);
WINMMAPI MMRESULT	WINAPI mmioFlush( HMMIO hmmio, UINT fuFlush);
WINMMAPI MMRESULT	WINAPI mmioAdvance( HMMIO hmmio, LPMMIOINFO pmmioinfo, UINT fuAdvance);
WINMMAPI LRESULT	WINAPI mmioSendMessage( HMMIO hmmio, UINT uMsg, LPARAM lParam1, LPARAM lParam2);
WINMMAPI MMRESULT	WINAPI mmioDescend( HMMIO hmmio, LPMMCKINFO pmmcki, const MMCKINFO FAR* pmmckiParent, UINT fuDescend);
WINMMAPI MMRESULT	WINAPI mmioAscend( HMMIO hmmio, LPMMCKINFO pmmcki, UINT fuAscend);
WINMMAPI MMRESULT	WINAPI mmioCreateChunk(HMMIO hmmio, LPMMCKINFO pmmcki, UINT fuCreate);

#endif

#endif

#endif
