//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WceWrapMMSystem.h
 * @brief		mmsystem ֌Wbv֐Q t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WceWrapMMSystem_CPP_

//======================================================================
// include
#include "WceWrapMMSystem.h"
#include "iris_debug.h"

#if	defined(IRIS_WIN32_WCE)

//======================================================================
// function
WINMMAPI FOURCC		WINAPI mmioStringToFOURCCA( LPCSTR sz, UINT uFlags)
{
	if( sz == nullptr ) return -1;
	if( uFlags & MMIO_TOUPPER )
	{
		return IRIS_FOURCC(toupper(sz[0]), toupper(sz[1]), toupper(sz[2]), toupper(sz[3]));
	}
	return IRIS_FOURCC(sz[0], sz[1], sz[2], sz[3]);
}

WINMMAPI FOURCC		WINAPI mmioStringToFOURCCW( LPCWSTR sz, UINT uFlags)
{
	if( sz == nullptr ) return -1;
	CHAR sza[4];
	for( int i=0; i < 4; ++i )
	{
		wctomb_s(nullptr, sza+i, 1, sz[i]);
	}
	if( uFlags & MMIO_TOUPPER )
	{
		return IRIS_FOURCC(toupper(sza[0]), toupper(sza[1]), toupper(sza[2]), toupper(sza[3]));
	}
	return IRIS_FOURCC(sza[0], sza[1], sza[2], sza[3]);
}
WINMMAPI LPMMIOPROC WINAPI mmioInstallIOProcA( FOURCC fccIOProc, LPMMIOPROC pIOProc, DWORD dwFlags);
WINMMAPI LPMMIOPROC WINAPI mmioInstallIOProcW( FOURCC fccIOProc, LPMMIOPROC pIOProc, DWORD dwFlags);
WINMMAPI HMMIO		WINAPI mmioOpenA( LPSTR pszFileName,  LPMMIOINFO pmmioinfo,  DWORD fdwOpen)
{
	return 0;
}
WINMMAPI HMMIO		WINAPI mmioOpenW( LPWSTR pszFileName, LPMMIOINFO pmmioinfo,  DWORD fdwOpen)
{
	return 0;
}
WINMMAPI MMRESULT	WINAPI mmioRenameA( LPCSTR pszFileName, LPCSTR pszNewFileName, LPCMMIOINFO pmmioinfo, DWORD fdwRename);
WINMMAPI MMRESULT	WINAPI mmioRenameW( LPCWSTR pszFileName, LPCWSTR pszNewFileName, LPCMMIOINFO pmmioinfo, DWORD fdwRename);

WINMMAPI MMRESULT	WINAPI mmioClose( HMMIO hmmio, UINT fuClose);
WINMMAPI LONG		WINAPI mmioRead( HMMIO hmmio, HPSTR pch, LONG cch);
WINMMAPI LONG		WINAPI mmioWrite( HMMIO hmmio, const char _huge* pch, LONG cch);
WINMMAPI LONG		WINAPI mmioSeek( HMMIO hmmio, LONG lOffset, int iOrigin);
WINMMAPI MMRESULT	WINAPI mmioGetInfo( HMMIO hmmio, LPMMIOINFO pmmioinfo, UINT fuInfo);
WINMMAPI MMRESULT	WINAPI mmioSetInfo( HMMIO hmmio, LPCMMIOINFO pmmioinfo, UINT fuInfo);
WINMMAPI MMRESULT	WINAPI mmioSetBuffer( HMMIO hmmio, LPSTR pchBuffer, LONG cchBuffer, UINT fuBuffer);
WINMMAPI MMRESULT	WINAPI mmioFlush( HMMIO hmmio, UINT fuFlush);
WINMMAPI MMRESULT	WINAPI mmioAdvance( HMMIO hmmio, LPMMIOINFO pmmioinfo, UINT fuAdvance);
WINMMAPI LRESULT	WINAPI mmioSendMessage( HMMIO hmmio, UINT uMsg, LPARAM lParam1, LPARAM lParam2);
WINMMAPI MMRESULT	WINAPI mmioDescend( HMMIO hmmio, LPMMCKINFO pmmcki, const MMCKINFO FAR* pmmckiParent, UINT fuDescend);
WINMMAPI MMRESULT	WINAPI mmioAscend( HMMIO hmmio, LPMMCKINFO pmmcki, UINT fuAscend);
WINMMAPI MMRESULT	WINAPI mmioCreateChunk(HMMIO hmmio, LPMMCKINFO pmmcki, UINT fuCreate);


#endif

