//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WceWrapIO.h
 * @brief		io ֌Wbv֐Q t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WceWrapIO_H_
#define INCG_IRIS_WceWrapIO_H_

//======================================================================
// include
#include "iris_inchead.h"

#if	defined(IRIS_WIN32_WCE)

//======================================================================
// define
#define _IRIS_WCEWRAP_REGISTRY

//======================================================================
// define
#ifdef UNICODE
#  define RegOpenKey		RegOpenKeyW
#  define RegQueryValue		RegQueryValueW
#  define RegSetValue		RegSetValueW
#  define RegEnumKey		RegEnumKeyW
#  define RegSaveKey		RegSaveKeyW
#else
#  define RegOpenKey		RegOpenKeyA
#  define RegQueryValue		RegQueryValueA
#  define RegSetValue		RegSetValueA
#  define RegEnumKey		RegEnumKeyA
#  define RegSaveKey		RegSaveKeyA
#endif

//======================================================================
// function
BOOL	WINAPI	LockFile(HANDLE hFile, DWORD dwFileOffsetLow, DWORD dwFileOffsetHigh, DWORD nNumberOfBytesToLockLow, DWORD nNumberOfBytesToLockHigh);
BOOL	WINAPI	UnlockFile(HANDLE hFile, DWORD dwFileOffsetLow, DWORD dwFileOffsetHigh, DWORD nNumberOfBytesToUnlockLow, DWORD nNumberOfBytesToUnlockHigh);

LSTATUS	APIENTRY	RegOpenKeyA (HKEY hKey, LPCSTR lpSubKey, PHKEY phkResult);
LSTATUS	APIENTRY	RegOpenKeyW (HKEY hKey, LPCWSTR lpSubKey, PHKEY phkResult);

LSTATUS	APIENTRY	RegQueryValueA (HKEY hKey, LPCSTR lpSubKey, LPSTR lpData, PLONG lpcbData);
LSTATUS	APIENTRY	RegQueryValueW (HKEY hKey, LPCWSTR lpSubKey, LPWSTR lpData, PLONG lpcbData);

LSTATUS APIENTRY	RegSetValueA (HKEY hKey, LPCSTR lpSubKey, DWORD dwType, LPCSTR lpData, DWORD cbData);
LSTATUS APIENTRY	RegSetValueW (HKEY hKey, LPCWSTR lpSubKey, DWORD dwType, LPCWSTR lpData, DWORD cbData);

LSTATUS APIENTRY	RegEnumKeyA (HKEY hKey, DWORD dwIndex, LPSTR lpName, DWORD cchName);
LSTATUS APIENTRY	RegEnumKeyW (HKEY hKey, DWORD dwIndex, LPWSTR lpName, DWORD cchName);

LSTATUS APIENTRY	RegSaveKeyA (HKEY hKey, LPCSTR lpFile, CONST LPSECURITY_ATTRIBUTES lpSecurityAttributes);
LSTATUS APIENTRY	RegSaveKeyW (HKEY hKey, LPCWSTR lpFile, CONST LPSECURITY_ATTRIBUTES lpSecurityAttributes);

#endif

#endif
