//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FBXGlobalSettings.cpp
 * @brief		FBX SDK GlobalSettingsNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FBXGlobalSettings_CPP_

//======================================================================
// include
#include "FBXGlobalSettings.h"

#ifdef _IRIS_SUPPORT_FBX
#include "../../gl/GXGL.h"
#include "../../../iris_debug.h"

namespace iris {
namespace gx {
namespace fbx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CFBXGlobalSettings::CFBXGlobalSettings(void)
{
}

#if	FBXSDK_AT_LEAST(FBXSDK_VER_201102)
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	ptr	= O[oZbeBO
*//***********************************************************************/
CFBXGlobalSettings::CFBXGlobalSettings(kfbx_ptr ptr)
: _Mybase(ptr)
{
}
#endif

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	scene	= V[IuWFNg
*//***********************************************************************/
CFBXGlobalSettings::CFBXGlobalSettings(KFbxScene* scene)
: _GlobalSettings(scene == nullptr ? nullptr : &scene->GetGlobalSettings())
#if		FBXSDK_AT_LEAST(FBXSDK_VER_201201)
, IFBXObjectBase<KFbxGlobalCameraSettings>(scene == nullptr ? nullptr : &scene->GlobalCameraSettings())
#elif	FBXSDK_AT_LEAST(FBXSDK_VER_201102)
, IFBXObjectBase<KFbxGlobalCameraSettings>(scene == nullptr ? nullptr : &scene->GetGlobalCameraSettings())
#else
, _GlobalCamera(scene == nullptr ? nullptr : &scene->GetGlobalCameraSettings())
, _GlobalLight(scene == nullptr ? nullptr : &scene->GetGlobalLightSettings())
, _GlobalTime(scene == nullptr ? nullptr : &scene->GetGlobalTimeSettings())
#endif
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	obj	= CFBXGlobalSettings IuWFNg
*//***********************************************************************/
CFBXGlobalSettings::CFBXGlobalSettings(CFBXGlobalSettings& obj)
: _GlobalSettings(obj)
#if	FBXSDK_AT_LEAST(FBXSDK_VER_201102)
, IFBXObjectBase<KFbxGlobalCameraSettings>(obj)
#else
, _GlobalCamera(obj)
, _GlobalLight(obj)
, _GlobalTime(obj)
#endif
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CFBXGlobalSettings::~CFBXGlobalSettings(void)
{
}

/**********************************************************************//**
 *
 * ftHgJ擾
 *
* ----------------------------------------------------------------------
 * @return	ftHgJ
//***********************************************************************/
KString CFBXGlobalSettings::GetDefaultCameraName(void) const
{
	return _GlobalCamera::m_pKfbx->GetDefaultCamera();
}

/**********************************************************************//**
 *
 * ftHgJ擾
 *
* ----------------------------------------------------------------------
 * @return	ftHgJ
//***********************************************************************/
KFbxCamera* CFBXGlobalSettings::GetDefaultCamera(void) const
{
	KString lCurrentCameraName = _GlobalCamera::m_pKfbx->GetDefaultCamera();
#if	FBXSDK_AT_LEAST(FBXSDK_VER_201102)
	KFbxGlobalCameraSettings& lGlobalCameraSettings = *IFBXObjectBase<KFbxGlobalCameraSettings>::m_pKfbx;
#else
	KFbxGlobalCameraSettings& lGlobalCameraSettings = *_GlobalCamera::m_pKfbx;
#endif
	if (lCurrentCameraName.Compare(PRODUCER_PERSPECTIVE) == 0)
	{
		return lGlobalCameraSettings.GetCameraProducerPerspective();
	}
	else if (lCurrentCameraName.Compare(PRODUCER_BOTTOM) == 0)
	{
		return lGlobalCameraSettings.GetCameraProducerBottom();
	}
	else if (lCurrentCameraName.Compare(PRODUCER_TOP) == 0)
	{
		return lGlobalCameraSettings.GetCameraProducerTop();
	}
	else if (lCurrentCameraName.Compare(PRODUCER_FRONT) == 0)
	{
		return lGlobalCameraSettings.GetCameraProducerFront();
	}
	else if (lCurrentCameraName.Compare(PRODUCER_BACK) == 0)
	{
		return lGlobalCameraSettings.GetCameraProducerBack();
	}
	else if (lCurrentCameraName.Compare(PRODUCER_RIGHT) == 0)
	{
		return lGlobalCameraSettings.GetCameraProducerRight();
	}
	else if (lCurrentCameraName.Compare(PRODUCER_LEFT) == 0)
	{
		return lGlobalCameraSettings.GetCameraProducerLeft();
	}
	else if (lCurrentCameraName.Compare(CAMERA_SWITCHER) == 0)
	{
	}
	return nullptr;
}

/**********************************************************************//**
 *
 * Ambient J[̐ݒ
 *
* ----------------------------------------------------------------------
 * @param [in]	Ambient = J[
//***********************************************************************/
void CFBXGlobalSettings::SetAmbientColor(KFbxColor pAmbientColor)
{
	_GlobalLight::m_pKfbx->SetAmbientColor(pAmbientColor);
}

/**********************************************************************//**
 *
 * Ambient J[̎擾
 *
* ----------------------------------------------------------------------
 * @return	Ambient J[
//***********************************************************************/
KFbxColor CFBXGlobalSettings::GetAmbientColor(void) const
{
	return _GlobalLight::m_pKfbx->GetAmbientColor();
}

/**********************************************************************//**
 *
 * ^C}[[hݒ
 *
* ----------------------------------------------------------------------
 * @param [in]	mode	= [h
//***********************************************************************/
void CFBXGlobalSettings::SetTimeMode(KTime::ETimeMode mode)
{
	_GlobalTime::m_pKfbx->SetTimeMode(mode);
}

/**********************************************************************//**
 *
 * ^C}[[h擾
 *
* ----------------------------------------------------------------------
 * @return [h
//***********************************************************************/
KTime::ETimeMode CFBXGlobalSettings::GetTimeMode(void)	const
{
	return _GlobalTime::m_pKfbx->GetTimeMode();
}

/**********************************************************************//**
 *
 * ftHg^CXp̐ݒ
 *
* ----------------------------------------------------------------------
 * @param [in]	pTimeSpan	= ^CXp
//***********************************************************************/
void CFBXGlobalSettings::SetTimelineDefaultTimeSpan(const KTimeSpan& pTimeSpan)
{
#if	FBXSDK_AT_LEAST(FBXSDK_VER_201102)
	_GlobalTime::m_pKfbx->SetTimelineDefaultTimeSpan(pTimeSpan);
#else
	_GlobalTime::m_pKfbx->SetTimelineDefautTimeSpan(pTimeSpan);	// Xy~XH
#endif
}

/**********************************************************************//**
 *
 * ftHg^CXp̎擾
 *
* ----------------------------------------------------------------------
 * @param [out]	pTimeSpan	= o
//***********************************************************************/
void CFBXGlobalSettings::GetTimelineDefaultTimeSpan(KTimeSpan& pTimeSpan) const
{
#if	FBXSDK_AT_LEAST(FBXSDK_VER_201102)
	_GlobalTime::m_pKfbx->GetTimelineDefaultTimeSpan(pTimeSpan);
#else
	_GlobalTime::m_pKfbx->GetTimelineDefautTimeSpan(pTimeSpan);	// Xy~XH
#endif
}

}	// end of namespace fbx
}	// end of namespace gx
}	// end of namespace iris

#endif
