//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FBXPose.cpp
 * @brief		FBX SDK poseNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_FBXPose_CPP_

//======================================================================
// include
#include "FBXPose.h"

#ifdef _IRIS_SUPPORT_FBX
#include "math/FBXMatrix.h"
#include "../../iris_debug.h"

namespace iris {
namespace gx {
namespace fbx
{

//======================================================================
// function
/**********************************************************************//**
 *
 * KFbxPose}gbNX̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	pPose		= |[Y
 * @param [in]	nNodeIndex	= m[h̃CfbNX
 * @return o̓}gbNX
*//***********************************************************************/
KFbxXMatrix GetPoseMatrix(KFbxPose* pPose, int nNodeIndex)
{
	IRIS_ASSERT(pPose != nullptr);
	KFbxXMatrix xmtx;
	const KFbxMatrix& mtx = pPose->GetMatrix(nNodeIndex);
	return *(MatrixToXMatrix(&xmtx, &mtx));
}

}	// end of namespace fbx
}	// end of namespace gx
}	// end of namespace iris

#endif
