//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FBXManager.h
 * @brief		FBX SDK Managert@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FBXManager_H_
#define INCG_IRIS_FBXManager_H_

//======================================================================
// include
#ifdef _IRIS_SUPPORT_FBX
#include "FBXObject.h"
#endif

#ifdef _IRIS_SUPPORT_FBX

//======================================================================
// declare

namespace iris {
namespace gx {
namespace fbx
{

//======================================================================
// class
/**
 * @ingroup	FBX
 * @brief	FBX SDK ManagerNX
*/
class CFBXManager : public IIrisObject
{
protected:
	KFbxSdkManager*	m_pMngr;	//!< FBX SDK Manager

	CFBXObserverSubject		m_Subject;	//!< Ǘ
public:
	// RXgN^
	CFBXManager(void);
	// fXgN^
	~CFBXManager(void);
public:
	// 
	bool	Initialize(void);
	// 
	void	Release(void);

public:
	// IuWFNg̐
	template<class FBXObejct_>
	bool	Create(FBXObejct_* pObj, LPCSTR pName=nullptr)
	{
		if( pObj == nullptr ) return false;
		FBXObejct_::kfbx_ptr ptr = FBXObejct_::kfbx_type::Create(m_pMngr, pName);
		if( ptr == nullptr ) return false;
		pObj->Release();
		pObj->m_pKfbx = ptr;
		m_Subject.AttachObserver(pObj);
		return true;
	}

public:
	// KFbxIOPluginRegistry̎擾
	KFbxIOPluginRegistry*	GetIOPluginRegistry(void)	const;

public:
	// o[W̎擾
	static bool GetFileFormatVersion(int& rMajor, int& rMinor, int& rRevision);
};


}	// end of namespace fbx
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
