//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		main.cpp
 * @brief		C t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_main_CPP_

#include "iris_main.h"
#include "c++0x/cpp0x_regex.hpp"
#include "fnd/container/FndRegexOp.h"
#include "fnd/container/FndStringOp.h"
#include "platform/windows/win/exp/registry/WXVSInstallRegistry.h"
#include "platform/windows/win/base/WXError.h"
#include "platform/windows/win/control/search/WXEnumWindows.h"
#include "platform/windows/win/os/WXProcess.h"
#include "platform/windows/win/control/WXMenu.h"
#include "platform/windows/win/shell/WXSHExecute.h"
#include "iris_iostream.h"
#include "stl/STLtstring.h"
#include "iris_using.h"
#include <tchar.h>

bool AutoUpdateProc(LPTSTR args);

int iris_main(void)
{
	int version = 0;
	bool log = false;
	bool wait = false;
	bool upgrade = false;
	int type = CVSInstallRegistry::VS;
	TCHAR path[MAX_PATH] = TEXT("");
	CVSInstallRegistry vsir;
	stl::tstring args;

	if( ::__argc < 2 ) goto help;

	// R}hC
#pragma region R}hC
	for( int i=1; i < ::__argc; ++i )
	{
		if( ::__targv[i][0] == TEXT('@') )
		{
			if( _tcscmp(::__targv[i]+1, TEXT("version")) == 0 )
			{
				if( ++i < ::__argc )
				{
					LPTSTR e;
					version = _tcstol(::__targv[i], &e, 0);
				}
			}
			else if( _tcscmp(::__targv[i]+1, TEXT("type")) == 0 )
			{
				if( ++i < ::__argc )
				{
					type = 0;
					LPTSTR p = _tcsrchr(::__targv[i], '|');
					while(p != nullptr)
					{
						*p = '\0';
						++p;
						if( _tcscmp(p, TEXT("vs")) == 0 )
						{
							type |= CVSInstallRegistry::VS;
						}
						else if( _tcscmp(p, TEXT("vc")) == 0 )
						{
							type |= CVSInstallRegistry::VC;
						}
						else if( _tcscmp(p, TEXT("vcs")) == 0 )
						{
							type |= CVSInstallRegistry::VCS;
						}
						p = _tcsrchr(::__targv[i], '|');
					}
					if( _tcscmp(::__targv[i], TEXT("vs")) == 0 )
					{
						type |= CVSInstallRegistry::VS;
					}
					else if( _tcscmp(::__targv[i], TEXT("vc")) == 0 )
					{
						type |= CVSInstallRegistry::VC;
					}
					else if( _tcscmp(::__targv[i], TEXT("vcs")) == 0 )
					{
						type |= CVSInstallRegistry::VCS;
					}
				}
			}
			else if( _tcscmp(::__targv[i]+1, TEXT("log")) == 0 )
			{
				log = true;
			}
			else if( _tcscmp(::__targv[i]+1, TEXT("wait")) == 0 )
			{
				wait = true;
			}
			else if( _tcscmp(::__targv[i]+1, TEXT("upgrade")) == 0 )
			{
				upgrade = true;
			}
			else if( _tcscmp(::__targv[i]+1, TEXT("help")) == 0 )
			{
				goto help;
			}
		}
		else
		{
			bool space = _tcschr(::__targv[i], TEXT(' ')) != nullptr;
			if( space )	args += TEXT("\"");
			args += ::__targv[i];
			if( space )	args += TEXT("\"");
			args += TEXT(" ");
		}
	}
#pragma endregion

	DWORD dwIndex = vsir.Find(0, version, type);
	if( dwIndex == (DWORD)-1 )
	{
		TCHAR txtVer[16] = TEXT("");
		TCHAR txtType[128] = TEXT("Studio ");
		if( version )
			wsprintf(txtVer, TEXT("%d"), version);
		if( type != CVSInstallRegistry::NONE )
		{
			wsprintf(txtType, TEXT(""));
			if( type & CVSInstallRegistry::VS )
			{
				_tcscat_s(txtType, TEXT("Studio "));
			}
			if( type & CVSInstallRegistry::VC )
			{
				if( txtType[0] != TEXT('\0') ) _tcscat_s(txtType, IRIS_NumOfElements(txtType), TEXT("| "));
				_tcscat_s(txtType, IRIS_NumOfElements(txtType), TEXT("C++ "));
			}
			if( type & CVSInstallRegistry::VCS )
			{
				if( txtType[0] != TEXT('\0') ) _tcscat_s(txtType, IRIS_NumOfElements(txtType), TEXT("| "));
				_tcscat_s(txtType, IRIS_NumOfElements(txtType), TEXT("C# "));
			}
			if( type & CVSInstallRegistry::VB )
			{
				if( txtType[0] != TEXT('\0') ) _tcscat_s(txtType, IRIS_NumOfElements(txtType), TEXT("| "));
				_tcscat_s(txtType, IRIS_NumOfElements(txtType), TEXT("Basic "));
			}
			if( type & CVSInstallRegistry::VWD )
			{
				if( txtType[0] != TEXT('\0') ) _tcscat_s(txtType, IRIS_NumOfElements(txtType), TEXT("| "));
				_tcscat_s(txtType, IRIS_NumOfElements(txtType), TEXT("Web Develper "));
			}
		}
		std::tcout << TEXT("not found Visual ") << txtType << txtVer << std::endl;
		return 1;
	}

	while(1)
	{
		if( vsir.GetExePath(path, MAX_PATH) )
		{
			_putts(path);
			_putts(args.c_str());

			if( log )
			{
				TCHAR exepath[MAX_PATH];
				args += TEXT("/Log ");
				if( vsir.GetVersion() != 2010 )
				{
					::GetModuleFileName(nullptr, exepath, MAX_PATH);
					args += exepath;
					args += TEXT(".xml");
				}
			}

			if( upgrade )
			{
				args.insert(0, TEXT("\" "));
				args.insert(0, path);
				args.insert(0, TEXT("\""));
				if( AutoUpdateProc((LPTSTR)args.c_str()) ) break;
			}

			if( !wait )
			{
				CSHExecute::Run(nullptr, TEXT("open"), path, args.c_str(), nullptr, SW_SHOW);
			}
			else
			{
				CProcess proc;
				CStartupInfo si;
				si.UseStdHandles();
				args.insert(0, TEXT("\" "));
				args.insert(0, path);
				args.insert(0, TEXT("\""));
	
				proc.Create<TCHAR>(nullptr, (LPTSTR)args.c_str(), nullptr, nullptr, FALSE, NORMAL_PRIORITY_CLASS, nullptr, nullptr, si, nullptr);
				proc.Lock();
				si.Restore();
			}
			return 0;
		}
		dwIndex = vsir.Find(dwIndex, version, type);
		if( dwIndex == (DWORD)-1 ) break;
	}

	return 1;

help:
	_putts( TEXT("rundev option") );
	_putts( TEXT("@version xxxx = visual studio version select.(A.D.)") );
	_putts( TEXT("@type v*      = visual studio type select. (vs|vc|vcs)") );
	_putts( TEXT("@help         = show this") );
	_putts( TEXT("Other arguments are passed to visual studio.") );
	return 0;
}

bool AutoUpdateProc(LPTSTR args)
{
	bool ret = true;
	CProcess proc;
	CStartupInfo si;
	CProcessInfo pi;
	si.UseStdHandles();

	// vZXN
	if( !proc.Create<TCHAR>(nullptr, args, nullptr, nullptr, FALSE, NORMAL_PRIORITY_CLASS, nullptr, nullptr, si, pi) ) return false;

	proc.Wait(1000);

	// NmF
	HWND hDevenv = CEnumWindows::FindEnumWindows( CFindWindow::ProcessIdOp<CFindWindow::AND, CFindWindow::VisibleOp<> >( proc.GetProcessId(), CFindWindow::VisibleOp<>() ));

	int timeout=5;
	while(hDevenv == nullptr)
	{
		hDevenv = CFindWindow::FindWindow(GetDesktopWindow(), nullptr, CFindWindow::ProcessIdOp<>( proc.GetProcessId() ));
		proc.Wait(1000);
		if( --timeout == 0 ) break;
	}

	if( hDevenv == nullptr ) return false;

	// XVbZ[W
	timeout=10;
	while(1)
	{
		{
			HWND hWis = CFindWindow::FindWindow(GetDesktopWindow(), nullptr, CFindWindow::WindowNameOp<CStrstrOp>(CStrstrOp(), TEXT("Visual C++ vWFNg")) );
			if( hWis != nullptr )
			{
				HWND hYes = CFindWindow::FindWindow(hWis, nullptr, CFindWindow::WindowNameOp<CStrstrOp>(CStrstrOp(), TEXT("ׂĂ͂")) );
				if( hYes == nullptr )
				{
					hYes = CFindWindow::FindWindow(hWis, nullptr, CFindWindow::WindowNameOp<CStrstrOp>(CStrstrOp(), TEXT("͂")) );
					if( hYes != nullptr )
					{
						::SendMessage(hYes, BM_CLICK, 0, 0);
					}
				}
				else
				{
					::SendMessage(hYes, BM_CLICK, 0, 0);
					break;
				}
			}
		}
		{
			HWND hWis = CFindWindow::FindWindow(GetDesktopWindow(), nullptr, CFindWindow::WindowNameOp<CStrstrOp>(CStrstrOp(), TEXT("Visual Studio ϊ")) );
			if( hWis != nullptr )
			{
				{
					// ㏑܂H
					HWND hYes = CFindWindow::FindWindow(nullptr, nullptr
						, CFindWindow::WindowNameOp<CStrstrOp, CFindWindow::AND, CFindWindow::ProcessIdOp<> >(CStrstrOp(), TEXT("͂")
						, CFindWindow::ProcessIdOp<>(proc.GetProcessId()) ) );
					if( hYes != nullptr )
					{
						::SendMessage(hYes, BM_CLICK, 0, 0);
					}
				}
				{
					HWND hYes = CFindWindow::FindWindow(hWis, nullptr, CFindWindow::WindowNameOp<CStrstrOp>(CStrstrOp(), TEXT("")) );
					if( hYes == nullptr || !IsWindowEnabled(hYes) )
					{
						hYes = CFindWindow::FindWindow(hWis, nullptr, CFindWindow::WindowNameOp<CStrstrOp>(CStrstrOp(), TEXT("")) );
						if( hYes != nullptr )
						{
							::SendMessage(hYes, BM_CLICK, 0, 0);
						}
					}
					else
					{
						::SendMessage(hYes, BM_CLICK, 0, 0);
						break;
					}
				}
			}
		}
		proc.Wait(1000);
		if( --timeout == 0 ) break;
	}

	proc.Wait(1000);

	while(1)
	{
		hDevenv = CEnumWindows::FindEnumWindows( CFindWindow::ProcessIdOp<CFindWindow::AND, CFindWindow::VisibleOp<> >( proc.GetProcessId(), CFindWindow::VisibleOp<>() ));
		if( ::SendMessage(hDevenv, WM_QUERYENDSESSION, 0, 0) )
		{
			if( ::PostMessage(hDevenv, WM_CLOSE, 0, 0) ) break;

			CLastError es(GetLastError());
			std::_tstring str = es.ToString();
			_putts( str.c_str() );

			HWND hOk = CFindWindow::FindWindow(nullptr, nullptr
				, CFindWindow::WindowNameOp<CStrstrOp, CFindWindow::AND, CFindWindow::ProcessIdOp<> >(CStrstrOp(), TEXT("OK")
				, CFindWindow::ProcessIdOp<>(proc.GetProcessId()) ) );
			if( hOk != nullptr )
			{
				::SendMessage(hOk, BM_CLICK, 0, 0);
			}
		}
	}

	timeout=20;
	TCHAR txtYesNo[32] = TEXT("͂");
	while(1)
	{
		HWND hYes = CFindWindow::FindWindow(nullptr, nullptr
			, CFindWindow::WindowNameOp<CStrstrOp, CFindWindow::AND, CFindWindow::ProcessIdOp<> >(CStrstrOp(), txtYesNo
			, CFindWindow::ProcessIdOp<>(proc.GetProcessId()) ) );
		if( hYes != nullptr )
		{
			::SendMessage(hYes, BM_CLICK, 0, 0);
		}
		HWND hOk = CFindWindow::FindWindow(nullptr, nullptr
			, CFindWindow::WindowNameOp<CStrstrOp, CFindWindow::AND, CFindWindow::ProcessIdOp<> >(CStrstrOp(), TEXT("OK")
			, CFindWindow::ProcessIdOp<>(proc.GetProcessId()) ) );
		if( hOk != nullptr )
		{
			::SendMessage(hOk, BM_CLICK, 0, 0);
		}

		// t@Cۑ_CAOłĂꍇ͕ۑȂ
		HWND hSave = CFindWindow::FindWindow(nullptr, nullptr
			, CFindWindow::WindowNameOp<CStrstrOp, CFindWindow::AND, CFindWindow::ProcessIdOp<> >(CStrstrOp(), TEXT("ۑ")
			, CFindWindow::ProcessIdOp<>(proc.GetProcessId()) ) );
		if( hSave != nullptr )
		{
			_tcscpy_s(txtYesNo, IRIS_NumOfElements(txtYesNo), TEXT(""));
		}

		if( proc.Wait(1000) != WAIT_TIMEOUT ) break;

		if( hYes == nullptr && hOk == nullptr )
		{
			hDevenv = CEnumWindows::FindEnumWindows( CFindWindow::ProcessIdOp<CFindWindow::AND, CFindWindow::VisibleOp<> >( proc.GetProcessId(), CFindWindow::VisibleOp<>() ));
			::PostMessage(hDevenv, WM_CLOSE, 0, 0);

			if( proc.Wait(1000) != WAIT_TIMEOUT ) break;
		}

		if( --timeout == 0 ) 
		{
			ret = false;
			break;
		}
	}

	si.Restore();
	return ret;
}
