//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		XpiSysTime.h
 * @brief		VXeԃt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_XpiSysTime_H_
#define INCG_IRIS_XpiSysTime_H_

//======================================================================
// include
#include "../../fnd/container/FndSingleton.h"
#include "../xpi_config.h"

namespace iris {
namespace xpi
{

//======================================================================
// class
/**
 * @brief	VXe`bNNX
*/
class CSysTick : public IIrisObject
{
public:
	class IImpl : public fnd::CSingleton<IImpl>
	{
	protected:
		IrisBool	m_bInit;
	public:
		IImpl(void) : m_bInit(IRIS_FALSE) {}
	public:
		IrisBool			IsInitialized(void) const { return m_bInit; }
		virtual IrisBool	Initialize(void) = 0;
		virtual	u64			GetTick(void) const = 0;
		virtual u64			GetTickPerSecond(void) const = 0;
		virtual	u64			TicksToNanoSeconds(u64 tick) const	{ return tick * (1000000000 / GetTickPerSecond()); }
		virtual	u64			TicksToMicroSeconds(u64 tick) const	{ return tick * 1000000 / GetTickPerSecond(); }
		virtual	u64			TicksToMilliSeconds(u64 tick) const	{ return tick * 1000 / GetTickPerSecond(); }
		virtual	u64			TicksToSeconds(u64 tick) const		{ return tick / GetTickPerSecond(); }

		virtual u64			NanoSecondsToTicks(u64 sec) const	{ return sec / 1000000000 * GetTickPerSecond(); }
		virtual u64			MicroSecondsToTicks(u64 sec) const	{ return sec / 1000000 * GetTickPerSecond(); }
		virtual u64			MilliSecondsToTicks(u64 sec) const	{ return sec / 1000 * GetTickPerSecond(); }
		virtual u64			SecondsToTicks(u64 sec) const		{ return sec * GetTickPerSecond(); }
	};

public:
	// `bNVXȅ
	//	staticIuWFNg̃RXgN^ŎsĂ邽߁AIɌĂяoKv͂Ȃ
	static	void		Initialize(void);
	// VXeς݂ǂ
	static	IrisBool	IsTickAvailable(void);

	// `bNl̎擾
	static	u64			GetTick(void);
	// `bNl̉16bit擾
	static	u16			GetTickLo(void);
	//! 2̃`bNl̍擾
	STATICINLINE u64	DiffTick(u64 tick1, u64 tick0)		{ return tick1 - tick0; }
	//! 2̃`bNl̍擾
	STATICINLINE s32	DiffTick32(u64 tick1, u64 tick0)	{ return (s32)(tick1 - tick0); }

	// `bNlbɕϊ
	static	u64			TicksToSeconds(u64 tick);
	// `bNl~bɕϊ
	static	u64			TicksToMilliSeconds(u64 tick);
	// `bNl}CNbɕϊ
	static	u64			TicksToMicroSeconds(u64 tick);
	// `bNlimbɕϊ
	static	u64			TicksToNanoSeconds(u64 tick);

	// b`bNlɕϊ
	static	u64			SecondsToTicks(u64 sec);
	// ~b`bNlɕϊ
	static	u64			MilliSecondsToTicks(u64 sec);
	// }CNb`bNlɕϊ
	static	u64			MicroSecondsToTicks(u64 sec);
	// imb`bNlɕϊ
	static	u64			NanoSecondsToTicks(u64 sec);


	STATICINLINE s32	TicksToSeconds32(s32 tick)		{ return (s32)TicksToSeconds((u64)tick); }
	STATICINLINE s32	TicksToMilliSeconds32(s32 tick)	{ return (s32)TicksToMilliSeconds((u64)tick); }
	STATICINLINE s32	TicksToMicroSeconds32(s32 tick)	{ return (s32)TicksToMicroSeconds((u64)tick); }
	STATICINLINE s32	TicksToNanoSeconds32(s32 tick)	{ return (s32)TicksToNanoSeconds((u64)tick); }
	STATICINLINE s32	SecondsToTicks32(s32 sec)		{ return (s32)SecondsToTicks((u64)sec); }
	STATICINLINE s32	MilliSecondsToTicks32(s32 sec)	{ return (s32)MilliSecondsToTicks((u64)sec); }
	STATICINLINE s32	MicroSecondsToTicks32(s32 sec)	{ return (s32)MicroSecondsToTicks((u64)sec); }
	STATICINLINE s32	NanoSecondsToTicks32(s32 sec)	{ return (s32)NanoSecondsToTicks((u64)sec); }
};

}	// end of namespace xpi
}	// end of namespace iris

#endif
