//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		XpiSysTime.cpp
 * @brief		t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_XpiSysTime_CPP_

//======================================================================
// include
#include "XpiSysTime.h"
#if		defined(IRIS_WIN32)
#  include "../../platform/windows/win/os/WXTick.h"
#endif

namespace iris {
namespace xpi
{

//======================================================================
// class
// VXeԏpNX
namespace
{

#if		defined(IRIS_WIN32)

class CWin32SysTickImpl : public CSysTick::IImpl
{
public:
	LARGE_INTEGER	m_Freq;
public:
	// RXgN^
	CWin32SysTickImpl(void) { Initialize(); }
	// 
	virtual IrisBool	Initialize(void)
	{
		m_bInit = IRIS_TRUE;
		return m_bInit;
	}

	virtual	u64			GetTick(void) const
	{
		return wx::CTick::GetTick();
	}
	virtual	u64			GetTickPerSecond(void) const
	{
		return wx::CTick::GetTickPerSecond();
	}
};
static CWin32SysTickImpl	s_win32SysTick;
#endif

}

//======================================================================
// function

/**********************************************************************//**
 *
 * `bNVXȅ
 *
 * @note	staticIuWFNg̃RXgN^ŎsĂ邽߁AIɌĂяoKv͂Ȃ
 *
*//***********************************************************************/
void CSysTick::Initialize(void)
{
	IImpl* pImpl = IImpl::GetInstancePtr();
	if( pImpl != nullptr )
		pImpl->Initialize();
}

/**********************************************************************//**
 *
 * VXeς݂ǂ
 *
 -----------------------------------------------------------------------
 * @return ^Ul
*//***********************************************************************/
IrisBool CSysTick::IsTickAvailable(void)
{
	IImpl* pImpl = IImpl::GetInstancePtr();
	if( pImpl != nullptr )
		return pImpl->IsInitialized();
	return IRIS_FALSE;
}

/**********************************************************************//**
 *
 * `bNl̎擾
 *
 -----------------------------------------------------------------------
 * @return `bNl
*//***********************************************************************/
u64 CSysTick::GetTick(void)
{
	IImpl* pImpl = IImpl::GetInstancePtr();
	if( pImpl != nullptr )
		return pImpl->GetTick();
	return 0;
}

/**********************************************************************//**
 *
 * `bNl̉16bit擾
 *
 -----------------------------------------------------------------------
 * @return `bNl̉16bit
*//***********************************************************************/
u16 CSysTick::GetTickLo(void)
{
	return (u16)(GetTick() & 0xFFFF);
}

/**********************************************************************//**
 *
 * `bNlbɕϊ
 *
 -----------------------------------------------------------------------
 * @param [in]	tick	= `bNl
 * @return b
*//***********************************************************************/
u64 CSysTick::TicksToSeconds(u64 tick)
{
	IImpl* pImpl = IImpl::GetInstancePtr();
	if( pImpl != nullptr )
		return pImpl->TicksToSeconds(tick);
	return tick;
}

/**********************************************************************//**
 *
 * `bNl~bɕϊ
 *
 -----------------------------------------------------------------------
 * @param [in]	tick	= `bNl
 * @return ~b
*//***********************************************************************/
u64 CSysTick::TicksToMilliSeconds(u64 tick)
{
	IImpl* pImpl = IImpl::GetInstancePtr();
	if( pImpl != nullptr )
		return pImpl->TicksToMilliSeconds(tick);
	return tick;
}

/**********************************************************************//**
 *
 * `bNl}CNbɕϊ
 *
 -----------------------------------------------------------------------
 * @param [in]	tick	= `bNl
 * @return }CNb
*//***********************************************************************/
u64 CSysTick::TicksToMicroSeconds(u64 tick)
{
	IImpl* pImpl = IImpl::GetInstancePtr();
	if( pImpl != nullptr )
		return pImpl->TicksToMicroSeconds(tick);
	return tick;
}

/**********************************************************************//**
 *
 * `bNlimbɕϊ
 *
 -----------------------------------------------------------------------
 * @param [in]	tick	= `bNl
 * @return imb
*//***********************************************************************/
u64 CSysTick::TicksToNanoSeconds(u64 tick)
{
	IImpl* pImpl = IImpl::GetInstancePtr();
	if( pImpl != nullptr )
		return pImpl->TicksToNanoSeconds(tick);
	return tick;
}

/**********************************************************************//**
 *
 * b`bNlɕϊ
 *
 -----------------------------------------------------------------------
 * @param [in]	sec	= b
 * @return `bNl
*//***********************************************************************/
u64 CSysTick::SecondsToTicks(u64 sec)
{
	IImpl* pImpl = IImpl::GetInstancePtr();
	if( pImpl != nullptr )
		return pImpl->SecondsToTicks(sec);
	return sec;
}


/**********************************************************************//**
 *
 * ~b`bNlɕϊ
 *
 -----------------------------------------------------------------------
 * @param [in]	sec	= ~b
 * @return `bNl
*//***********************************************************************/
u64 CSysTick::MilliSecondsToTicks(u64 sec)
{
	IImpl* pImpl = IImpl::GetInstancePtr();
	if( pImpl != nullptr )
		return pImpl->MilliSecondsToTicks(sec);
	return sec;
}

/**********************************************************************//**
 *
 * }CNb`bNlɕϊ
 *
 -----------------------------------------------------------------------
 * @param [in]	sec	= }CNb
 * @return `bNl
*//***********************************************************************/
u64 CSysTick::MicroSecondsToTicks(u64 sec)
{
	IImpl* pImpl = IImpl::GetInstancePtr();
	if( pImpl != nullptr )
		return pImpl->MicroSecondsToTicks(sec);
	return sec;
}

/**********************************************************************//**
 *
 * imb`bNlɕϊ
 *
 -----------------------------------------------------------------------
 * @param [in]	sec	= imb
 * @return `bNl
*//***********************************************************************/
u64 CSysTick::NanoSecondsToTicks(u64 sec)
{
	IImpl* pImpl = IImpl::GetInstancePtr();
	if( pImpl != nullptr )
		return pImpl->NanoSecondsToTicks(sec);
	return sec;
}

}	// end of namespace xpi
}	// end of namespace iris
