//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		xf_types.h
 * @brief		iris Œ菬^`wb_
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_xf_types_H_
#define INCG_IRIS_xf_types_H_

//======================================================================
// include
#include "iris_inchead.h"
#include "xf_macro.h"

#if		defined(IRIS_XF_FIXED_FLOAT)		// Œ菬Ή
#if defined(__cplusplus)
#  include "../fnd/format/FndFixedFloat.h"
#endif
typedef ::iris::fnd::CFixedFloat<u16,  3, XF32_SHIFT, 1>				IrisXF16;
typedef	::iris::fnd::CFixedFloat<u16, 19, XF32_SHIFT, 1>				IrisXF32;		// Œ菬̌vZɑΉKv^
typedef IrisXF32			IrisXF32_va;
typedef ::iris::fnd::CFixedFloat<u16, 51, XF32_SHIFT, 1>				IrisXF64;
#undef IRIS_XF_FIXED_FLOAT
#define IRIS_XF_FIXED_FLOAT	1

#else						// else
typedef IrisF32				IrisXF16;
typedef	IrisF32				IrisXF32;		// Œ菬̌vZɑΉKv^
typedef IrisF32_va			IrisXF32_va;	// ϒɓndouble^ɂ̂ɑΉ
typedef IrisF64				IrisXF64;
#define IRIS_XF_FIXED_FLOAT	0

#endif

typedef	volatile IrisXF16		IrisVXF16;
typedef	volatile IrisXF32		IrisVXF32;
typedef	volatile IrisXF64		IrisVXF64;

#if	defined(__cplusplus)
typedef	const IrisXF16&			IrisArgXF16;
typedef	const IrisXF32&			IrisArgXF32;
typedef	const IrisXF64&			IrisArgXF64;

#else
typedef	IrisXF16		IrisArgXF16;
typedef	IrisXF32		IrisArgXF32;
typedef	IrisXF64		IrisArgXF64;

#endif


//! `\(IrisXF32)
typedef struct IrisXFRect
{
	IrisXF32 left, top, right, bottom;
} IrisXFRect;

//! 2DxNg\(IrisXF32)
typedef struct IrisXFVec2
{
	IrisXF32 x, y;
} IrisXFVec2;

//! 3DxNg\(IrisXF32)
typedef struct IrisXFVec3
{
	IrisXF32 x, y, z;
} IrisXFVec3;

//! 4DxNg\(IrisXF32)
typedef struct IrisXFVec4
{
	IrisXF32 x, y, z, w;
} IrisXFVec4;


//! 2x2}gbNX(IrisXF32)
typedef union IrisXFMtx22
{
	struct
	{
		IrisXF32 _00, _01;
		IrisXF32 _10, _11;
	};
	struct
	{
		IrisXFVec2	x, y;
	};
	IrisXFVec2	v[2];
	IrisXF32	a[4];
	IrisXF32	m[2][2];
} IrisXFMtx22;

//! 3x3}gbNX(IrisXF32)
typedef union IrisXFMtx33
{
	struct
	{
		IrisXF32 _00, _01, _02;
		IrisXF32 _10, _11, _12;
		IrisXF32 _20, _21, _22;
	};
	struct
	{
		IrisXFVec3	x, y, z;
	};
	IrisXFVec3	v[3];
	IrisXF32	a[9];
	IrisXF32	m[3][3];
} IrisXFMtx33;

//! 4x3}gbNX(IrisXF32)
typedef union IrisXFMtx43
{
	struct
	{
		IrisXF32 _00, _01, _02;
		IrisXF32 _10, _11, _12;
		IrisXF32 _20, _21, _22;
		IrisXF32 _30, _31, _32;
	};
	struct
	{
		IrisXFVec3	x, y, z, w;
	};
	IrisXFVec3	v[4];
	IrisXF32	a[12];
	IrisXF32	m[4][3];
} IrisXFMtx43;

//! 4x4}gbNX(IrisXF32)
typedef union IrisXFMtx44
{
	struct
	{
		IrisXF32 _00, _01, _02, _03;
		IrisXF32 _10, _11, _12, _13;
		IrisXF32 _20, _21, _22, _23;
		IrisXF32 _30, _31, _32, _33;
	};
	struct
	{
		IrisXFVec4	x, y, z, w;
	};
	IrisXFVec4	v[4];
	IrisXF32	a[16];
	IrisXF32	m[4][4];
} IrisXFMtx44;

//! NH[^jI(IrisXF32)
typedef struct IrisXFQuaternion
{
	IrisXF32 x, y, z, w;
} IrisXFQuaternion;

//! ʌ^(IrisXF32)
typedef struct IrisXFPlane
{
	IrisXF32 a, b, c, d;
} IrisXFPlane;

//----------
// F^

//! xf32RGBAJ[
typedef struct IrisXFColor
{
	IrisXF32 r, g, b, a;
} IrisXFColor;

//! CMYJ[(IrisXF32)
typedef struct IrisXFCMY
{
	IrisXF32 c, m, y;
} IrisXFCMY;

//! CMYKJ[(IrisXF32)
typedef struct IrisXFCMYK
{
	IrisXF32 c, m, y, k;
} IrisXFCMYK;

//! HSVJ[(IrisXF32)
typedef struct IrisXFHSV
{
	IrisXF32 h, s, v;
} IrisXFHSV, IrisXFHSB;


//! f^(IrisXF32)
typedef struct IrisXFComplex
{
	IrisXF32	re;	//!< 
	IrisXF32	im;	//!< 
} IrisXFComplex;


//----------
//! IrisXF32, intp
typedef union IrisXFInt
{
	IrisXF32	fv;
	IrisU32		iv;

#if defined(__cplusplus)
	IrisXFInt(void)	: fv(XF32_ZERO)	{}
	IrisXFInt(IrisXF32 f) : fv(f) {}
	IrisXFInt(IrisU32 i)  : iv((IrisU32)i)	{}
	void operator = (IrisXF32 f)	{ fv = f; }
	void operator = (IrisU32 i)		{ iv = (IrisU32)i; }

	operator IrisXF32		(void)	{ return fv; }
	operator IrisU32		(void)	{ return iv; }
#if !IRIS_XF_FIXED_FLOAT
	operator IrisS32		(void)	{ return (IrisS32)iv; }
#endif

	IrisXFInt(IrisS32 i) : iv((IrisU32)i) {}
	IrisXFInt(IrisS16 i) : iv((IrisU32)i) {}
	IrisXFInt(IrisU16 i) : iv((IrisU32)i) {}
	IrisXFInt(IrisS8  i) : iv((IrisU32)i) {}
	IrisXFInt(IrisU8  i) : iv((IrisU32)i) {}
	IrisXFInt(int	  i) : iv((IrisU32)i) {}
#endif
} IrisXFInt;


#if defined(__cplusplus)
namespace iris
{

typedef IrisXF16		xf16;
typedef	IrisXF32		xf32;		// Œ菬̌vZɑΉKv^
typedef IrisXF64		xf64;
typedef IrisXF32_va		xf32_va;	// ϒɓndouble^ɂ̂ɑΉ

typedef	IrisVXF16		vxf16;
typedef	IrisVXF32		vxf32;
typedef	IrisVXF64		vxf64;

}
#endif

#endif
