//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		xf_macro.h
 * @brief		iris Œ菬}N`wb_
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_xf_macro_H_
#define INCG_IRIS_xf_macro_H_

//======================================================================
// include
#include "../iris_inchead.h"

// XF macros
#if		defined(IRIS_XF_FIXED_FLOAT) && IRIS_XF_FIXED_FLOAT
#define XF32_SHIFT				12

#define XF32_Mul(a, b)			F32_Mul(a, b)			//!< Z
#define XF32_Div(a, b)			F32_Div(a, b)			//!< Z
#define XF32_Sqrt(d_v)			((IrisXF32)F32_Sqrt((float)d_v))	//!< ݏ捪

#define XF_F32_TO_XF32(d_v)		((float)(d_v))			//!< f32  -> IrisXF32LXg
#define XF_XF32_TO_F32(d_v)		((IrisXF32)(d_v))		//!< IrisXF32 ->  f32LXg
#define XF_XF32_TO_S32(d_v)		((IrisS32)(float)(d_v))	//!< IrisXF32 ->  s32LXg
#define XF_XF32_TO_U32(d_v)		((IrisU32)(float)(d_v))	//!< IrisXF32 ->  u32LXg
#define XF_S32_TO_XF32(d_v)		((IrisF32)(float)(d_v))	//!< s32  -> IrisXF32LXg

#define XF32_CONST(d_v)			IrisXF32(d_v)			//!< f32 -> IrisXF32萔
#define XF32_ZERO				IrisXF32::ZERO			//!< (IrisXF32)0
#define XF32_ONE				IrisXF32::ONE			//!< (IrisXF32)1
#define XF32_HALF				IrisXF32::HALF			//!< (IrisXF32)0.5
#define XF32_QUATER				(IrisXF32::HALF >> 1)	//!< (IrisXF32)0.25
#define XF32_2					(IrisXF32::ONE << 1)		//!< (IrisXF32)2
#define XF32_4					(IrisXF32::ONE << 4)		//!< (IrisXF32)4
#define XF32_10					(IrisXF32::ONE * 10)		//!< (IrisXF32)10
#define XF32_60					(IrisXF32::ONE * 60)		//!< (IrisXF32)60
#define XF32_180				(IrisXF32::ONE * 180)		//!< (IrisXF32)180
#define XF32_255				(IrisXF32::ONE * 255)		//!< (IrisXF32)255
#define XF32_360				(IrisXF32::ONE * 360)		//!< (IrisXF32)360

#else
#define XF32_SHIFT				0

#define XF32_Mul(a, b)			F32_Mul(a, b)	//!< Z
#define XF32_Div(a, b)			F32_Div(a, b)	//!< Z
#define XF32_Sqrt(d_v)			F32_Sqrt(d_v)	//!< ݏ捪

#define XF_F32_TO_XF32(d_v)		(d_v)			//!< f32  -> IrisXF32LXg
#define XF_XF32_TO_F32(d_v)		(d_v)			//!< IrisXF32 ->  f32LXg
#define XF_XF32_TO_S32(d_v)		((IrisS32)(d_v))	//!< IrisXF32 ->  s32LXg
#define XF_XF32_TO_U32(d_v)		((IrisU32)(d_v))	//!< IrisXF32 ->  u32LXg
#define XF_S32_TO_XF32(d_v)		((IrisF32)(d_v))	//!< s32  -> IrisXF32LXg

#define XF32_CONST(d_v)			(d_v)			//!< f32 -> IrisXF32萔
#define XF32_ZERO				(0.0f)			//!< (IrisXF32)0
#define XF32_ONE				(1.0f)			//!< (IrisXF32)1
#define XF32_HALF				(0.5f)			//!< (IrisXF32)0.5
#define XF32_QUATER				(0.25f)			//!< (IrisXF32)0.25
#define XF32_2					(2.0f)			//!< (IrisXF32)2
#define XF32_4					(4.0f)			//!< (IrisXF32)4
#define XF32_10					(10.0f)			//!< (IrisXF32)10
#define XF32_60					(60.0f)			//!< (IrisXF32)60
#define XF32_180				(180.0f)		//!< (IrisXF32)180
#define XF32_255				(255.0f)		//!< (IrisXF32)255
#define XF32_360				(360.0f)		//!< (IrisXF32)360

#endif

#endif
