//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		xf_iostream.cpp
 * @brief		iostreamT|[gt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_xf_iostream_CPP_

//======================================================================
// include
#include "xf_iostream.h"
#include <wchar.h>

#ifndef _IRIS_NOT_SUPPORT_IOSTREAM
//======================================================================
// define
// ֐`}N
#define IOSTREAM_FUNC_IMPL_BASE(strm, op, type, impl, text)					\
	std::strm&	operator op (std::strm& ios, const type& val)	{ impl(text) }

#define IOSTREAM_FUNC_IMPL_MBS(strm, op, type, impl)						\
	IOSTREAM_FUNC_IMPL_BASE(strm, op, type, impl, IRIS_TEXTA)

#if	IRIS_WCS
#  define IOSTREAM_FUNC_IMPL_WCS(strm, op, type, impl)						\
	IOSTREAM_FUNC_IMPL_BASE(w##strm, op, type, impl, IRIS_TEXTW)
#else
#  define IOSTREAM_FUNC_IMPL_WCS(strm, op, type, impl)
#endif

#define IOSTREAM_FUNC_IMPL(strm, op, type, impl)							\
	IOSTREAM_FUNC_IMPL_WCS(strm, op, type, impl)							\
	IOSTREAM_FUNC_IMPL_MBS(strm, op, type, impl)

//======================================================================
// function
// IrisXFRect
#define OS_XFRECT_IMPL(_t)							\
	IrisXF32 left	= XF_XF32_TO_F32(val.left);		\
	IrisXF32 top	= XF_XF32_TO_F32(val.top);		\
	IrisXF32 right	= XF_XF32_TO_F32(val.right);	\
	IrisXF32 bottom	= XF_XF32_TO_F32(val.bottom);	\
	return ios << left << _t(", ") << top			\
	<< _t(", ") << right << _t(", ") << bottom;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisXFRect, OS_XFRECT_IMPL)

// vec2
// IrisXFVec2
#define OS_XFVEC2_IMPL(_t)				\
	IrisXF32 x = XF_XF32_TO_F32(val.x);	\
	IrisXF32 y = XF_XF32_TO_F32(val.y);	\
	return ios << x << ", " << y;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisXFVec2, OS_XFVEC2_IMPL)

// vec3
// IrisXFVec3
#define OS_XFVEC3_IMPL(_t)				\
	IrisXF32 x = XF_XF32_TO_F32(val.x);	\
	IrisXF32 y = XF_XF32_TO_F32(val.y);	\
	IrisXF32 z = XF_XF32_TO_F32(val.z);	\
	return ios << x << _t(", ") << y << _t(", ") << z;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisXFVec3, OS_XFVEC3_IMPL)

// vec4
// IrisXFVec4
#define OS_XFVEC4_IMPL(_t)				\
	IrisXF32 x = XF_XF32_TO_F32(val.x);	\
	IrisXF32 y = XF_XF32_TO_F32(val.y);	\
	IrisXF32 z = XF_XF32_TO_F32(val.z);	\
	IrisXF32 w = XF_XF32_TO_F32(val.w);	\
	return ios << x << _t(", ") << y << _t(", ") << z << _t(", ") << w;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisXFVec4, OS_XFVEC4_IMPL)

// IrisXFMtx22
#define OS_XMTX22_IMPL(_t)	return ios << val.x << std::endl << val.y;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisXFMtx22, OS_XMTX22_IMPL)

// IrisXFMtx33
#define OS_XMTX33_IMPL(_t)	return ios << val.x << std::endl << val.y << std::endl << val.z;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisXFMtx33, OS_XMTX33_IMPL)

// IrisXFMtx43
#define OS_XMTX43_IMPL(_t)	return ios << val.x << std::endl << val.y << std::endl << val.z;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisXFMtx43, OS_XMTX43_IMPL)

// IrisXFMtx44
#define OS_XMTX44_IMPL(_t)	return ios << val.x << std::endl << val.y << std::endl << val.z;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisXFMtx44, OS_XMTX44_IMPL)

// IrisXFComplex
#define OS_XFPLANE_IMPL(_t)				\
	IrisXF32 a = XF_XF32_TO_F32(val.a);	\
	IrisXF32 b = XF_XF32_TO_F32(val.b);	\
	IrisXF32 c = XF_XF32_TO_F32(val.c);	\
	IrisXF32 d = XF_XF32_TO_F32(val.d);	\
	return ios << a << _t(", ") << b << _t(", ") << c << _t(", ") << d;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisXFPlane, OS_XFPLANE_IMPL)

// IrisXFColor
#define OS_XFCOLOR_IMPL(_t)						\
	IrisXF32 r = XF_XF32_TO_F32(val.r);			\
	IrisXF32 g = XF_XF32_TO_F32(val.g);			\
	IrisXF32 b = XF_XF32_TO_F32(val.b);			\
	IrisXF32 a = XF_XF32_TO_F32(val.a);			\
	return ios << _t("R:") << r << std::endl	\
	<< _t("G: ") << g << std::endl				\
	<< _t("B: ") << b << std::endl				\
	<< _t("A: ") << a;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisXFColor, OS_XFCOLOR_IMPL)

// IrisXFCMY
#define OS_XFCMY_IMPL(_t)						\
	IrisXF32 c = XF_XF32_TO_F32(val.c);			\
	IrisXF32 m = XF_XF32_TO_F32(val.m);			\
	IrisXF32 y = XF_XF32_TO_F32(val.y);			\
	return ios << _t("C:") << c << std::endl	\
	<< _t("M: ") << m << std::endl				\
	<< _t("Y: ") << y;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisXFCMY, OS_XFCMY_IMPL)

// IrisXFCMY
#define OS_XFCMYK_IMPL(_t)						\
	IrisXF32 c = XF_XF32_TO_F32(val.c);			\
	IrisXF32 m = XF_XF32_TO_F32(val.m);			\
	IrisXF32 y = XF_XF32_TO_F32(val.y);			\
	IrisXF32 k = XF_XF32_TO_F32(val.k);			\
	return ios << _t("C:") << c << std::endl	\
	<< _t("M: ") << m << std::endl				\
	<< _t("Y: ") << y << std::endl				\
	<< _t("K: ") << k;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisXFCMYK, OS_XFCMYK_IMPL)

// IrisXFCMY
#define OS_XFHSV_IMPL(_t)						\
	IrisXF32 h = XF_XF32_TO_F32(val.h);			\
	IrisXF32 s = XF_XF32_TO_F32(val.s);			\
	IrisXF32 v = XF_XF32_TO_F32(val.v);			\
	return ios << _t("H:") << h << std::endl	\
	<< _t("S: ") << s << std::endl				\
	<< _t("V: ") << v;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisXFHSV, OS_XFHSV_IMPL)

// IrisXFComplex
#define OS_XFCOMPLEX_IMPL(_t)				\
	IrisXF32 re = XF_XF32_TO_F32(val.re);	\
	IrisXF32 im = XF_XF32_TO_F32(val.im);	\
	return ios << re << _t("+") << im << _t("i");
IOSTREAM_FUNC_IMPL(ostream, <<, IrisXFComplex, OS_XFCOMPLEX_IMPL)

// IrisXFInt
#define OS_XFINT_IMPL(_t)					\
	IrisXF32 fv = XF_XF32_TO_F32(val.fv);	\
	return ios << fv;
IOSTREAM_FUNC_IMPL(ostream, <<, IrisXFInt, OS_XFINT_IMPL)

#endif	// #ifndef _IRIS_NOT_SUPPORT_IOSTREAM

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

//======================================================================
// include
#include "../unit/UnitCore.h"
#include "../iris_using.h"

//======================================================================
// test
IRIS_UNITTEST(Cxf_iostreamUnitTest, Func)
{
#ifndef _IRIS_NOT_SUPPORT_IOSTREAM
	{
		IrisXFVec3	v3 = {XF32_CONST(20.2f), XF32_CONST(-10.6f), XF32_CONST(0.1f)};
		IrisXFComplex cmpx = {XF32_CONST(10.5f), XF32_CONST(1.0f)};

		std::tcout << v3	<< std::endl;
		std::tcout << cmpx	<< std::endl;
	}
#endif
}

#endif // #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
