﻿//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		NaclVar.h
 * @brief		Var ヘルパー ファイル
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_NaclVar_H_
#define INCG_IRIS_NaclVar_H_

//======================================================================
// include
#include "../nacl_inchead.h"

#if defined(IRIS_NACL)

#include "../../../c++0x/cpp0x_type_traits.hpp"
#include "../../../c++0x/cpp0x_enable_if.hpp"
#include <ppapi/cpp/var.h>
#include <sstream>
#include "../../../iris_debug.h"

namespace iris {
namespace nacl
{

//======================================================================
// class
/**
 * @ingroup	NativeClient
 * @brief	Var ヘルパークラス
*/
class CVarHelper : public pp::Var
{
public:
	template<typename TN>
	static	typename cpp0x::remove_reference<TN>::type	GetValue(const pp::Var& var)
	{
		typedef typename cpp0x::remove_reference<TN>::type rf_type;
		typedef typename cpp0x::remove_cv<rf_type>::type type;
		return getvalue::GetValue<type>(var);
	}

	template<typename TN>
	static	pp::Var	Construct(TN v)
	{
		typedef typename cpp0x::remove_reference<TN>::type rf_type;
		typedef typename cpp0x::remove_cv<rf_type>::type type;
		return construct::impl<TN, type>::Construct(v);
	}


private:
	struct getvalue
	{
		template<typename TN>
		static	TN		GetValue(const pp::Var& var, typename enable_if_t< cpp0x::is_integral<TN> >::type*& = cpp0x::enabler::value )
		{
			if( var.is_number() ) return static_cast<TN>(var.AsInt());
			if( !var.is_string() ) throw "Type mismatch";
			TN tmp=0;
			std::istringstream stream(var.AsString());
			if( stream >> tmp )
			{
				return tmp;
			}
			else
			{
				throw "Can not be converted to ...";
			}
			return tmp;
		}
		template<typename TN>
		static	TN		GetValue(const pp::Var& var, typename enable_if_t< cpp0x::is_floating_point<TN> >::type*& = cpp0x::enabler::value )
		{
			IRIS_VERIFYTHROW( var.is_double() );
			return static_cast<TN>(var.AsDouble());
		}
		template<typename TN>
		static	TN	GetValue(const pp::Var& var, typename enable_if_t< cpp0x::is_same<TN, bool> >::type*& = cpp0x::enabler::value )
		{
			IRIS_VERIFYTHROW( var.is_bool() );
			return var.AsBool();
		}
		template<typename TN>
		static	TN	GetValue(const pp::Var& var, typename enable_if_t< cpp0x::is_same<TN, std::string> >::type*& = cpp0x::enabler::value )
		{
			IRIS_VERIFYTHROW( var.is_string() );
			return var.AsString();
		}
		template<typename TN>
		static	TN	GetValue(const pp::Var& var, typename enable_if_t< cpp0x::is_same<TN, std::vector<std::string> > >::type*& = cpp0x::enabler::value )
		{
			IRIS_VERIFYTHROW( var.is_string() );
			std::string str = var.AsString();
			std::vector<std::string> vec;
			// スペースで分解
			std::stringstream stream(str);
			while( stream >> str )
			{
				vec.push_back(str);
			}
			return vec;

		}
	};

	class construct
	{
		template<typename TN, typename TT>
		struct impl
		{
			template<typename LTN, typename LTT>
			static	pp::Var	Construct_(LTN v,  typename enable_if_t< cpp0x::is_integral<LTT> >::type*& = cpp0x::enabler::value)
			{
				return pp::Var(static_cast<int32_t>(v));
			}
			static	pp::Var	Construct(TN v)
			{
				return Construct_<TN, TT>(v);
			}
		};
		template<typename TN>
		struct impl<TN, pp::Var>
		{
			static	pp::Var	Construct(TN v)
			{
				return pp::Var(v);
			}
		};
		template<typename TN>
		struct impl<TN, int32_t>
		{
			static	pp::Var	Construct(TN v)
			{
				return pp::Var(v);
			}
		};
		template<typename TN>
		struct impl<TN, bool>
		{
			static	pp::Var	Construct(TN v)
			{
				return pp::Var(v);
			}
		};
		template<typename TN>
		struct impl<TN, f32>
		{
			static	pp::Var	Construct(TN v)
			{
				return pp::Var((f64)v);
			}
		};
		template<typename TN>
		struct impl<TN, f64>
		{
			static	pp::Var	Construct(TN v)
			{
				return pp::Var(v);
			}
		};
		template<typename TN>
		struct impl<TN, std::string>
		{
			static	pp::Var	Construct(TN v)
			{
				return pp::Var(v);
			}
		};
		template<typename TN>
		struct impl<TN, LPSTR>
		{
			static	pp::Var	Construct(TN v)
			{
				return pp::Var(v);
			}
		};
		template<typename TN>
		struct impl<TN, LPCSTR>
		{
			static	pp::Var	Construct(TN v)
			{
				return pp::Var(v);
			}
		};
	};

};

}	// end of namespace nacl
}	// end of namespace iris

#endif

#endif
