﻿//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		NaclScriptableObj.h
 * @brief		ScriptableObject ファイル
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_NaclScriptableObj_H_
#define INCG_IRIS_NaclScriptableObj_H_

//======================================================================
// include
#include "../nacl_inchead.h"

#if defined(IRIS_NACL)

#include <ppapi/cpp/instance.h>
#include <ppapi/cpp/dev/scriptable_object_deprecated.h>
#include "NaclMethod.h"
#include <map>
#include <string>

namespace iris {
namespace nacl
{

//======================================================================
// class
/**
 * @ingroup	NativeClient
 * @brief	スクリプトオブジェクトクラス
*/
class CScriptableObj : public pp::deprecated::ScriptableObject, public IIrisObject
{
public:
	typedef std::map<std::string, Method>	_Mymap;
	typedef std::pair<std::string, Method>	_Mypair;

protected:
	_Mymap	m_methods;	//!< メソッド群
public:
	/// コンストラクタ
	CScriptableObj(pp::Instance* instance)	{}
	/// デストラクタ
	virtual	~CScriptableObj(void)	{}

public:
	/// メソッド群の取得
			_Mymap&	GetMethods(void)			{ return m_methods; }
	const	_Mymap&	GetMethods(void)	const	{ return m_methods; }

public:
	/// メソッド追加
	virtual	void	AddMethod(std::string name, Method method)
	{
		_Mymap::iterator it = m_methods.find(name);
		if( it != m_methods.end() )
		{
			it->second = method;	// 上書き
		}
		else
		{
			m_methods.insert(_Mypair(name, method));
		}
	}

public:
	/// 対象メソッドかどうか
	virtual bool HasMethod(const pp::Var& method, pp::Var* exception)
	{
		if(!method.is_string())
		{
			SetExceptionString(exception, "Method name is not a string");
			return false;
		}
		return (m_methods.find(method.AsString()) != m_methods.end());
	}

	/// 対象プロパティかどうか
	virtual bool HasProperty(const pp::Var& property, pp::Var* exception)
	{
		if(!property.is_string())
		{
			SetExceptionString(exception, "Property name is not a string");
			return false;
		}
		return false;
	}

public:

	/// 実行
	virtual pp::Var Call(const pp::Var& method,
		const std::vector<pp::Var>& args,
		pp::Var* exception)
	{
		try
		{
			if( method.is_string() )
			{
				const std::string method_name = method.AsString();
				_Mymap::const_iterator it = m_methods.find(method_name);
				if( it != m_methods.end() )
				{
					return it->second->Invoke(args);
				}
				else
				{
					const char* eNotFound = "metho not found. :";
					SetExceptionString(exception, std::string(eNotFound) + method_name);
				}
			}
		}
		catch( const char* str )
		{
			SetExceptionString(exception, str);
		}
		return pp::Var();
	}

protected:
	/// プロパティの設定
	void SetProperty(const pp::Var& property, const pp::Var& value, pp::Var* exception)
	{
	}

	/// プロパティの取得
	pp::Var GetProperty(const pp::Var& property, pp::Var* exception)
	{
		return pp::Var();
	}

public:
	/// エラー出力設定
	static void	SetExceptionString(pp::Var* exception, const std::string& except_string)
	{
		if( exception != nullptr )
		{
			*exception = except_string;
		}
	}
};

}	// end of namespace nacl
}	// end of namespace iris

#endif

#endif
