﻿//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		NaclDelegator.h
 * @brief		Delegator ファイル
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_NaclDelegator_H_
#define INCG_IRIS_NaclDelegator_H_

//======================================================================
// include
#include "../nacl_inchead.h"

#if defined(IRIS_NACL)

#include "NaclVar.h"
#include "../../../c++0x/cpp0x_type_traits.hpp"
#include <string>
#include "../../../iris_debug.h"

namespace iris {
namespace nacl
{

//======================================================================
// class
/**
 * @ingroup	NativeClient
 * @brief	デリゲートクラス
*/
template<typename Function>
class CDelegator
{
public:
	typedef CDelegator<Function>										_Myt;
	typedef typename ::cpp0x::add_pointer_once_without_scope<Function>::type	_Myfunc;
	typedef typename ::cpp0x::function_traits<Function>					func_traits;
	static const bool isNotReturn = cpp0x::is_same<void, typename func_traits::result_type>::value;

private:
	_Myfunc	m_func;	//!< 関数ポインタ
public:
	// コンストラクタ
	CDelegator(Function func) : m_func(func) {}

public:
	/**
	 * @brief	デリゲート
	*/
	pp::Var	Delegate(const std::vector<pp::Var>& args)
	{
		return Delegate(m_func, args);
	}
	template<class TC>
	pp::Var	Delegate(TC* p, const std::vector<pp::Var>& args)
	{
		return Delegate(p, m_func, args);
	}

public:
	/**
	 * @brief	デリゲート
	*/
	static	pp::Var	Delegate(Function func, const std::vector<pp::Var>& args)
	{
#if 1
		if(args.size() != func_traits::arity) throw "Unexpected number of args";
		return method_impl<isNotReturn, func_traits::arity, void>::Delegate(func, args);
#else
		if(args.size() != func_traits::arity) return "Unexpected number of args";
		try
		{
			return method_impl<isNotReturn, func_traits::arity, void>::Delegate(func, args);
		}
		catch( const char* str )
		{
			return str;
		}
#endif
	}

	/**
	 * @brief	デリゲート
	*/
	template<class TC>
	static	pp::Var	Delegate(TC* p, Function func, const std::vector<pp::Var>& args)
	{
#if 1
		if(args.size() != func_traits::arity) throw "Unexpected number of args";
		return method_impl<isNotReturn, func_traits::arity, void>::Delegate(p, func, args);
#else
		if(args.size() != func_traits::arity) return "Unexpected number of args";
		try
		{
			return method_impl<isNotReturn, func_traits::arity, void>::Delegate(p, func, args);
		}
		catch( const char* str )
		{
			return str;
		}
#endif
	}

protected:
	template<bool isNotReturn, int NARGS, typename DMY>
	struct method_impl {};

	template<typename DMY>
	struct method_impl<true, 0, DMY>
	{
		static pp::Var	Delegate(_Myfunc func, const std::vector<pp::Var>& args)
		{
			func();
			return pp::Var();
		}
		template<class TC>
		static pp::Var	Delegate(TC* p, _Myfunc func, const std::vector<pp::Var>& args)
		{
			(p->*func)();
			return pp::Var();
		}
	};
	template<typename DMY>
	struct method_impl<true, 1, DMY>
	{
		static pp::Var	Delegate(_Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			func(arg1);
			return pp::Var();
		}
		template<class TC>
		static pp::Var	Delegate(TC* p, _Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			(p->*func)(arg1);
			return pp::Var();
		}
	};
	template<typename DMY>
	struct method_impl<true, 2, DMY>
	{
		static pp::Var	Delegate(_Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			func(arg1, arg2);
			return pp::Var();
		}
		template<class TC>
		static pp::Var	Delegate(TC* p, _Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			(p->*func)(arg1, arg2);
			return pp::Var();
		}
	};
	template<typename DMY>
	struct method_impl<true, 3, DMY>
	{
		static pp::Var	Delegate(_Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			typename func_traits::arg3_type arg3 = CVarHelper::GetValue<typename func_traits::arg3_type>(args[2]);
			func(arg1, arg2, arg3);
			return pp::Var();
		}
		template<class TC>
		static pp::Var	Delegate(TC* p, _Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			typename func_traits::arg3_type arg3 = CVarHelper::GetValue<typename func_traits::arg3_type>(args[2]);
			(p->*func)(arg1, arg2, arg3);
			return pp::Var();
		}
	};
	template<typename DMY>
	struct method_impl<true, 4, DMY>
	{
		static pp::Var	Delegate(_Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			typename func_traits::arg3_type arg3 = CVarHelper::GetValue<typename func_traits::arg3_type>(args[2]);
			typename func_traits::arg4_type arg4 = CVarHelper::GetValue<typename func_traits::arg4_type>(args[3]);
			func(arg1, arg2, arg3, arg4);
			return pp::Var();
		}
		template<class TC>
		static pp::Var	Delegate(TC* p, _Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			typename func_traits::arg2_type arg3 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[2]);
			typename func_traits::arg4_type arg4 = CVarHelper::GetValue<typename func_traits::arg4_type>(args[3]);
			(p->*func)(arg1, arg2, arg3, arg4);
			return pp::Var();
		}
	};
	template<typename DMY>
	struct method_impl<true, 5, DMY>
	{
		static pp::Var	Delegate(_Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			typename func_traits::arg3_type arg3 = CVarHelper::GetValue<typename func_traits::arg3_type>(args[2]);
			typename func_traits::arg4_type arg4 = CVarHelper::GetValue<typename func_traits::arg4_type>(args[3]);
			typename func_traits::arg5_type arg5 = CVarHelper::GetValue<typename func_traits::arg5_type>(args[4]);
			func(arg1, arg2, arg3, arg4, arg5);
			return pp::Var();
		}
		template<class TC>
		static pp::Var	Delegate(TC* p, _Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			typename func_traits::arg2_type arg3 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[2]);
			typename func_traits::arg4_type arg4 = CVarHelper::GetValue<typename func_traits::arg4_type>(args[3]);
			typename func_traits::arg5_type arg5 = CVarHelper::GetValue<typename func_traits::arg5_type>(args[4]);
			(p->*func)(arg1, arg2, arg3, arg4, arg5);
			return pp::Var();
		}
	};
	template<typename DMY>
	struct method_impl<true, 6, DMY>
	{
		static pp::Var	Delegate(_Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			typename func_traits::arg3_type arg3 = CVarHelper::GetValue<typename func_traits::arg3_type>(args[2]);
			typename func_traits::arg4_type arg4 = CVarHelper::GetValue<typename func_traits::arg4_type>(args[3]);
			typename func_traits::arg5_type arg5 = CVarHelper::GetValue<typename func_traits::arg5_type>(args[4]);
			typename func_traits::arg6_type arg6 = CVarHelper::GetValue<typename func_traits::arg6_type>(args[5]);
			func(arg1, arg2, arg3, arg4, arg5, arg6);
			return pp::Var();
		}
		template<class TC>
		static pp::Var	Delegate(TC* p, _Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			typename func_traits::arg2_type arg3 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[2]);
			typename func_traits::arg4_type arg4 = CVarHelper::GetValue<typename func_traits::arg4_type>(args[3]);
			typename func_traits::arg5_type arg5 = CVarHelper::GetValue<typename func_traits::arg5_type>(args[4]);
			typename func_traits::arg6_type arg6 = CVarHelper::GetValue<typename func_traits::arg6_type>(args[5]);
			(p->*func)(arg1, arg2, arg3, arg4, arg5, arg6);
			return pp::Var();
		}
	};
	template<typename DMY>
	struct method_impl<true, 7, DMY>
	{
		static pp::Var	Delegate(_Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			typename func_traits::arg3_type arg3 = CVarHelper::GetValue<typename func_traits::arg3_type>(args[2]);
			typename func_traits::arg4_type arg4 = CVarHelper::GetValue<typename func_traits::arg4_type>(args[3]);
			typename func_traits::arg5_type arg5 = CVarHelper::GetValue<typename func_traits::arg5_type>(args[4]);
			typename func_traits::arg6_type arg6 = CVarHelper::GetValue<typename func_traits::arg6_type>(args[5]);
			typename func_traits::arg7_type arg7 = CVarHelper::GetValue<typename func_traits::arg7_type>(args[6]);
			func(arg1, arg2, arg3, arg4, arg5, arg6, arg7);
			return pp::Var();
		}
		template<class TC>
		static pp::Var	Delegate(TC* p, _Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			typename func_traits::arg2_type arg3 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[2]);
			typename func_traits::arg4_type arg4 = CVarHelper::GetValue<typename func_traits::arg4_type>(args[3]);
			typename func_traits::arg5_type arg5 = CVarHelper::GetValue<typename func_traits::arg5_type>(args[4]);
			typename func_traits::arg6_type arg6 = CVarHelper::GetValue<typename func_traits::arg6_type>(args[5]);
			typename func_traits::arg7_type arg7 = CVarHelper::GetValue<typename func_traits::arg7_type>(args[6]);
			(p->*func)(arg1, arg2, arg3, arg4, arg5, arg6, arg7);
			return pp::Var();
		}
	};
	template<typename DMY>
	struct method_impl<true, 8, DMY>
	{
		static pp::Var	Delegate(_Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			typename func_traits::arg3_type arg3 = CVarHelper::GetValue<typename func_traits::arg3_type>(args[2]);
			typename func_traits::arg4_type arg4 = CVarHelper::GetValue<typename func_traits::arg4_type>(args[3]);
			typename func_traits::arg5_type arg5 = CVarHelper::GetValue<typename func_traits::arg5_type>(args[4]);
			typename func_traits::arg6_type arg6 = CVarHelper::GetValue<typename func_traits::arg6_type>(args[5]);
			typename func_traits::arg7_type arg7 = CVarHelper::GetValue<typename func_traits::arg7_type>(args[6]);
			typename func_traits::arg8_type arg8 = CVarHelper::GetValue<typename func_traits::arg8_type>(args[7]);
			func(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
			return pp::Var();
		}
		template<class TC>
		static pp::Var	Delegate(TC* p, _Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			typename func_traits::arg2_type arg3 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[2]);
			typename func_traits::arg4_type arg4 = CVarHelper::GetValue<typename func_traits::arg4_type>(args[3]);
			typename func_traits::arg5_type arg5 = CVarHelper::GetValue<typename func_traits::arg5_type>(args[4]);
			typename func_traits::arg6_type arg6 = CVarHelper::GetValue<typename func_traits::arg6_type>(args[5]);
			typename func_traits::arg7_type arg7 = CVarHelper::GetValue<typename func_traits::arg7_type>(args[6]);
			typename func_traits::arg8_type arg8 = CVarHelper::GetValue<typename func_traits::arg8_type>(args[7]);
			(p->*func)(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
			return pp::Var();
		}
	};
	template<typename DMY>
	struct method_impl<true, 9, DMY>
	{
		static pp::Var	Delegate(_Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			typename func_traits::arg3_type arg3 = CVarHelper::GetValue<typename func_traits::arg3_type>(args[2]);
			typename func_traits::arg4_type arg4 = CVarHelper::GetValue<typename func_traits::arg4_type>(args[3]);
			typename func_traits::arg5_type arg5 = CVarHelper::GetValue<typename func_traits::arg5_type>(args[4]);
			typename func_traits::arg6_type arg6 = CVarHelper::GetValue<typename func_traits::arg6_type>(args[5]);
			typename func_traits::arg7_type arg7 = CVarHelper::GetValue<typename func_traits::arg7_type>(args[6]);
			typename func_traits::arg8_type arg8 = CVarHelper::GetValue<typename func_traits::arg8_type>(args[7]);
			typename func_traits::arg9_type arg9 = CVarHelper::GetValue<typename func_traits::arg9_type>(args[8]);
			func(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
			return pp::Var();
		}
		template<class TC>
		static pp::Var	Delegate(TC* p, _Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			typename func_traits::arg2_type arg3 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[2]);
			typename func_traits::arg4_type arg4 = CVarHelper::GetValue<typename func_traits::arg4_type>(args[3]);
			typename func_traits::arg5_type arg5 = CVarHelper::GetValue<typename func_traits::arg5_type>(args[4]);
			typename func_traits::arg6_type arg6 = CVarHelper::GetValue<typename func_traits::arg6_type>(args[5]);
			typename func_traits::arg7_type arg7 = CVarHelper::GetValue<typename func_traits::arg7_type>(args[6]);
			typename func_traits::arg8_type arg8 = CVarHelper::GetValue<typename func_traits::arg8_type>(args[7]);
			typename func_traits::arg9_type arg9 = CVarHelper::GetValue<typename func_traits::arg9_type>(args[8]);
			(p->*func)(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
			return pp::Var();
		}
	};


	// return 有り
	template<typename DMY>
	struct method_impl<false, 0, DMY>
	{
		static pp::Var	Delegate(_Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::result_type ret = func();
			return CVarHelper::Construct(ret);
		}
		template<class TC>
		static pp::Var	Delegate(TC* p, _Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::result_type ret = (p->*func)();
			return CVarHelper::Construct(ret);
		}
	};
	template<typename DMY>
	struct method_impl<false, 1, DMY>
	{
		static pp::Var	Delegate(_Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::result_type ret = func(arg1);
			return CVarHelper::Construct(ret);
		}
		template<class TC>
		static pp::Var	Delegate(TC* p, _Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::result_type ret = (p->*func)(arg1);
			return CVarHelper::Construct(ret);
		}
	};
	template<typename DMY>
	struct method_impl<false, 2, DMY>
	{
		static pp::Var	Delegate(_Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			typename func_traits::result_type ret = func(arg1, arg2);
			return CVarHelper::Construct(ret);
		}
		template<class TC>
		static pp::Var	Delegate(TC* p, _Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			typename func_traits::result_type ret = (p->*func)(arg1, arg2);
			return CVarHelper::Construct(ret);
		}
	};
	template<typename DMY>
	struct method_impl<false, 3, DMY>
	{
		static pp::Var	Delegate(_Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			typename func_traits::arg3_type arg3 = CVarHelper::GetValue<typename func_traits::arg3_type>(args[2]);
			typename func_traits::result_type ret = func(arg1, arg2, arg3);
			return CVarHelper::Construct(ret);
		}
		template<class TC>
		static pp::Var	Delegate(TC* p, _Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			typename func_traits::arg3_type arg3 = CVarHelper::GetValue<typename func_traits::arg3_type>(args[2]);
			typename func_traits::result_type ret = (p->*func)(arg1, arg2, arg3);
			return CVarHelper::Construct(ret);
		}
	};
	template<typename DMY>
	struct method_impl<false, 4, DMY>
	{
		static pp::Var	Delegate(_Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			typename func_traits::arg3_type arg3 = CVarHelper::GetValue<typename func_traits::arg3_type>(args[2]);
			typename func_traits::arg4_type arg4 = CVarHelper::GetValue<typename func_traits::arg4_type>(args[3]);
			typename func_traits::result_type ret = func(arg1, arg2, arg3, arg4);
			return CVarHelper::Construct(ret);
		}
		template<class TC>
		static pp::Var	Delegate(TC* p, _Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			typename func_traits::arg2_type arg3 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[2]);
			typename func_traits::arg4_type arg4 = CVarHelper::GetValue<typename func_traits::arg4_type>(args[3]);
			typename func_traits::result_type ret = (p->*func)(arg1, arg2, arg3, arg4);
			return CVarHelper::Construct(ret);
		}
	};
	template<typename DMY>
	struct method_impl<false, 5, DMY>
	{
		static pp::Var	Delegate(_Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			typename func_traits::arg3_type arg3 = CVarHelper::GetValue<typename func_traits::arg3_type>(args[2]);
			typename func_traits::arg4_type arg4 = CVarHelper::GetValue<typename func_traits::arg4_type>(args[3]);
			typename func_traits::arg5_type arg5 = CVarHelper::GetValue<typename func_traits::arg5_type>(args[4]);
			typename func_traits::result_type ret = func(arg1, arg2, arg3, arg4, arg5);
			return CVarHelper::Construct(ret);
		}
		template<class TC>
		static pp::Var	Delegate(TC* p, _Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			typename func_traits::arg2_type arg3 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[2]);
			typename func_traits::arg4_type arg4 = CVarHelper::GetValue<typename func_traits::arg4_type>(args[3]);
			typename func_traits::arg5_type arg5 = CVarHelper::GetValue<typename func_traits::arg5_type>(args[4]);
			typename func_traits::result_type ret = (p->*func)(arg1, arg2, arg3, arg4, arg5);
			return CVarHelper::Construct(ret);
		}
	};
	template<typename DMY>
	struct method_impl<false, 6, DMY>
	{
		static pp::Var	Delegate(_Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			typename func_traits::arg3_type arg3 = CVarHelper::GetValue<typename func_traits::arg3_type>(args[2]);
			typename func_traits::arg4_type arg4 = CVarHelper::GetValue<typename func_traits::arg4_type>(args[3]);
			typename func_traits::arg5_type arg5 = CVarHelper::GetValue<typename func_traits::arg5_type>(args[4]);
			typename func_traits::arg6_type arg6 = CVarHelper::GetValue<typename func_traits::arg6_type>(args[5]);
			typename func_traits::result_type ret = func(arg1, arg2, arg3, arg4, arg5, arg6);
			return CVarHelper::Construct(ret);
		}
		template<class TC>
		static pp::Var	Delegate(TC* p, _Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			typename func_traits::arg2_type arg3 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[2]);
			typename func_traits::arg4_type arg4 = CVarHelper::GetValue<typename func_traits::arg4_type>(args[3]);
			typename func_traits::arg5_type arg5 = CVarHelper::GetValue<typename func_traits::arg5_type>(args[4]);
			typename func_traits::arg6_type arg6 = CVarHelper::GetValue<typename func_traits::arg6_type>(args[5]);
			typename func_traits::result_type ret = (p->*func)(arg1, arg2, arg3, arg4, arg5, arg6);
			return CVarHelper::Construct(ret);
		}
	};
	template<typename DMY>
	struct method_impl<false, 7, DMY>
	{
		static pp::Var	Delegate(_Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			typename func_traits::arg3_type arg3 = CVarHelper::GetValue<typename func_traits::arg3_type>(args[2]);
			typename func_traits::arg4_type arg4 = CVarHelper::GetValue<typename func_traits::arg4_type>(args[3]);
			typename func_traits::arg5_type arg5 = CVarHelper::GetValue<typename func_traits::arg5_type>(args[4]);
			typename func_traits::arg6_type arg6 = CVarHelper::GetValue<typename func_traits::arg6_type>(args[5]);
			typename func_traits::arg7_type arg7 = CVarHelper::GetValue<typename func_traits::arg7_type>(args[6]);
			typename func_traits::result_type ret = func(arg1, arg2, arg3, arg4, arg5, arg6, arg7);
			return CVarHelper::Construct(ret);
		}
		template<class TC>
		static pp::Var	Delegate(TC* p, _Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			typename func_traits::arg2_type arg3 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[2]);
			typename func_traits::arg4_type arg4 = CVarHelper::GetValue<typename func_traits::arg4_type>(args[3]);
			typename func_traits::arg5_type arg5 = CVarHelper::GetValue<typename func_traits::arg5_type>(args[4]);
			typename func_traits::arg6_type arg6 = CVarHelper::GetValue<typename func_traits::arg6_type>(args[5]);
			typename func_traits::arg7_type arg7 = CVarHelper::GetValue<typename func_traits::arg7_type>(args[6]);
			typename func_traits::result_type ret = (p->*func)(arg1, arg2, arg3, arg4, arg5, arg6, arg7);
			return CVarHelper::Construct(ret);
		}
	};
	template<typename DMY>
	struct method_impl<false, 8, DMY>
	{
		static pp::Var	Delegate(_Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			typename func_traits::arg3_type arg3 = CVarHelper::GetValue<typename func_traits::arg3_type>(args[2]);
			typename func_traits::arg4_type arg4 = CVarHelper::GetValue<typename func_traits::arg4_type>(args[3]);
			typename func_traits::arg5_type arg5 = CVarHelper::GetValue<typename func_traits::arg5_type>(args[4]);
			typename func_traits::arg6_type arg6 = CVarHelper::GetValue<typename func_traits::arg6_type>(args[5]);
			typename func_traits::arg7_type arg7 = CVarHelper::GetValue<typename func_traits::arg7_type>(args[6]);
			typename func_traits::arg8_type arg8 = CVarHelper::GetValue<typename func_traits::arg8_type>(args[7]);
			typename func_traits::result_type ret = func(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
			return CVarHelper::Construct(ret);
		}
		template<class TC>
		static pp::Var	Delegate(TC* p, _Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			typename func_traits::arg2_type arg3 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[2]);
			typename func_traits::arg4_type arg4 = CVarHelper::GetValue<typename func_traits::arg4_type>(args[3]);
			typename func_traits::arg5_type arg5 = CVarHelper::GetValue<typename func_traits::arg5_type>(args[4]);
			typename func_traits::arg6_type arg6 = CVarHelper::GetValue<typename func_traits::arg6_type>(args[5]);
			typename func_traits::arg7_type arg7 = CVarHelper::GetValue<typename func_traits::arg7_type>(args[6]);
			typename func_traits::arg8_type arg8 = CVarHelper::GetValue<typename func_traits::arg8_type>(args[7]);
			typename func_traits::result_type ret = (p->*func)(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
			return CVarHelper::Construct(ret);
		}
	};
	template<typename DMY>
	struct method_impl<false, 9, DMY>
	{
		static pp::Var	Delegate(_Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			typename func_traits::arg3_type arg3 = CVarHelper::GetValue<typename func_traits::arg3_type>(args[2]);
			typename func_traits::arg4_type arg4 = CVarHelper::GetValue<typename func_traits::arg4_type>(args[3]);
			typename func_traits::arg5_type arg5 = CVarHelper::GetValue<typename func_traits::arg5_type>(args[4]);
			typename func_traits::arg6_type arg6 = CVarHelper::GetValue<typename func_traits::arg6_type>(args[5]);
			typename func_traits::arg7_type arg7 = CVarHelper::GetValue<typename func_traits::arg7_type>(args[6]);
			typename func_traits::arg8_type arg8 = CVarHelper::GetValue<typename func_traits::arg8_type>(args[7]);
			typename func_traits::arg9_type arg9 = CVarHelper::GetValue<typename func_traits::arg9_type>(args[8]);
			typename func_traits::result_type ret = func(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
			return CVarHelper::Construct(ret);
		}
		template<class TC>
		static pp::Var	Delegate(TC* p, _Myfunc func, const std::vector<pp::Var>& args)
		{
			typename func_traits::arg1_type arg1 = CVarHelper::GetValue<typename func_traits::arg1_type>(args[0]);
			typename func_traits::arg2_type arg2 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[1]);
			typename func_traits::arg2_type arg3 = CVarHelper::GetValue<typename func_traits::arg2_type>(args[2]);
			typename func_traits::arg4_type arg4 = CVarHelper::GetValue<typename func_traits::arg4_type>(args[3]);
			typename func_traits::arg5_type arg5 = CVarHelper::GetValue<typename func_traits::arg5_type>(args[4]);
			typename func_traits::arg6_type arg6 = CVarHelper::GetValue<typename func_traits::arg6_type>(args[5]);
			typename func_traits::arg7_type arg7 = CVarHelper::GetValue<typename func_traits::arg7_type>(args[6]);
			typename func_traits::arg8_type arg8 = CVarHelper::GetValue<typename func_traits::arg8_type>(args[7]);
			typename func_traits::arg9_type arg9 = CVarHelper::GetValue<typename func_traits::arg9_type>(args[8]);
			typename func_traits::result_type ret = (p->*func)(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
			return CVarHelper::Construct(ret);
		}
	};
};

}	// end of namespace nacl
}	// end of namespace iris

#endif

#endif
