//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		NaclInputEvent.h
 * @brief		NaclInputEvent t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_NaclInputEvent_H_
#define INCG_IRIS_NaclInputEvent_H_

//======================================================================
// include
#include "../nacl_inchead.h"
#include "../../../iris_object.h"

#if defined(IRIS_NACL)
#include <ppapi/cpp/point.h>
#include <ppapi/cpp/input_event.h>
#include <ppapi/c/ppb_input_event.h>

namespace iris {
namespace nacl
{

//======================================================================
// class
/**
 * @ingroup	NativeClient
 * @brief	̓Cxg NXC^[tFCX
*/
class IInputHandler : public IIrisObject
{
protected:
	virtual bool OnMouseDown	(pp::Point point, const pp::MouseInputEvent& rEvent)	{ return false; }
	virtual bool OnMouseUp		(pp::Point point, const pp::MouseInputEvent& rEvent)	{ return false; }
	virtual bool OnMouseMove	(pp::Point point, const pp::MouseInputEvent& rEvent)	{ return false; }
	virtual bool OnMouseEnter	(pp::Point point, const pp::MouseInputEvent& rEvent)	{ return false; }
	virtual bool OnMouseLeave	(pp::Point point, const pp::MouseInputEvent& rEvent)	{ return false; }
	virtual bool OnContextMenu	(pp::Point point, const pp::MouseInputEvent& rEvent)	{ return false; }

	virtual bool OnWheel		(const pp::WheelInputEvent& rEvent)	{ return false; }

	virtual bool OnRawKeyDown	(const pp::KeyboardInputEvent& rEvent)	{ return false; }
	virtual bool OnKeyDown		(const pp::KeyboardInputEvent& rEvent)	{ return false; }
	virtual bool OnKeyUp		(const pp::KeyboardInputEvent& rEvent)	{ return false; }
	virtual bool OnKeyChar		(const pp::KeyboardInputEvent& rEvent)	{ return false; }

protected:
	virtual bool OnMouseEvent(const pp::MouseInputEvent& rEvent, PP_InputEvent_Type type)
	{
		switch(type)
		{
		case PP_INPUTEVENT_TYPE_MOUSEDOWN:
			return OnMouseDown(rEvent.GetPosition(), rEvent);
		case PP_INPUTEVENT_TYPE_MOUSEUP:
			return OnMouseUp(rEvent.GetPosition(), rEvent);
		case PP_INPUTEVENT_TYPE_MOUSEMOVE:
			return OnMouseMove(rEvent.GetPosition(), rEvent);
		case PP_INPUTEVENT_TYPE_MOUSEENTER:
			return OnMouseEnter(rEvent.GetPosition(), rEvent);
		case PP_INPUTEVENT_TYPE_MOUSELEAVE:
			return OnMouseLeave(rEvent.GetPosition(), rEvent);
		case PP_INPUTEVENT_TYPE_CONTEXTMENU:
			return OnContextMenu(rEvent.GetPosition(), rEvent);
			break;

			// x΍
		case PP_INPUTEVENT_TYPE_WHEEL:
		case PP_INPUTEVENT_TYPE_RAWKEYDOWN:
		case PP_INPUTEVENT_TYPE_KEYDOWN:
		case PP_INPUTEVENT_TYPE_KEYUP:
		case PP_INPUTEVENT_TYPE_CHAR:
		case PP_INPUTEVENT_TYPE_UNDEFINED:
		default:
			break;
		}
		return false;
	}

	virtual bool OnKeyboardEvent(const pp::KeyboardInputEvent& rEvent, PP_InputEvent_Type type)
	{
		switch(type)
		{
		case PP_INPUTEVENT_TYPE_RAWKEYDOWN:
			return OnRawKeyDown(rEvent);
		case PP_INPUTEVENT_TYPE_KEYDOWN:
			return OnKeyDown(rEvent);
		case PP_INPUTEVENT_TYPE_KEYUP:
			return OnKeyUp(rEvent);
		case PP_INPUTEVENT_TYPE_CHAR:
			return OnKeyChar(rEvent);

			// x΍
		case PP_INPUTEVENT_TYPE_MOUSEDOWN:
		case PP_INPUTEVENT_TYPE_MOUSEUP:
		case PP_INPUTEVENT_TYPE_MOUSEMOVE:
		case PP_INPUTEVENT_TYPE_MOUSEENTER:
		case PP_INPUTEVENT_TYPE_MOUSELEAVE:
		case PP_INPUTEVENT_TYPE_CONTEXTMENU:
		case PP_INPUTEVENT_TYPE_WHEEL:
		case PP_INPUTEVENT_TYPE_UNDEFINED:
		default:
			break;
		}
		return false;
	}
public:
	virtual bool HandleInputEvent(const pp::InputEvent& rEvent)
	{
		PP_InputEvent_Type type = rEvent.GetType();
		switch(type)
		{
		case PP_INPUTEVENT_TYPE_MOUSEDOWN:
		case PP_INPUTEVENT_TYPE_MOUSEUP:
		case PP_INPUTEVENT_TYPE_MOUSEMOVE:
		case PP_INPUTEVENT_TYPE_MOUSEENTER:
		case PP_INPUTEVENT_TYPE_MOUSELEAVE:
		case PP_INPUTEVENT_TYPE_CONTEXTMENU:
			{
				pp::MouseInputEvent mouse(rEvent);
				return OnMouseEvent(mouse, type);
			}
			break;

		case PP_INPUTEVENT_TYPE_WHEEL:
			{
				pp::WheelInputEvent wheel(rEvent);
				return OnWheel(wheel);
			}
			break;

		case PP_INPUTEVENT_TYPE_RAWKEYDOWN:
		case PP_INPUTEVENT_TYPE_KEYDOWN:
		case PP_INPUTEVENT_TYPE_KEYUP:
		case PP_INPUTEVENT_TYPE_CHAR:
			{
				pp::KeyboardInputEvent key(rEvent);
				return OnKeyboardEvent(key, type);
			}
			break;

		case PP_INPUTEVENT_TYPE_UNDEFINED:
		default:
			break;
		}
		return false;
	}
};

}	// end of namespace nacl
}	// end of namespace iris

#endif

#endif
