﻿//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		NaclFileRef.h
 * @brief		NaclFileRef ファイル
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_NaclFileRef_H_
#define INCG_IRIS_NaclFileRef_H_

//======================================================================
// include
#include "../nacl_inchead.h"
#include "../../../iris_object.h"

#if defined(IRIS_NACL)

//======================================================================
// include
#include <ppapi/cpp/file_ref.h>
#include <ppapi/cpp/completion_callback.h>

namespace iris {
namespace nacl
{

//======================================================================
// class
/**
 * @ingroup	NativeClient
 * @brief	File Ref クラス
*/
class CFileRef : public IIrisObject
{
protected:
	typedef pp::CompletionCallbackFactory<CFileRef>	Factory;

protected:
	pp::FileRef	m_Ref;
	Factory		m_Factory;

public:
	// コンストラクタ
	CFileRef(void)
		: m_Ref()
		, m_Factory(this)
	{
	}
	CFileRef(const pp::FileSystem& file_sys, const char* path)
		: m_Ref(file_sys, path)
		, m_Factory(this)
	{
	}
	CFileRef(const CFileRef& ref)
		: m_Ref(ref.m_Ref)
		, m_Factory(this)
	{
	}

public:
	CFileRef&	operator = (const CFileRef& rhs)	{ m_Ref = rhs.m_Ref; return *this; }

public:
	/**
	 * @brief	Ref の取得
	*/
			pp::FileRef&	GetFileRef(void)			{ return m_Ref; }
	const	pp::FileRef&	GetFileRef(void)	const	{ return m_Ref; }

	operator const pp::FileRef&	(void)	const	{ return m_Ref; }

public:

	/**
	 * @brief	ディレクトリ作成
	 * @return	結果
	*/
	int32_t	MakeDirectory(void)
	{
		pp::CompletionCallback cc = m_Factory.NewCallback(&CFileRef::OnMakeDirectory);
		return m_Ref.MakeDirectory(cc);
	}

	/**
	 * @brief	削除
	 * @return	結果
	*/
	int32_t	Delete(void)
	{
		pp::CompletionCallback cc = m_Factory.NewCallback(&CFileRef::OnDelete);
		return m_Ref.Delete(cc);
	}

	/**
	 * @brief	
	 * @return	結果
	*/
	int32_t	Touch(PP_Time last_access_time, PP_Time last_modified_time)
	{
		pp::CompletionCallback cc = m_Factory.NewCallback(&CFileRef::OnTouch);
		return m_Ref.Touch(last_access_time, last_modified_time, cc);
	}

	/**
	 * @brief	リネーム
	 * @return	結果
	*/
	int32_t	Rename(const pp::FileRef &new_file_ref)
	{
		pp::CompletionCallback cc = m_Factory.NewCallback(&CFileRef::OnRename);
		return m_Ref.Rename(new_file_ref, cc);
	}

	/**
	 * @brief	閉じる
	*/
	void	Close(void)
	{
		m_Ref = pp::FileRef();
	}


protected:
	/**
	 * @brief	コールバック関数
	 * @param [in]	result	= 結果
	*/
	virtual void	OnMakeDirectory(int32_t result)
	{
		IRIS_UNUSED_VAR(result);
	}

	/**
	 * @brief	コールバック関数
	 * @param [in]	result	= 結果
	*/
	virtual void	OnDelete(int32_t result)
	{
		IRIS_UNUSED_VAR(result);
	}

	/**
	 * @brief	コールバック関数
	 * @param [in]	result	= 結果
	*/
	virtual void	OnTouch(int32_t result)
	{
		IRIS_UNUSED_VAR(result);
	}

	/**
	 * @brief	コールバック関数
	 * @param [in]	result	= 結果
	*/
	virtual void	OnRename(int32_t result)
	{
		IRIS_UNUSED_VAR(result);
	}
};

}	// end of namespace nacl
}	// end of namespace iris

#endif

#endif
