﻿//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		NaclModule.h
 * @brief		Module ファイル
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_NaclModule_H_
#define INCG_IRIS_NaclModule_H_

//======================================================================
// include
#include "NaclEntry.h"
#include "NaclInstance.h"

#if defined(IRIS_NACL)

#include <ppapi/cpp/module.h>

namespace iris {
namespace nacl
{

//======================================================================
// class

/**
 * @ingroup	NativeClient
 * @brief	モジュールクラス
 * @tparam	INSTANCE	= インスタンスクラス
*/
template<class INSTANCE>
class CModule : public pp::Module
{
	typedef CModule<INSTANCE>	_Myt;
	typedef INSTANCE			Instance;
public:
	CModule(void) : pp::Module() {}
	virtual ~CModule(void)	{}

public:
	/// インスタンスの作成
	virtual pp::Instance*	CreateInstance(PP_Instance instance)
	{
		return Instance::CreateInstance(instance);
	}

public:
	/// モジュールの作成
	static pp::Module*	CreateInstance(void)
	{
		return new _Myt();
	}
};


}	// end of namespace nacl
}	// end of namespace iris

#endif

#endif
