﻿//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		NaclInstance.h
 * @brief		Instance ファイル
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_NaclInstance_H_
#define INCG_IRIS_NaclInstance_H_

//======================================================================
// include
#include "../nacl_inchead.h"

#if defined(IRIS_NACL)

#include <ppapi/cpp/instance.h>

#include "../object/NaclScriptableObj.h"
#include "../object/NaclVar.h"
#include "../input/NaclInputEvent.h"

namespace iris {
namespace nacl
{

//======================================================================
// class
/**
 * @ingroup	NativeClient
 * @brief	インスタンスクラス
 * @tparam	CRTP = 実装クラス
*/
template<typename CRTP>
class CInstance : public pp::Instance
{
	typedef CInstance<CRTP>	_Myt;
	typedef CScriptableObj	ScriptableObj;
protected:
	ScriptableObj			m_ScriptObj;
	IInputHandler*			m_pInputHandler;

public:
	/// メソッド追加
	void	AddMethod(std::string name, Method method)
	{
		m_ScriptObj.AddMethod(name, method);
	}

	/// PostMessage
	template<typename TN>
	void	PostMessage(const TN& value)
	{
		pp::Instance::PostMessage(CVarHelper::Construct(value));
	}
	void	PostMessage(const pp::Var& message)
	{
		pp::Instance::PostMessage(message);
	}

public:
	// 入力ハンドラの設定
	void	SetInputHandler(IInputHandler* handle)	{ m_pInputHandler = handle; }

public:
	explicit CInstance(PP_Instance instance)
		: pp::Instance(instance)
		, m_ScriptObj(this)
		, m_pInputHandler(nullptr)
	{}
	virtual ~CInstance(void) {}

protected:
	virtual void HandleMessage(const pp::Var& var_message)
	{
		if( !var_message.is_string() ) return;

		std::string message = var_message.AsString();
		pp::Var exception;
		std::vector<pp::Var> args;
		std::string method;
		{
			int pos = message.find(":");
			if( pos != -1 )
			{
				method = message.substr(0, pos);
				message = message.substr(pos+1);
				pos = message.find(":");
				while( pos != -1 )
				{
					args.push_back(message.substr(0, pos));
					message = message.substr(pos+1);
					pos = message.find(":");
				}
				args.push_back(message);
			}
			else
			{
				method = message;
			}
		}

		if( m_ScriptObj.HasMethod(method, &exception) )
		{
			pp::Var ret = m_ScriptObj.Call(method, args, &exception);
			PostMessage( ret );
		}
	}

protected:
	virtual bool HandleInputEvent(const pp::InputEvent& rEvent)
	{
		if( m_pInputHandler != nullptr ) return m_pInputHandler->HandleInputEvent(rEvent);
		return false;
	}

public:
	static pp::Instance*	CreateInstance(PP_Instance instance)
	{
		return new CRTP(instance);
	}
};

}	// end of namespace nacl
}	// end of namespace iris

#endif

#endif
