//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		UnitMultiUnitTest_WIN32.cpp
 * @brief		Multi Unit Test Windows t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_UnitMultiUnitTest_WIN32_CPP_

//======================================================================
// include
#include "UnitMultiUnitTest_WIN32.h"

#ifdef _IRIS_MULTI_UNITTEST
#if		defined(IRIS_WIN32)
#include "../../iris_iostream.h"
#include "../../iris_main.h"
#include "../../iris_global.h"
#include "../../iris_xchar.hpp"
#include "../gt/gt_inchead.h"
#include <tchar.h>
#include <shlwapi.h>

#ifdef _IRIS_SUPPORT_MULTI_UNITTEST_GUI
typedef iris::unit::CMultiUnitTester_WIN32GUI	CMUT;
#else
typedef iris::unit::CMultiUnitTester_WIN32		CMUT;
#endif
static CMUT s_mut;

namespace iris {
namespace unit
{

//======================================================================
// class
// RXgN^
CMultiUnitTester_WIN32::CMultiUnitTester_WIN32(void)
: m_stdout(nullptr)
, m_stdin(nullptr)
, m_stderr(nullptr)
#ifndef _CONSOLE
, m_hConsole(nullptr)
#endif
{
}

// fXgN^
CMultiUnitTester_WIN32::~CMultiUnitTester_WIN32(void)
{
	Release();
}


// 
bool	CMultiUnitTester_WIN32::Initialize(void)
{
	if( !CMultiUnitTester::Initialize() ) return false;
#ifndef _CONSOLE
	if( AllocConsole() == FALSE)
	{
		fprintf(stderr, "AllocConsole failed.\n");
		return true;
	}
	m_hConsole = GetStdHandle(STD_OUTPUT_HANDLE);
	freopen_s(&m_stdout, "CON", "w", stdout);
	freopen_s(&m_stdin , "CON", "r", stdin);
	freopen_s(&m_stderr, "CON", "w", stderr);
#endif	// #ifndef _CONSOLE

	GetCurrentDirectory(MAX_PATH, m_curr_dir);
	return true;
}

// 
void	CMultiUnitTester_WIN32::Release(void)
{
#ifndef _CONSOLE
	FreeConsole();
	m_hConsole	= nullptr;
	if( m_stdout != nullptr ) fclose(m_stdout);
	if( m_stdin  != nullptr ) fclose(m_stdin);
	if( m_stderr != nullptr ) fclose(m_stderr);
	m_stdout	= nullptr;
	m_stdin		= nullptr;
	m_stderr	= nullptr;
#endif
}

// NeLXg̏o
void	CMultiUnitTester_WIN32::PutsFirstText(void)
{
	CMultiUnitTester::PutsFirstText();
	fprintf(stderr, "If \"cd ***\" is input, It moves to \"***\" folder.\n");
}

// t@C̍œK
void	CMultiUnitTester_WIN32::FileNameOptimize(LPTSTR fname, int length)
{
#ifdef _DEBUG
	for( int i=0, n=length; i < n; ++i ) fname[i] = static_cast<TCHAR>(tolower(static_cast<BYTE>(fname[i])));
#else
	IRIS_UNUSED_VARIABLE(fname);
	IRIS_UNUSED_VARIABLE(length);
#endif
}

bool CMultiUnitTester_WIN32::UpdateCommand(void)
{
	TCHAR name[MAX_PATH] = IRIS_TEXT("none");
	fprintf(stderr, "> %s\n", m_curr_dir);
	std::tcin >> name;
	return CommandProc(name);
}

// R}h
bool	CMultiUnitTester_WIN32::OnCommand(LPTSTR cmd, int size)
{
	if( CMultiUnitTester::OnCommand(cmd, size) ) return true;
	// cd
	if( cmd[0] == IRIS_TEXT('c') && cmd[1] ==  IRIS_TEXT('d') )
	{
		if( std::tcin.peek() == 0x0a )
		{
			GetCurrentDirectory(MAX_PATH, m_curr_dir);
			std::tcout << m_curr_dir << std::endl;
		}
		else
		{
			std::tcin >> cmd;
			if( SetCurrentDirectory(cmd) )
			{
				GetCurrentDirectory(MAX_PATH, m_curr_dir);
			}
			else
			{
				fprintf(stdout, "fBNg̈ړɎs܂\n");
			}
		}
		return true;
	}
	// Ȃɂsꍇ́AtrueԂ
	return false;
}

// user interface
#ifdef _IRIS_SUPPORT_MULTI_UNITTEST_GUI
#include <commctrl.h>
#include <windowsx.h>
#include <commdlg.h>

// define
#define IDC_MUTUI_COMBO			1001
#define IDC_MUTUI_BUTTON_DO		1002
#define IDC_MUTUI_BUTTON_INPUT	1003
#define IDC_MUTUI_BUTTON_ENTER	1004
#define IDC_MUTUI_BUTTON_DIR	1005
#define IDC_MUTUI_BUTTON_DIROP	1006
#define IDC_MUTUI_BUTTON_BREAK	1007
#define IDC_MUTUI_BUTTON_FILE	1008
#define IDC_MUTUI_CKBTN_STDOUT	1009
#define IDC_MUTUI_EDIT1			1010
#define IDC_MUTUI_EDIT2			1011

#define CONSOLE_Y_OFFSET		90

// function
static LRESULT CALLBACK MUTUI_WindowProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

// variable
HWND	s_hConsoleWnd = nullptr;		//!< R\[EBhEnh
bool	s_bExec = false;

// class
// RXgN^
CMultiUnitTester_WIN32GUI::CMultiUnitTester_WIN32GUI(void)
: m_hWnd(nullptr)
, m_Atom(0)
, m_hThread(nullptr)
{
}

// fXgN^
CMultiUnitTester_WIN32GUI::~CMultiUnitTester_WIN32GUI(void)
{
	Release();
}

// 
bool	CMultiUnitTester_WIN32GUI::Initialize(void)
{
	if( !CMultiUnitTester_WIN32::Initialize() ) return false;
	RECT rc, wrc;

	// R\[EBhE̎擾
	{
		int cnt = 20;
		TCHAR csl_title_bef[1024];
		TCHAR csl_title[64];
		wsprintf(csl_title, IRIS_TEXT("%d/%d"), GetTickCount(), GetCurrentProcessId());
		GetConsoleTitle(csl_title_bef, 1024);
		SetConsoleTitle(csl_title);
		while(cnt--)
		{
			Sleep(40);
			s_hConsoleWnd = FindWindow(nullptr, csl_title);
			if( s_hConsoleWnd != nullptr ) break;
		}
		if( s_hConsoleWnd == nullptr ) return false;
		SetConsoleTitle(csl_title_bef);
	}
	GetWindowRect(s_hConsoleWnd, &wrc);

	HINSTANCE hInstance = GetModuleHandle(nullptr);
	WNDCLASSEX wcex = {0};// WNDCLASSEX\
	wcex.cbSize			= sizeof( wcex );					// WNDCLASSEX\̂̃TCY
	wcex.style			= CS_HREDRAW | CS_VREDRAW;			// EBhENX̃X^C
	wcex.lpfnWndProc	= MUTUI_WindowProc;					// EBhEvV[W
	wcex.cbClsExtra		= 0;								// gp̃p[^
	wcex.cbWndExtra		= 0;								// gp̃p[^
	wcex.hInstance		= hInstance;						// CX^Xnh
	wcex.hIcon			= nullptr;							// ACR̃nh
	wcex.hCursor		= LoadCursor(nullptr, IDC_ARROW);	// J[\̃nh
	wcex.hbrBackground	= (HBRUSH)(COLOR_BTNFACE+1);		// wiF̃nh
	wcex.lpszMenuName	= nullptr;							// NX̃j[̖O
	wcex.lpszClassName	= IRIS_TEXT("multi unit test ui");	// EBhENX̖O
	wcex.hIconSm		= nullptr;							// X[ACR̃nh
	m_Atom = ::RegisterClassEx( &wcex );
	if( m_Atom == 0 ) return false;

	AdjustWindowRect(&wrc, WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN, FALSE);
	m_hWnd = CreateWindow(wcex.lpszClassName, IRIS_TEXT("Multi UnitTest"), WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN
		, CW_USEDEFAULT, 0, wrc.right-wrc.left, wrc.bottom-wrc.top + CONSOLE_Y_OFFSET, nullptr, nullptr, hInstance, nullptr);
	if( m_hWnd == nullptr ) return false;
	SetWindowLongPtr(m_hWnd, GWL_USERDATA, (LONG_PTR)this);
	GetClientRect(m_hWnd, &rc);

	// combo
	HGDIOBJ hFont = GetStockObject(DEFAULT_GUI_FONT);
	HWND hCombo = CreateWindowEx(WS_EX_CLIENTEDGE, WC_COMBOBOX, nullptr, WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_TABSTOP | WS_GROUP | CBS_SORT | CBS_DROPDOWNLIST | CBS_AUTOHSCROLL
		, 0, 5, rc.right-65, 200, m_hWnd, (HMENU)IDC_MUTUI_COMBO, hInstance, nullptr);
	SendMessage(hCombo, WM_SETFONT, (WPARAM)hFont, 0);
	for( UTMap::iterator _it=s_UTMap.begin(), _end=s_UTMap.end(); _it != _end; ++_it )
	{
		ComboBox_AddString(hCombo, _it->first.c_str());
	}
	ComboBox_AddString(hCombo, IRIS_TEXT("main"));
#ifdef _IRIS_SUPPORT_GOOGLETEST
	ComboBox_AddString(hCombo, IRIS_TEXT("googletest"));
#endif

	// button
	HWND hButton1 = CreateWindowEx(WS_EX_CLIENTEDGE, WC_BUTTON, IRIS_TEXT("DO"), WS_CHILD | WS_VISIBLE | WS_TABSTOP | WS_GROUP
		, rc.right-105, 5, 60, 22, m_hWnd, (HMENU)IDC_MUTUI_BUTTON_DO, hInstance, nullptr);
	// edit
	HWND hEdit1 = CreateWindowEx(WS_EX_CLIENTEDGE, WC_EDIT, nullptr, WS_CHILD | WS_VISIBLE | WS_TABSTOP | WS_GROUP
		, rc.left, 35, rc.right-125, 22, m_hWnd, (HMENU)IDC_MUTUI_EDIT1, hInstance, nullptr);
	HWND hEdit2 = CreateWindowEx(WS_EX_CLIENTEDGE, WC_EDIT, nullptr, WS_CHILD | WS_VISIBLE | WS_TABSTOP | WS_GROUP
		, rc.left+130, 60, rc.right-rc.left-130-125, 22, m_hWnd, (HMENU)IDC_MUTUI_EDIT2, hInstance, nullptr);
	// button
	HWND hButton2 = CreateWindowEx(WS_EX_CLIENTEDGE, WC_BUTTON, IRIS_TEXT("..."), WS_CHILD | WS_VISIBLE | WS_TABSTOP | WS_GROUP
		, rc.right-125, 35, 20, 22, m_hWnd, (HMENU)IDC_MUTUI_BUTTON_DIR, hInstance, nullptr);
	HWND hButton3 = CreateWindowEx(WS_EX_CLIENTEDGE, WC_BUTTON, IRIS_TEXT("input"), WS_CHILD | WS_VISIBLE | WS_TABSTOP | WS_GROUP
		, rc.right-125, 35, 60, 22, m_hWnd, (HMENU)IDC_MUTUI_BUTTON_INPUT, hInstance, nullptr);
	HWND hButton4 = CreateWindowEx(WS_EX_CLIENTEDGE, WC_BUTTON, IRIS_TEXT("Enter"), WS_CHILD | WS_VISIBLE | WS_TABSTOP | WS_GROUP
		, rc.right-40, 5, 40, 52, m_hWnd, (HMENU)IDC_MUTUI_BUTTON_ENTER, hInstance, nullptr);
	HWND hButton5 = CreateWindowEx(WS_EX_CLIENTEDGE, WC_BUTTON, IRIS_TEXT("stop"), WS_CHILD | WS_VISIBLE | WS_TABSTOP | WS_GROUP
		, rc.right-40, 60, 40, 22, m_hWnd, (HMENU)IDC_MUTUI_BUTTON_BREAK, hInstance, nullptr);
	HWND hButton6 = CreateWindowEx(WS_EX_CLIENTEDGE, WC_BUTTON, IRIS_TEXT(">>"), WS_CHILD | WS_VISIBLE | WS_TABSTOP | WS_GROUP
		, rc.right-125, 60, 20, 22, m_hWnd, (HMENU)IDC_MUTUI_BUTTON_DIROP, hInstance, nullptr);
	HWND hCkBtn = CreateWindowEx(WS_EX_WINDOWEDGE, WC_BUTTON, IRIS_TEXT("stdout(CONSOLE)"), WS_CHILD | WS_VISIBLE | WS_TABSTOP | WS_GROUP | BS_CHECKBOX
		, rc.left, 60, 120, 22, m_hWnd, (HMENU)IDC_MUTUI_CKBTN_STDOUT, hInstance, nullptr);
	SendMessage(hButton1, WM_SETFONT, (WPARAM)hFont, 1);
	SendMessage(hButton2, WM_SETFONT, (WPARAM)hFont, 1);
	SendMessage(hButton3, WM_SETFONT, (WPARAM)hFont, 1);
	SendMessage(hButton4, WM_SETFONT, (WPARAM)hFont, 1);
	SendMessage(hButton5, WM_SETFONT, (WPARAM)hFont, 1);
	SendMessage(hButton6, WM_SETFONT, (WPARAM)hFont, 1);
	SendMessage(hEdit1	, WM_SETFONT, (WPARAM)hFont, 1);
	SendMessage(hEdit2	, WM_SETFONT, (WPARAM)hFont, 1);
	SendMessage(hCkBtn	, WM_SETFONT, (WPARAM)hFont, 1);
	EnableWindow(hEdit2, FALSE);
	Button_SetCheck(hCkBtn, BST_CHECKED);

	// console
	{
		SetParent(s_hConsoleWnd, m_hWnd);
		//LONG style, exstyle;
		//style = GetWindowLong(s_hConsoleWnd, GWL_STYLE);
		//SetWindowLong(s_hConsoleWnd, GWL_STYLE, style & ~(WS_CAPTION | WS_SYSMENU | WS_THICKFRAME | WS_GROUP | WS_TABSTOP | WS_CLIPSIBLINGS));
		//exstyle = GetWindowLong(s_hConsoleWnd, GWL_EXSTYLE);
		//SetWindowLong(s_hConsoleWnd, GWL_EXSTYLE, exstyle & ~WS_EX_APPWINDOW);
		//GetWindowRect(s_hConsoleWnd, &wrc);
		MoveWindow(s_hConsoleWnd, 0, CONSOLE_Y_OFFSET, wrc.right-wrc.left, wrc.bottom-wrc.top, TRUE);
	}

	SetFocus(hCombo);
	DragAcceptFiles(m_hWnd, TRUE);
	ShowWindow(m_hWnd, SW_SHOW);
	return true;
}

// 
void	CMultiUnitTester_WIN32GUI::Release(void)
{
	CMultiUnitTester_WIN32::Release();
	if( m_hWnd != nullptr )
	{
		DestroyWindow(m_hWnd);
		m_hWnd = nullptr;
	}
	if( m_Atom != INVALID_ATOM )
	{
		if( UnregisterClass(MAKEINTATOM(m_Atom), GetModuleHandle(nullptr)) )
		{
			m_Atom = INVALID_ATOM;
		}
		else
		{
			if( UnregisterClass(IRIS_TEXT("multi unit test ui"), GetModuleHandle(nullptr)) )
				m_Atom = INVALID_ATOM;
		}
	}
	if( m_hThread != nullptr )
	{
		DWORD dwExitCode = 0;
		::GetExitCodeThread(m_hThread, &dwExitCode);
		if( CUnitTestBase::GetCurrent() != nullptr )
			CUnitTestBase::GetCurrent()->Abort();
		::TerminateThread(m_hThread, dwExitCode);
		::WaitForSingleObject(m_hThread, INFINITE);
		CloseHandle( m_hThread );
		m_hThread = nullptr;
		m_dwThreadId = 0;
	}
}

// s
void	CMultiUnitTester_WIN32GUI::Run(void)
{
	// C[v
	MSG msg;
	ZeroMemory(&msg, sizeof(msg));
	while(msg.message != WM_QUIT)
	{
		while( !PeekMessage(&msg, nullptr, 0U, 0U, PM_NOREMOVE) )
		{
			if( s_bExec )
			{
				if( m_hThread == nullptr )
				{
					m_hThread = ::CreateThread( nullptr, 0, Entry, this, 0, &m_dwThreadId );
				}
				s_bExec = false;
			}
		}
		if(GetMessage(&msg, nullptr, 0, 0))
		{
			if( !IsDialogMessage(m_hWnd, &msg) )
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}
	}
}

// s
void	CMultiUnitTester_WIN32GUI::RunAll(void)
{
	if( m_hThread == nullptr )
	{
		m_hThread = ::CreateThread( nullptr, 0, EntryAll, this, 0, &m_dwThreadId );
	}

	// C[v
	MSG msg;
	ZeroMemory(&msg, sizeof(msg));
	while(msg.message != WM_QUIT)
	{
		while( !PeekMessage(&msg, nullptr, 0U, 0U, PM_NOREMOVE) )
		{
			if( s_bExec )
			{
				if( m_hThread == nullptr )
				{
					m_hThread = ::CreateThread( nullptr, 0, Entry, this, 0, &m_dwThreadId );
				}
				s_bExec = false;
			}
		}
		if(GetMessage(&msg, nullptr, 0, 0))
		{
			if( !IsDialogMessage(m_hWnd, &msg) )
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}
	}
}

// s
void	CMultiUnitTester_WIN32GUI::BaseRunAll(void)
{
	CMultiUnitTester_WIN32::RunAll();
}

// ~
void	CMultiUnitTester_WIN32GUI::Stop(void)
{
	if( m_hThread != nullptr )
	{
		DWORD dwExitCode = 0;
		::GetExitCodeThread(m_hThread, &dwExitCode);
		::TerminateThread(m_hThread, dwExitCode);
		CUnitTestBase::GetCurrent()->Abort();
		::WaitForSingleObject(m_hThread, INFINITE);
		::CloseHandle(m_hThread);
		m_hThread = nullptr;
		m_dwThreadId = 0;
		fprintf(stderr, "stop unit test.\n");
		EnableWindow(GetDlgItem(m_hWnd, IDC_MUTUI_BUTTON_DO), TRUE);
	}
}

DWORD WINAPI CMultiUnitTester_WIN32GUI::Entry(void *arg)
{
	CMultiUnitTester_WIN32GUI* pInstance = static_cast<CMultiUnitTester_WIN32GUI*>(arg);
	EnableWindow(GetDlgItem(pInstance->m_hWnd, IDC_MUTUI_BUTTON_DO), FALSE);
	FlushConsoleInputBuffer( GetStdHandle(STD_INPUT_HANDLE) );

	TCHAR text[MAX_PATH];
	GetWindowText(GetDlgItem(pInstance->m_hWnd, IDC_MUTUI_COMBO), text, MAX_PATH);
	UTMap::iterator it = s_UTMap.find(text);
	if( it != s_UTMap.end() )
	{
		// s
		_ftprintf(stderr, IRIS_TEXT("execute unit test. <%s>.\n"), it->first.c_str() );
		std::cin.clear();
		it->second->Exec();
		_ftprintf(stderr, IRIS_TEXT("done unit test. <%s>.\n"), it->first.c_str() );
	}
	else
	{
		if( xcscmp(text, IRIS_TEXT("main")) == 0 )
		{
			iris_main();
		}
#ifdef _IRIS_SUPPORT_GOOGLETEST
		if( xcscmp(text, IRIS_TEXT("googletest")) == 0 )
		{
			int argc = ::irisGetArgc();
			LPTSTR* argv = ::irisGetArgv();

			GT_INIT(&argc, argv);
			RUN_ALL_TESTS();
		}
#endif
	}
	pInstance->m_hThread = nullptr;
	pInstance->m_dwThreadId = 0;
	EnableWindow(GetDlgItem(pInstance->m_hWnd, IDC_MUTUI_BUTTON_DO), TRUE);
	return 0;
}

DWORD WINAPI CMultiUnitTester_WIN32GUI::EntryAll(void *arg)
{
	CMultiUnitTester_WIN32GUI* pInstance = static_cast<CMultiUnitTester_WIN32GUI*>(arg);
	EnableWindow(GetDlgItem(pInstance->m_hWnd, IDC_MUTUI_BUTTON_DO), FALSE);
	FlushConsoleInputBuffer( GetStdHandle(STD_INPUT_HANDLE) );

	pInstance->BaseRunAll();

	pInstance->m_hThread = nullptr;
	pInstance->m_dwThreadId = 0;
	EnableWindow(GetDlgItem(pInstance->m_hWnd, IDC_MUTUI_BUTTON_DO), TRUE);
	return 0;
}

static LRESULT CALLBACK MUTUI_WindowProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch( uMsg )
	{
	case WM_COMMAND:
		{
			DWORD cmd = LOWORD(wParam);
			switch(cmd)
			{
			case IDC_MUTUI_BUTTON_DO:
				s_bExec = true;
				SetForegroundWindow(s_hConsoleWnd);
				break;
			case IDC_MUTUI_BUTTON_INPUT:
				{
					int len = GetWindowTextLength(GetDlgItem(hWnd, IDC_MUTUI_EDIT1));
					if( len > 0 )
					{
						++len;
						DWORD written;
						LPTSTR str = new TCHAR [len];
						GetWindowText(GetDlgItem(hWnd, IDC_MUTUI_EDIT1), str, len);
						for( int i=0; i < len; ++i )
						{
							INPUT_RECORD buf;
							ZeroMemory(&buf, sizeof(buf));
#ifdef UNICODE
							CHAR mb;
							int conv;
							wctomb_s(&conv, &mb, 1, str[i]);
#else
							CHAR mb = str[i];
#endif
							buf.EventType = KEY_EVENT;
							buf.Event.KeyEvent.bKeyDown = TRUE;
							//CHAR upper = static_cast<CHAR>(toupper(mb));
							//buf.Event.KeyEvent.wVirtualKeyCode = upper;
							buf.Event.KeyEvent.uChar.AsciiChar = mb;
							WriteConsoleInputA(GetStdHandle(STD_INPUT_HANDLE), &buf, 1, &written);
							buf.Event.KeyEvent.bKeyDown = FALSE;
							WriteConsoleInputA(GetStdHandle(STD_INPUT_HANDLE), &buf, 1, &written);
						}
						delete [] str;
					}
				}
				break;
			case IDC_MUTUI_BUTTON_ENTER:
				{
					DWORD written;
					INPUT_RECORD buf;
					buf.EventType = KEY_EVENT;
					buf.Event.KeyEvent.bKeyDown = TRUE;
					buf.Event.KeyEvent.wRepeatCount = 1;
					buf.Event.KeyEvent.dwControlKeyState = 0x00;
					buf.Event.KeyEvent.wVirtualKeyCode = VK_RETURN;
					buf.Event.KeyEvent.wVirtualScanCode = 0;
					buf.Event.KeyEvent.uChar.AsciiChar = VK_RETURN;
					WriteConsoleInputA(GetStdHandle(STD_INPUT_HANDLE), &buf, 1, &written);
					buf.Event.KeyEvent.bKeyDown = FALSE;
					WriteConsoleInputA(GetStdHandle(STD_INPUT_HANDLE), &buf, 1, &written);
				}
				break;
			case IDC_MUTUI_BUTTON_DIR:
				{
					static TCHAR s_path[MAX_PATH];
					OPENFILENAME ofn;
					ZeroMemory(&ofn, sizeof(OPENFILENAME));
					ofn.lStructSize= sizeof(OPENFILENAME);
					ofn.hwndOwner	= hWnd;
					ofn.lpstrFilter	= IRIS_TEXT("*.*\0*.*\0");
					ofn.lpstrFile	= s_path;
					ofn.nMaxFile	= MAX_PATH;
					ofn.Flags		= OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_NOCHANGEDIR;
					ofn.lpstrTitle	= IRIS_TEXT("t@CIĂ");
					if(GetOpenFileName(&ofn))
					{
						//PathQuoteSpaces(s_path);
						SetWindowText(GetDlgItem(hWnd, IDC_MUTUI_EDIT1), s_path);
					}
				}
				break;
			case IDC_MUTUI_BUTTON_DIROP:
				{
					TCHAR path[MAX_PATH];
					GetWindowText(GetDlgItem(hWnd, IDC_MUTUI_EDIT2), path, MAX_PATH);
					LPTSTR p = _tcsrchr(path, IRIS_TEXT('\\'));
					if( p != nullptr ) *p = IRIS_TEXT('\0');
					ShellExecute(hWnd, IRIS_TEXT("open"), IRIS_TEXT("explorer")
						, path, IRIS_TEXT(""), SW_SHOW);
				}
				break;
			case IDC_MUTUI_BUTTON_BREAK:
				{
					CMultiUnitTester_WIN32GUI* mut = reinterpret_cast<CMultiUnitTester_WIN32GUI*>(GetWindowLongPtr(hWnd, GWL_USERDATA));
					if( mut != nullptr )
					{
						mut->Stop();
					}
				}
				break;
			case IDC_MUTUI_CKBTN_STDOUT:
				{
					CMultiUnitTester_WIN32GUI* mut = reinterpret_cast<CMultiUnitTester_WIN32GUI*>(GetWindowLongPtr(hWnd, GWL_USERDATA));
					if( mut == nullptr ) break;
					if( Button_GetCheck(GetDlgItem(hWnd, IDC_MUTUI_CKBTN_STDOUT)) != BST_CHECKED )
					{
						freopen_s(&mut->m_stdout, "CON", "w", stdout);
						Button_SetCheck(GetDlgItem(hWnd, IDC_MUTUI_CKBTN_STDOUT), BST_CHECKED);
					}
					else
					{
						static CHAR s_path[MAX_PATH];
						OPENFILENAMEA ofn;
						ZeroMemory(&ofn, sizeof(OPENFILENAME));
						ofn.lStructSize= sizeof(OPENFILENAME);
						ofn.hwndOwner	= hWnd;
						ofn.lpstrFilter	= "*.txt\0*.txt\0*.*\0*.*\0";
						ofn.lpstrFile	= s_path;
						ofn.nMaxFile	= MAX_PATH;
						ofn.Flags		= OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_NOCHANGEDIR;
						ofn.lpstrTitle	= "t@CIĂ";
						if(GetOpenFileNameA(&ofn))
						{
							freopen_s(&mut->m_stdout, s_path, "w", stdout);
							Button_SetCheck(GetDlgItem(hWnd, IDC_MUTUI_CKBTN_STDOUT), BST_UNCHECKED);
							SetWindowTextA(GetDlgItem(hWnd, IDC_MUTUI_EDIT2), s_path);
						}
					}
				}
				break;
			}
		}
		break;
	case WM_DROPFILES:
		{
			HDROP hDrop = reinterpret_cast<HDROP>(wParam);
			TCHAR szFileName[MAX_PATH];
			DragQueryFile(hDrop, 0, szFileName, MAX_PATH);
			SetWindowText(GetDlgItem(hWnd, IDC_MUTUI_EDIT1), szFileName);
			DragFinish(hDrop);
		}
		break;
	case WM_SIZE:
		{
			//int w = LOWORD(lParam);
			//int h = HIWORD(lParam);
			switch(wParam)
			{
			case SIZE_MINIMIZED:
				break;
			default:
				{
					RECT rc;
					GetClientRect(hWnd, &rc);
					MoveWindow(GetDlgItem(hWnd, IDC_MUTUI_COMBO)		, rc.left, 5, rc.right-105, 200, TRUE);
					MoveWindow(GetDlgItem(hWnd, IDC_MUTUI_BUTTON_DO)	, rc.right-100,  5, 60, 22, TRUE);
					MoveWindow(GetDlgItem(hWnd, IDC_MUTUI_BUTTON_ENTER)	, rc.right-40 ,  5, 40, 52, TRUE);
					MoveWindow(GetDlgItem(hWnd, IDC_MUTUI_BUTTON_INPUT)	, rc.right-100, 35, 60, 22, TRUE);
					MoveWindow(GetDlgItem(hWnd, IDC_MUTUI_BUTTON_DIR)	, rc.right-125, 35, 20, 22, TRUE);
					MoveWindow(GetDlgItem(hWnd, IDC_MUTUI_BUTTON_DIROP)	, rc.right-125, 60, 20, 22, TRUE);
					MoveWindow(GetDlgItem(hWnd, IDC_MUTUI_BUTTON_BREAK)	, rc.right-40 , 60, 40, 22, TRUE);
					MoveWindow(GetDlgItem(hWnd, IDC_MUTUI_CKBTN_STDOUT)	, rc.left, 60 , 130, 22, TRUE);
					MoveWindow(GetDlgItem(hWnd, IDC_MUTUI_EDIT1)		, rc.left, 35 , rc.right-125, 22, TRUE);
					MoveWindow(GetDlgItem(hWnd, IDC_MUTUI_EDIT2)		, rc.left+130 , 60, rc.right-rc.left-130-125, 22, TRUE);

					MoveWindow(s_hConsoleWnd, 0, CONSOLE_Y_OFFSET, rc.right, rc.bottom-CONSOLE_Y_OFFSET, TRUE);
				}
				break;
			}
		}
		break;
	case WM_GETMINMAXINFO:
		{
			LPMINMAXINFO lpmm = reinterpret_cast<LPMINMAXINFO>(lParam);
			SendMessage(s_hConsoleWnd, WM_GETMINMAXINFO, wParam, lParam);
			RECT rc = {0, 0, lpmm->ptMaxTrackSize.x, 100};
			AdjustWindowRect(&rc, WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN, FALSE);
			lpmm->ptMaxTrackSize.x = rc.right-rc.left;
			lpmm->ptMinTrackSize.x += 40;
		}
		break;
	case WM_DESTROY:
		PostQuitMessage(0);
		return 0;
	}
	return DefWindowProc(hWnd, uMsg, wParam, lParam);
}

#endif

}	// end of namespace unit
}	// end of namespace iris

#endif

#endif
