//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		UnitFuctory.h
 * @brief		UnitTest Fuctory NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_UnitFuctory_H_
#define INCG_IRIS_UnitFuctory_H_

//======================================================================
// include
#include "UnitClass.h"

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST) )

namespace iris {
namespace unit
{

//======================================================================
// class
/**
 * eXgNXRN^
*/
class IUnitTestFuctory : public IIrisObject
{
public:
	IUnitTestFuctory*	m_next;
	TCHAR				m_name[256];
public:
	// RXgN^
	IUnitTestFuctory(LPCTSTR pName, LPCTSTR pSubName);

public:
	// NXo^AhX̎擾
	static IUnitTestFuctory**	GetRegister(void);
	// eXg̎s
	virtual	void	Exec(void) = 0;

public:
	static void Run(LPCTSTR pName);
	static void Run(LPCTSTR pName, LPCTSTR pSubName);
};

template<class _TC>
class CUnitTestFuctory : public IUnitTestFuctory
{
public:
	// RXgN^
	CUnitTestFuctory(LPCTSTR pName, LPCTSTR pSubName)
		: IUnitTestFuctory(pName, pSubName)
		{}

public:
	// eXg̎s
	virtual	void	Exec(void)
	{
		_TC* p = new _TC;
		p->SetParam(m_name);
		p->Exec();
		delete p;
	}
};


}	// end of namespace unit
}	// end of namespace iris

#endif

#endif
