//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		UnitFuctory.cpp
 * @brief		UnitTest Fuctory NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_UnitFuctory_CPP_

//======================================================================
// include
#include "UnitFuctory.h"
#include "../iris_xchar.hpp"

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST) )

namespace iris {
namespace unit
{

//======================================================================
// IUnitTestFuctory
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	pName		= eXg
 * @param [in]	pSubName	= TueXg
*//***********************************************************************/
IUnitTestFuctory::IUnitTestFuctory(LPCTSTR pName, LPCTSTR pSubName)
{
	if( pName == nullptr ) return;
	LPCTSTR p = xcsrchr(pName, IRIS_TEXT(FILESPEC_DIRECTORY_DELIMITER));
	if( p == nullptr ) p = pName;
	else ++p;
	LPCTSTR name = p;
	LPCTSTR subname = pSubName;
	xcscpy_s(m_name, elementof(m_name), name);
	xcscat_s(m_name, elementof(m_name), IRIS_TEXT("::"));
	xcscat_s(m_name, elementof(m_name), subname);
	IUnitTestFuctory** pRegister = GetRegister();
	m_next = *pRegister;
	*pRegister = this;
}

IUnitTestFuctory** IUnitTestFuctory::GetRegister(void)
{
	static IUnitTestFuctory* pResister = nullptr;
	return &pResister;
}

/**********************************************************************//**
 *
 * Ow肵ċN
 *
 ----------------------------------------------------------------------
 * @param [in]	pName		= eXg
 * @param [in]	pSubName	= TueXg
*//***********************************************************************/
void IUnitTestFuctory::Run(LPCTSTR pName, LPCTSTR pSubName)
{
	TCHAR name[256];
	xcscpy_s(name, sizeof(name), pName);
	xcscat_s(name, sizeof(name), IRIS_TEXT("::"));
	xcscat_s(name, sizeof(name), pSubName);
	Run(name);
}
void IUnitTestFuctory::Run(LPCTSTR pName)
{
	IUnitTestFuctory* pUt = *GetRegister();
	while( pUt != nullptr )
	{
		if( xcsstr( pUt->m_name, pName ) == pUt->m_name )
		{
			pUt->Exec();
		}
	}
}


}	// end of namespace unit
}	// end of namespace iris


#endif
