//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_types_cast.hpp
 * @brief		^LXg̃wp[ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_types_cast_HPP_
#define INCG_IRIS_iris_types_cast_HPP_

//======================================================================
// include
#include "iris_types_alias.h"

#if defined(__cplusplus)

namespace iris
{

//======================================================================
// class
namespace detail
{

template<typename D, typename B>
class bitdirect_cast_impl
{
	template<typename TD, typename TB>
	struct cast_impl
	{
		static inline TD cast(TB v)	{ return static_cast<TD>(v); }
	};
	template<typename TD>
	struct cast_impl<TD, char>
	{
		static inline TD cast(char v)	{ return static_cast<TD>(static_cast<unsigned char>(v)); }
	};
	template<typename T>
	struct cast_impl<T, T>
	{
		static inline T cast(T v)	{ return v; }
	};
public:
	static inline D	cast(B v)
	{
#if 0
		return cast_impl<D, B>::cast(v);
#else
		union value_impl
		{
			D d;
			B b;
		};
		value_impl x;
		x.d = 0;
		x.b = v;
		return x.d;
#endif
	}
};

}

/**
 * @brief	rbgێăLXg
*/
template<typename T, typename F>
STATICINLINE T	bitdirect_cast(F v)	{ return detail::bitdirect_cast_impl<T, F>::cast(v); }


}	// end of namespace

#endif

#endif
