//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iris_types_alias.h
 * @brief		iris_types_alias t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_iris_types_alias_H_
#define INCG_IRIS_iris_types_alias_H_

//======================================================================
// include
#include "../iris_types.h"
#include "../iris_compiler.h"
#include "../c++0x/cpp0x_nullptr.h"	// nullptr

#if defined(__cplusplus)

//======================================================================
// declare
struct IrisU24;
struct IrisS24;

namespace iris
{

//======================================================================
// typedef
typedef IrisC8			c8;
typedef IrisS8			s8;
typedef IrisU8			u8;

typedef IrisS16			s16;
typedef IrisU16			u16;

typedef IrisU24			u24;
typedef IrisS24			s24;

typedef IrisS32			s32;
typedef IrisU32			u32;

typedef IrisS64			s64;
typedef IrisU64			u64;

typedef IrisF32			f32;
typedef IrisF64			f64;
typedef IrisF32_va		f32_va;

typedef IrisU4CC		u4cc;		// FOURCC

// volatile
typedef IrisVC8			vc8;
typedef IrisVS8			vs8;
typedef IrisVU8			vu8;

typedef IrisVS16		vs16;
typedef IrisVU16		vu16;

typedef IrisVS32		vs32;
typedef IrisVU32		vu32;

typedef IrisVS64		vs64;
typedef IrisVU64		vu64;

typedef IrisVF32		vf32;
typedef IrisVF64		vf64;

typedef IrisVU4CC		vu4cc;

typedef	IrisS32W64		s32w64;
typedef	IrisU32W64		u32w64;

typedef	IrisVS32W64		vs32w64;
typedef	IrisVU32W64		vu32w64;

template<int BIT>
class int_least_type
{
	template<int B, typename DMY>
	struct least_type_impl
	{
		typedef typename least_type_impl<B-1, DMY>::Int Int;
		typedef typename least_type_impl<B-1, DMY>::UInt UInt;
	};
	template<typename DMY>
	struct least_type_impl<0, DMY>
	{
		typedef s8 Int;
		typedef u8 UInt;
	};

	template<typename DMY>
	struct least_type_impl<9, DMY>
	{
		typedef s16 Int;
		typedef u16 UInt;
	};

	template<typename DMY>
	struct least_type_impl<17, DMY>
	{
		typedef s32 Int;
		typedef u32 UInt;
	};

	template<typename DMY>
	struct least_type_impl<33, DMY>
	{
		typedef s64 Int;
		typedef u64 UInt;
	};

public:
	typedef typename least_type_impl<BIT, void>::Int Int;
	typedef typename least_type_impl<BIT, void>::UInt UInt;
};

}	// end of namespace iris

#endif

#endif
