//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		SqDelegator.h
 * @brief		Squirrel ֐o^NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_SqDelegator_H_
#define INCG_IRIS_SqDelegator_H_

//======================================================================
// include
#include "../SqStack.h"
#include "../SqVM.h"
#include "../../../iris_object.h"
#include "../../../c++0x/cpp0x_type_traits.hpp"
#include "../../../c++0x/cpp0x_enable_if.hpp"

#ifdef _IRIS_SUPPORT_SQUIRREL

namespace iris {
namespace sq
{

//======================================================================
// class
/**
 * @ingroup	squirrel
 * @brief	squirrel ֐R[NX
*/
class CSqDelegator : public IIrisObject
{
public:
	/**
	 * @brief	쐬
	*/
	template<typename F>
	static bool		CreateGlobalFunction(CSquirrelVM* sq, LPCSQSTR lpName, F func)
	{
		CSqScope scope(sq);
		sq->PushRootTable();
		sq->PushString(lpName, -1);
		F* up = static_cast<F*>(sq->NewUserPointer(sizeof(func)));
		*up = func;
		sq->NewClosure(CDelegator<F>::Entry, 1);
#ifdef _DEBUG
		if( SQ_FAILED(sq->SetNativeClosureName(-1, lpName)) ) return false;
#endif
		if( SQ_FAILED(sq->CreateSlot(-3)) ) return false;
		sq->Pop(1);
		return true;
	}
	static bool		CreateGlobalFunction(CSquirrelVM* sq, LPCSQSTR lpName, SQFUNCTION func)
	{
		CSqScope scope(sq->GetVM());
		sq->PushRootTable();
		sq->PushString(lpName, -1);
		sq->NewClosure(func);
#ifdef _DEBUG
		if( SQ_FAILED(sq->SetNativeClosureName(-1, lpName)) ) return false;
#endif
		if( SQ_FAILED(sq->CreateSlot(-3)) ) return false;
		sq->Pop(1);
		return true;
	}

public:
	template<typename Function>
	class CDelegator : public IIrisObject
	{
		typedef Function	_Myfunc;
		typedef cpp0x::function_traits<Function>	func_traits;
		static const bool isNotReturn = typename cpp0x::is_same<void, typename func_traits::result_type>::value;
	public:
		/**
		 * @brief	֐Ăяo
		*/
		static	SQInteger	Entry(HSQUIRRELVM vm)
		{
			CSqStack sq = CSqStack(vm);
			const SQInteger n = sq.GetParamCount();
			_Myfunc* func = static_cast<_Myfunc*>(sq.GetUserData(n));
			if( func == nullptr ) return SQ_ERROR;
			return impl<isNotReturn>::Delegate<func_traits::arity>(&sq, *func, 2);
		}

	protected:
		template<bool isNotReturn>
		struct impl
		{
			template<int NARGS>
			static SQInteger	Delegate(CSqStack* sq, _Myfunc func, SQInteger index)
			{
				func();
				return 0;
			}

			template<>
			static SQInteger	Delegate<1>(CSqStack* sq, _Myfunc func, SQInteger index)
			{
				func_traits::arg1_type arg1 = sq->GetValue<func_traits::arg1_type>(index++);
				func(arg1);
				return 0;
			}
			template<>
			static SQInteger	Delegate<2>(CSqStack* sq, _Myfunc func, SQInteger index)
			{
				func_traits::arg1_type arg1 = sq->GetValue<func_traits::arg1_type>(index++);
				func_traits::arg2_type arg2 = sq->GetValue<func_traits::arg2_type>(index++);
				func(arg1, arg2);
				return 0;
			}
			template<>
			static SQInteger	Delegate<3>(CSqStack* sq, _Myfunc func, SQInteger index)
			{
				func_traits::arg1_type arg1 = sq->GetValue<func_traits::arg1_type>(index++);
				func_traits::arg2_type arg2 = sq->GetValue<func_traits::arg2_type>(index++);
				func_traits::arg3_type arg3 = sq->GetValue<func_traits::arg3_type>(index++);
				func(arg1, arg2, arg3);
				return 0;
			}
			template<>
			static SQInteger	Delegate<4>(CSqStack* sq, _Myfunc func, SQInteger index)
			{
				func_traits::arg1_type arg1 = sq->GetValue<func_traits::arg1_type>(index++);
				func_traits::arg2_type arg2 = sq->GetValue<func_traits::arg2_type>(index++);
				func_traits::arg3_type arg3 = sq->GetValue<func_traits::arg3_type>(index++);
				func_traits::arg4_type arg4 = sq->GetValue<func_traits::arg4_type>(index++);
				func(arg1, arg2, arg3, arg4);
				return 0;
			}
			template<>
			static SQInteger	Delegate<5>(CSqStack* sq, _Myfunc func, SQInteger index)
			{
				func_traits::arg1_type arg1 = sq->GetValue<func_traits::arg1_type>(index++);
				func_traits::arg2_type arg2 = sq->GetValue<func_traits::arg2_type>(index++);
				func_traits::arg3_type arg3 = sq->GetValue<func_traits::arg3_type>(index++);
				func_traits::arg4_type arg4 = sq->GetValue<func_traits::arg4_type>(index++);
				func_traits::arg5_type arg5 = sq->GetValue<func_traits::arg5_type>(index++);
				func(arg1, arg2, arg3, arg4, arg5);
				return 0;
			}
			template<>
			static SQInteger	Delegate<6>(CSqStack* sq, _Myfunc func, SQInteger index)
			{
				func_traits::arg1_type arg1 = sq->GetValue<func_traits::arg1_type>(index++);
				func_traits::arg2_type arg2 = sq->GetValue<func_traits::arg2_type>(index++);
				func_traits::arg3_type arg3 = sq->GetValue<func_traits::arg3_type>(index++);
				func_traits::arg4_type arg4 = sq->GetValue<func_traits::arg4_type>(index++);
				func_traits::arg5_type arg5 = sq->GetValue<func_traits::arg5_type>(index++);
				func_traits::arg6_type arg6 = sq->GetValue<func_traits::arg6_type>(index++);
				func(arg1, arg2, arg3, arg4, arg5, arg6);
				return 0;
			}
			template<>
			static SQInteger	Delegate<7>(CSqStack* sq, _Myfunc func, SQInteger index)
			{
				func_traits::arg1_type arg1 = sq->GetValue<func_traits::arg1_type>(index++);
				func_traits::arg2_type arg2 = sq->GetValue<func_traits::arg2_type>(index++);
				func_traits::arg3_type arg3 = sq->GetValue<func_traits::arg3_type>(index++);
				func_traits::arg4_type arg4 = sq->GetValue<func_traits::arg4_type>(index++);
				func_traits::arg5_type arg5 = sq->GetValue<func_traits::arg5_type>(index++);
				func_traits::arg6_type arg6 = sq->GetValue<func_traits::arg6_type>(index++);
				func_traits::arg7_type arg7 = sq->GetValue<func_traits::arg7_type>(index++);
				func(arg1, arg2, arg3, arg4, arg5, arg6, arg7);
				return 0;
			}
			template<>
			static SQInteger	Delegate<8>(CSqStack* sq, _Myfunc func, SQInteger index)
			{
				func_traits::arg1_type arg1 = sq->GetValue<func_traits::arg1_type>(index++);
				func_traits::arg2_type arg2 = sq->GetValue<func_traits::arg2_type>(index++);
				func_traits::arg3_type arg3 = sq->GetValue<func_traits::arg3_type>(index++);
				func_traits::arg4_type arg4 = sq->GetValue<func_traits::arg4_type>(index++);
				func_traits::arg5_type arg5 = sq->GetValue<func_traits::arg5_type>(index++);
				func_traits::arg6_type arg6 = sq->GetValue<func_traits::arg6_type>(index++);
				func_traits::arg7_type arg7 = sq->GetValue<func_traits::arg7_type>(index++);
				func_traits::arg8_type arg8 = sq->GetValue<func_traits::arg8_type>(index++);
				func(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
				return 0;
			}
			template<>
			static SQInteger	Delegate<9>(CSqStack* sq, _Myfunc func, SQInteger index)
			{
				func_traits::arg1_type arg1 = sq->GetValue<func_traits::arg1_type>(index++);
				func_traits::arg2_type arg2 = sq->GetValue<func_traits::arg2_type>(index++);
				func_traits::arg3_type arg3 = sq->GetValue<func_traits::arg3_type>(index++);
				func_traits::arg4_type arg4 = sq->GetValue<func_traits::arg4_type>(index++);
				func_traits::arg5_type arg5 = sq->GetValue<func_traits::arg5_type>(index++);
				func_traits::arg6_type arg6 = sq->GetValue<func_traits::arg6_type>(index++);
				func_traits::arg7_type arg7 = sq->GetValue<func_traits::arg7_type>(index++);
				func_traits::arg8_type arg8 = sq->GetValue<func_traits::arg8_type>(index++);
				func_traits::arg9_type arg9 = sq->GetValue<func_traits::arg9_type>(index++);
				func(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
				return 0;
			}
			template<>
			static SQInteger	Delegate<10>(CSqStack* sq, _Myfunc func, SQInteger index)
			{
				func_traits::arg1_type  arg1 = sq->GetValue<func_traits::arg1_type>(index++);
				func_traits::arg2_type  arg2 = sq->GetValue<func_traits::arg2_type>(index++);
				func_traits::arg3_type  arg3 = sq->GetValue<func_traits::arg3_type>(index++);
				func_traits::arg4_type  arg4 = sq->GetValue<func_traits::arg4_type>(index++);
				func_traits::arg5_type  arg5 = sq->GetValue<func_traits::arg5_type>(index++);
				func_traits::arg6_type  arg6 = sq->GetValue<func_traits::arg6_type>(index++);
				func_traits::arg7_type  arg7 = sq->GetValue<func_traits::arg7_type>(index++);
				func_traits::arg8_type  arg8 = sq->GetValue<func_traits::arg8_type>(index++);
				func_traits::arg9_type  arg9 = sq->GetValue<func_traits::arg9_type>(index++);
				func_traits::arg10_type argA = sq->GetValue<func_traits::argA_type>(index++);
				func(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, argA);
				return 0;
			}
		};
		template<>
		struct impl<false>
		{
			template<int NARGS>
			static SQInteger	Delegate(CSqStack* sq, _Myfunc func, SQInteger index)
			{
				func_traits::result_type ret = func();
				sq->Push(ret);
				return 1;
			}

			template<>
			static SQInteger	Delegate<1>(CSqStack* sq, _Myfunc func, SQInteger index)
			{
				func_traits::arg1_type arg1 = sq->GetValue<func_traits::arg1_type>(index++);
				func_traits::result_type ret = func(arg1);
				sq->Push(ret);
				return 1;
			}
			template<>
			static SQInteger	Delegate<2>(CSqStack* sq, _Myfunc func, SQInteger index)
			{
				func_traits::arg1_type arg1 = sq->GetValue<func_traits::arg1_type>(index++);
				func_traits::arg2_type arg2 = sq->GetValue<func_traits::arg2_type>(index++);
				func_traits::result_type ret = func(arg1, arg2);
				sq->Push(ret);
				return 1;
			}
			template<>
			static SQInteger	Delegate<3>(CSqStack* sq, _Myfunc func, SQInteger index)
			{
				func_traits::arg1_type arg1 = sq->GetValue<func_traits::arg1_type>(index++);
				func_traits::arg2_type arg2 = sq->GetValue<func_traits::arg2_type>(index++);
				func_traits::arg3_type arg3 = sq->GetValue<func_traits::arg3_type>(index++);
				func_traits::result_type ret = func(arg1, arg2, arg3);
				sq->Push(ret);
				return 1;
			}
			template<>
			static SQInteger	Delegate<4>(CSqStack* sq, _Myfunc func, SQInteger index)
			{
				func_traits::arg1_type arg1 = sq->GetValue<func_traits::arg1_type>(index++);
				func_traits::arg2_type arg2 = sq->GetValue<func_traits::arg2_type>(index++);
				func_traits::arg3_type arg3 = sq->GetValue<func_traits::arg3_type>(index++);
				func_traits::arg4_type arg4 = sq->GetValue<func_traits::arg4_type>(index++);
				func_traits::result_type ret = func(arg1, arg2, arg3, arg4);
				sq->Push(ret);
				return 1;
			}
			template<>
			static SQInteger	Delegate<5>(CSqStack* sq, _Myfunc func, SQInteger index)
			{
				func_traits::arg1_type arg1 = sq->GetValue<func_traits::arg1_type>(index++);
				func_traits::arg2_type arg2 = sq->GetValue<func_traits::arg2_type>(index++);
				func_traits::arg3_type arg3 = sq->GetValue<func_traits::arg3_type>(index++);
				func_traits::arg4_type arg4 = sq->GetValue<func_traits::arg4_type>(index++);
				func_traits::arg5_type arg5 = sq->GetValue<func_traits::arg5_type>(index++);
				func_traits::result_type ret = func(arg1, arg2, arg3, arg4, arg5);
				sq->Push(ret);
				return 1;
			}
			template<>
			static SQInteger	Delegate<6>(CSqStack* sq, _Myfunc func, SQInteger index)
			{
				func_traits::arg1_type arg1 = sq->GetValue<func_traits::arg1_type>(index++);
				func_traits::arg2_type arg2 = sq->GetValue<func_traits::arg2_type>(index++);
				func_traits::arg3_type arg3 = sq->GetValue<func_traits::arg3_type>(index++);
				func_traits::arg4_type arg4 = sq->GetValue<func_traits::arg4_type>(index++);
				func_traits::arg5_type arg5 = sq->GetValue<func_traits::arg5_type>(index++);
				func_traits::arg6_type arg6 = sq->GetValue<func_traits::arg6_type>(index++);
				func_traits::result_type ret = func(arg1, arg2, arg3, arg4, arg5, arg6);
				sq->Push(ret);
				return 1;
			}
			template<>
			static SQInteger	Delegate<7>(CSqStack* sq, _Myfunc func, SQInteger index)
			{
				func_traits::arg1_type arg1 = sq->GetValue<func_traits::arg1_type>(index++);
				func_traits::arg2_type arg2 = sq->GetValue<func_traits::arg2_type>(index++);
				func_traits::arg3_type arg3 = sq->GetValue<func_traits::arg3_type>(index++);
				func_traits::arg4_type arg4 = sq->GetValue<func_traits::arg4_type>(index++);
				func_traits::arg5_type arg5 = sq->GetValue<func_traits::arg5_type>(index++);
				func_traits::arg6_type arg6 = sq->GetValue<func_traits::arg6_type>(index++);
				func_traits::arg7_type  arg7 = sq->GetValue<func_traits::arg7_type>(index++);
				func_traits::result_type ret = func(arg1, arg2, arg3, arg4, arg5, arg6, arg7);
				sq->Push(ret);
				return 1;
			}
			template<>
			static SQInteger	Delegate<8>(CSqStack* sq, _Myfunc func, SQInteger index)
			{
				func_traits::arg1_type arg1 = sq->GetValue<func_traits::arg1_type>(index++);
				func_traits::arg2_type arg2 = sq->GetValue<func_traits::arg2_type>(index++);
				func_traits::arg3_type arg3 = sq->GetValue<func_traits::arg3_type>(index++);
				func_traits::arg4_type arg4 = sq->GetValue<func_traits::arg4_type>(index++);
				func_traits::arg5_type arg5 = sq->GetValue<func_traits::arg5_type>(index++);
				func_traits::arg6_type arg6 = sq->GetValue<func_traits::arg6_type>(index++);
				func_traits::arg7_type  arg7 = sq->GetValue<func_traits::arg7_type>(index++);
				func_traits::arg8_type  arg8 = sq->GetValue<func_traits::arg8_type>(index++);
				func_traits::result_type ret = func(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
				sq->Push(ret);
				return 1;
			}
			template<>
			static SQInteger	Delegate<9>(CSqStack* sq, _Myfunc func, SQInteger index)
			{
				func_traits::arg1_type arg1 = sq->GetValue<func_traits::arg1_type>(index++);
				func_traits::arg2_type arg2 = sq->GetValue<func_traits::arg2_type>(index++);
				func_traits::arg3_type arg3 = sq->GetValue<func_traits::arg3_type>(index++);
				func_traits::arg4_type arg4 = sq->GetValue<func_traits::arg4_type>(index++);
				func_traits::arg5_type arg5 = sq->GetValue<func_traits::arg5_type>(index++);
				func_traits::arg6_type arg6 = sq->GetValue<func_traits::arg6_type>(index++);
				func_traits::arg7_type  arg7 = sq->GetValue<func_traits::arg7_type>(index++);
				func_traits::arg8_type  arg8 = sq->GetValue<func_traits::arg8_type>(index++);
				func_traits::arg9_type  arg9 = sq->GetValue<func_traits::arg9_type>(index++);
				func_traits::result_type ret = func(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
				sq->Push(ret);
				return 1;
			}
			template<>
			static SQInteger	Delegate<10>(CSqStack* sq, _Myfunc func, SQInteger index)
			{
				func_traits::arg1_type arg1 = sq->GetValue<func_traits::arg1_type>(index++);
				func_traits::arg2_type arg2 = sq->GetValue<func_traits::arg2_type>(index++);
				func_traits::arg3_type arg3 = sq->GetValue<func_traits::arg3_type>(index++);
				func_traits::arg4_type arg4 = sq->GetValue<func_traits::arg4_type>(index++);
				func_traits::arg5_type arg5 = sq->GetValue<func_traits::arg5_type>(index++);
				func_traits::arg6_type arg6 = sq->GetValue<func_traits::arg6_type>(index++);
				func_traits::arg7_type  arg7 = sq->GetValue<func_traits::arg7_type>(index++);
				func_traits::arg8_type  arg8 = sq->GetValue<func_traits::arg8_type>(index++);
				func_traits::arg9_type  arg9 = sq->GetValue<func_traits::arg9_type>(index++);
				func_traits::arg10_type argA = sq->GetValue<func_traits::argA_type>(index++);
				func_traits::result_type ret = func(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, argA);
				sq->Push(ret);
				return 1;
			}
		};

	};
};

}	// end of namespace sq
}	// end of namespace iris

#endif

#endif
