//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		SqFunctor.h
 * @brief		Squirrel ֐ĂяoNX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_SqFunctor_H_
#define INCG_IRIS_SqFunctor_H_

//======================================================================
// include
#include "../sq_inchead.h"
#include "../SqScope.h"
#include "../../../c++0x/cpp0x_type_traits.hpp"
#include "../../../c++0x/cpp0x_enable_if.hpp"

#ifdef _IRIS_SUPPORT_SQUIRREL

namespace iris {
namespace sq
{

//======================================================================
// declare
class CSquirrelVM;

//======================================================================
// class
/**
 * @ingroup	squirrel
 * @brief	squirrel ֐R[NX
*/
class CSqFunctor : public IIrisObject
{
private:
	CSquirrelVM*	m_sq;		//!< squirrel
	SQInteger		m_top;		//!< top
	int				m_args;		//!< ̐
public:
	// RXgN^
	CSqFunctor(CSquirrelVM* sq, LPCSQSTR lpName);
	CSqFunctor(CSqFunctor& obj);
	// fXgN^
	~CSqFunctor(void);

public:
	/**
	 * @brief	LȏԂǂ
	*/
	bool		IsValid(void)	const	{ return m_args > 0; }

public:
	bool		Create(LPCSQSTR lpName);

public:
	// Zbg
	CSqFunctor&	PushInteger(SQInteger n);
	CSqFunctor&	PushBool(SQBool b);
	CSqFunctor&	PushFloat(SQFloat f);
	CSqFunctor&	PushPointer(SQUserPointer p);
	CSqFunctor&	PushString(const SQChar* s, SQInteger len);

	template<typename TN>
	CSqFunctor&	Push(TN v)
	{
		if( IsValid() )
		{
			++m_args;
			m_sq->PushValue(v);
		}
		return *this;
	}

	template<typename TN, size_t SIZE>
	CSqFunctor&	Push(TN (&v)[SIZE])							{ for( size_t i=0; i < SIZE; ++i ) Push(v[i]); return *this; }

	template<size_t SIZE>
	CSqFunctor&	Push(const SQChar (&v)[SIZE])				{ return PushString(v, -1); }
public:
	// Ăяo
	SQRESULT	Call(SQBool retVal);

	// ߂l擾
	template<typename TN>
	TN			GetReturnValue(void);

	// I
	void		Finish(void);

public:
	/**
	 * @brief	߂ľ^w肵ČĂяo
	*/
	template<typename Ret>
	Ret			Exec(void)
	{
		Call(SQTrue);
		Ret ret = GetReturnValue<Ret>();
		Finish();
		return ret;
	}
	void		Exec(void)
	{
		Call(SQFalse);
		Finish();
	}
private:
	// 
	void		Reset(void);

};

/**
 * @brief	߂lvZbg squirrel ֐NX
*/
template<typename R>
class CTSqFunctor : public CSqFunctor
{
	typedef typename CTSqFunctor<R>	_Myt;
protected:
	static const SQBool	retVal = cpp0x::is_same<void, R>::value ? SQFalse : SQTrue;
	typedef typename iml::type_select< (retVal == SQFalse), SQRESULT, R >::type	_Myreturn;

public:
	/**
	 * @brief	RXgN^
	*/
	CTSqFunctor(CSqFunctor& obj)
		: CSqFunctor(obj)
	{}

private:
	template<typename TR>
	_Myreturn		ExecImpl(typename disable_if_t< cpp0x::is_same<void, TR> >::type*& =cpp0x::enabler::value)
	{
		Call(retVal);
		_Myreturn ret = GetReturnValue<_Myreturn>();
		Finish();
		return ret;
	}
	template<typename TR>
	_Myreturn		ExecImpl(typename enable_if_t< cpp0x::is_same<void, TR> >::type*& =cpp0x::enabler::value)
	{
		_Myreturn ret = Call(retVal);
		Finish();
		return ret;
	}

public:

	template<typename T1>
	_Myreturn		Exec(T1 a1)
	{ Push(a1); return ExecImpl<R>(); }
	template<typename T1, typename T2>
	_Myreturn		Exec(T1 a1, T2 a2)
	{ Push(a1); return Exec(a2); }
	template<typename T1, typename T2, typename T3>
	_Myreturn		Exec(T1 a1, T2 a2, T3 a3)
	{ Push(a1); return Exec(a2, a3); }
	template<typename T1, typename T2, typename T3, typename T4>
	_Myreturn		Exec(T1 a1, T2 a2, T3 a3, T4 a4)
	{ Push(a1); return Exec(a2, a3, a4); }
	template<typename T1, typename T2, typename T3, typename T4, typename T5>
	_Myreturn		Exec(T1 a1, T2 a2, T3 a3, T4 a4, T5 a5)
	{ Push(a1); return Exec(a2, a3, a4, a5); }
	template<typename T1, typename T2, typename T3, typename T4, typename T5, typename T6>
	_Myreturn		Exec(T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6)
	{ Push(a1); return Exec(a2, a3, a4, a5, a6); }
	template<typename T1, typename T2, typename T3, typename T4, typename T5, typename T6, typename T7>
	_Myreturn		Exec(T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7)
	{ Push(a1); return Exec(a2, a3, a4, a5, a6, a7); }
	template<typename T1, typename T2, typename T3, typename T4, typename T5, typename T6, typename T7, typename T8>
	_Myreturn		Exec(T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8)
	{ Push(a1); return Exec(a2, a3, a4, a5, a6, a7, a8); }
	template<typename T1, typename T2, typename T3, typename T4, typename T5, typename T6, typename T7, typename T8, typename T9>
	_Myreturn		Exec(T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, T9 a9)
	{ Push(a1); return Exec(a2, a3, a4, a5, a6, a7, a8, a9); }
	template<typename T1, typename T2, typename T3, typename T4, typename T5, typename T6, typename T7, typename T8, typename T9, typename T10>
	_Myreturn		Exec(T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, T9 a9, T10 a10)
	{ Push(a1); return Exec(a2, a3, a4, a5, a6, a7, a8, a9, a10); }

	_Myreturn		Exec(void)
	{
		return ExecImpl<R>();
	}
};

}	// end of namespace sq
}	// end of namespace iris

#endif

#endif
