//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		SqVM.cpp
 * @brief		squirrel t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_SqVM_CPP_

//======================================================================
// include
#include "SqVM.h"

#ifdef _IRIS_SUPPORT_SQUIRREL

#include "SqCompiler.h"
#include "SqError.h"
#include <stdio.h>
#include <stdarg.h>
#include <tchar.h>

//======================================================================
// link
#if	defined(IRIS_MSC)

#if defined(_IRIS_SUPPORT_SQSTD)
#pragma comment (lib, "sqstdlib_"	\
				IRIS_LIB_MODE		\
				IRIS_LIB_VCVER		\
				IRIS_LIB_AMD64		\
				IRIS_LIB_POSTFIX	\
				".lib")
#endif

#pragma comment (lib, "squirrel_"	\
				IRIS_LIB_MODE		\
				IRIS_LIB_VCVER		\
				IRIS_LIB_AMD64		\
				IRIS_LIB_POSTFIX	\
				".lib")
#endif

#if	defined(IRIS_MSC)

IRIS_PRAGMA_PUSH_MACRO(_SC)
#undef _SC
#define _SC(x)		x
IRIS_PRAGMA_MESSAGE(SQUIRREL_VERSION)
IRIS_PRAGMA_POP_MACRO(_SC)

#endif

namespace iris {
namespace sq
{

//======================================================================
// function
/**********************************************************************//**
 * @private
 * @internal
 *
 * squirrel printf
 *
 -----------------------------------------------------------------------
 * @param [in]	vm		= z}V
 * @param [in]	format	= o͕tH[}bg
 * @param [in]	...		= 
*//***********************************************************************/
void _sq_printffunc(HSQUIRRELVM vm, const SQChar* format, ...)
{
	IRIS_UNUSED_VAR(vm);
	va_list va;
	va_start(va, format);
	_vtprintf(format, va);
	va_end(va);
}
/**********************************************************************//**
 * @private
 * @internal
 *
 * error printf
 *
 -----------------------------------------------------------------------
 * @param [in]	vm		= z}V
 * @param [in]	format	= o͕tH[}bg
 * @param [in]	...		= 
*//***********************************************************************/
void _sq_errorfunc(HSQUIRRELVM vm, const SQChar* format, ...)
{
	IRIS_UNUSED_VAR(vm);
	va_list va;
	va_start(va, format);
	_vtprintf(format, va);
	va_end(va);
}


//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CSquirrelVM::CSquirrelVM(void)
: m_VM(nullptr)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	vm = z}V
*//***********************************************************************/
CSquirrelVM::CSquirrelVM(HSQUIRRELVM vm)
: m_VM(vm)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CSquirrelVM::~CSquirrelVM(void)
{
	Close();
}

/**********************************************************************//**
 *
 * z}VJ
 *
 ----------------------------------------------------------------------
 * @param [in]	initialstacksize = X^bNTCY
*//***********************************************************************/
void CSquirrelVM::Open(SQInteger initialstacksize)
{
	if( m_VM != nullptr ) return;
	m_VM = sq_open(initialstacksize);
	// Wo͊֐ݒ
	sq_setprintfunc(m_VM, _sq_printffunc, _sq_errorfunc);
	PushRootTable();
}

/**********************************************************************//**
 *
 * z}VJ
 *
*//***********************************************************************/
void CSquirrelVM::Close(void)
{
	if( m_VM == nullptr ) return;
	sq_close(m_VM);
	m_VM = nullptr;
}

/**********************************************************************//**
 *
 * XNvg̃RpC
 *
 ----------------------------------------------------------------------
 * @param [in]	lpFile		= t@CpX
 * @return	Ug
*//***********************************************************************/
SQRESULT CSquirrelVM::Compile(LPCSQSTR lpFile)
{
	CSqCompiler compiler(this);
	return compiler.Compile(lpFile);
}

/**********************************************************************//**
 *
 * XNvg̃RpC
 *
 ----------------------------------------------------------------------
 * @param [in]	lpFile		= t@CpX
 * @return	Ug
*//***********************************************************************/
SQRESULT CSquirrelVM::CompileBuffer(const SQChar *s, SQInteger size, LPCSQSTR lpszName)
{
	CSqCompiler compiler(this);
	return compiler.CompileBuffer(s, size, SQTrue, lpszName);
}

/**********************************************************************//**
 *
 * XNvg̃RpCƎs
 *
 ----------------------------------------------------------------------
 * @param [in]	lpFile		= t@CpX
 * @param [in]	retVal		= ߂l̗L
 * @param [in]	printerror	= G[o͂邩ǂ
 * @return	Ug
*//***********************************************************************/
SQRESULT CSquirrelVM::DoFile(LPCSQSTR lpFile, SQBool retVal, SQBool printerror)
{
#if defined(_IRIS_SUPPORT_SQSTD)
	SQRESULT sr = sqstd_dofile(m_VM, lpFile, retVal, printerror);
#else
	SQRESULT sr = Compile(lpFile);
	if( SQ_SUCCEEDED(sr) )
	{
		Push(-2);
		sr = Call(1, retVal, printerror);
		if( SQ_SUCCEEDED(sr) )
		{
			Remove(retVal ? -2 : -1);
			return SQ_OK;
		}
	}
	Pop(1);
#endif
	SCSQ_ERROR(sr);
	return sr;
}

/**********************************************************************//**
 *
 * XNvg̎s
 *
 ----------------------------------------------------------------------
 * @param [in]	retVal		= ߂l̗L
 * @param [in]	printerror	= G[o͂邩ǂ
 * @return	Ug
*//***********************************************************************/
SQRESULT CSquirrelVM::Run(SQBool retVal, SQBool printerror)
{
	Push(-2);
	SQRESULT sr = Call(1, retVal, printerror);
	if( SQ_SUCCEEDED(sr) )
	{
		Remove(retVal ? -2 : -1);
		return SQ_OK;
	}
	Pop(1);
	SCSQ_ERROR(sr);
	return sr;
}

/**********************************************************************//**
 *
 * ֐̎s
 *
 ----------------------------------------------------------------------
 * @param [in]	lpName		= ֐
 * @param [in]	num			= ̐
 * @param [in]	...			= CVarinat ^ϒ
 * @return	Ug
*//***********************************************************************/
SQRESULT CSquirrelVM::Exec(LPCSQSTR lpName, int num, ...)
{
	SQRESULT ret = SQ_ERROR;
	SQInteger cur = sq_gettop(m_VM);
	sq_pushroottable(m_VM);	// root
	sq_pushstring(m_VM, lpName, -1);
	if( SQ_SUCCEEDED(sq_get(m_VM, -2)) )
	{
		sq_pushroottable(m_VM);	// root
		va_list va;
		va_start(va, num);
		for( int i=0; i < num; ++i )
		{
			IRIS_PRAGMA_MSG_TODO("CVariant ͂߂܂傤")

			variant* var = va_arg(va, variant*);
			VARTYPE vt = var->type();
			if( vt & VT_BYREF )
			{
				switch(vt & (~VT_BYREF))
				{
				case VT_I1:
					sq_pushstring(m_VM, var->value<const SQChar*>(), -1);
					break;
				default:
					sq_pushuserpointer(m_VM, var->value<SQUserPointer>());
					break;
				}
			}
			else
			{
				switch(vt & (~VT_BYREF))
				{
				case VT_NULL:
					sq_pushnull(m_VM);
					break;
				case VT_I1:
				case VT_I2:
				case VT_I4:
				case VT_I8:
				case VT_UI1:
				case VT_UI2:
				case VT_UI4:
				case VT_UI8:
					sq_pushinteger(m_VM, var->value<SQInteger>());
					break;
				case VT_R4:
				case VT_R8:
					sq_pushfloat(m_VM, var->value<SQFloat>());
					break;
				case VT_BOOL:
					sq_pushbool(m_VM, var->value<SQBool>());
					break;
				}
			}
		}
		ret = sq_call(m_VM, num+1, SQFalse, SQTrue);
		va_end(va);
	}
	sq_settop(m_VM, cur);
	return ret;
}

/**********************************************************************//**
 *
 * ֐̌ĂяoGg
 *
 ----------------------------------------------------------------------
 * @param [in]	lpName		= ֐
 * @return	֐sIuWFNg
*//***********************************************************************/
CSqFunctor CSquirrelVM::Func(LPCSQSTR lpName)
{
	CSqFunctor func(this, lpName);
	return func;
}

/**********************************************************************//**
 *
 * ֐o^
 *
 ----------------------------------------------------------------------
 * @param [in]	func		= ֐
 * @param [in]	lpName		= ֐
 * @return	
*//***********************************************************************/
SQRESULT CSquirrelVM::RegisterFunction(SQFUNCTION func, LPCSQSTR lpName)
{
	SQRESULT ret;
	sq_pushroottable(m_VM);
	sq_pushstring(m_VM, lpName, -1);
	sq_newclosure(m_VM, func, 0);
	ret = sq_createslot(m_VM, -3);
	sq_pop(m_VM, 1);
	return ret;
}

// Utility
/**********************************************************************//**
 *
 * _v֐
 *
 ----------------------------------------------------------------------
 * @param [in]	vm	= z}V
 * @return	
*//***********************************************************************/
SQInteger CSquirrelVM::Utility::DumpArgs(HSQUIRRELVM vm)
{
	SQInteger num = sq_gettop(vm);
	printf("dump args\n");
	printf("(");
	for(SQInteger i=1; i <= num; ++i)
	{
		if( i!=1 ) printf("\n, ");
#define DUMP(type)	case type: printf(#type); break

		switch(sq_gettype(vm, i))
		{
			DUMP(OT_NULL);
			DUMP(OT_INTEGER);
			DUMP(OT_FLOAT);
			DUMP(OT_BOOL);
			DUMP(OT_STRING);
			DUMP(OT_TABLE);
			DUMP(OT_ARRAY);
			DUMP(OT_USERDATA);
			DUMP(OT_CLOSURE);
			DUMP(OT_NATIVECLOSURE);
			DUMP(OT_GENERATOR);
			DUMP(OT_USERPOINTER);
			DUMP(OT_THREAD);
			DUMP(OT_FUNCPROTO);
			DUMP(OT_CLASS);
			DUMP(OT_INSTANCE);
			DUMP(OT_WEAKREF);
			DUMP(OT_OUTER);
		default:
			return sq_throwerror(vm, IRIS_TEXT("invalid param") );
		}
	}
	printf(")\n");
	return 0;
}

}	// end of namespace sq
}	// end of namespace iris


#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST) ) || defined(_IRIS_SUPPORT_GOOGLETEST)

//======================================================================
// include
#include "../../unit/UnitCore.h"
#include "../../iris_using.h"
#include "../../iris_iostream.h"

//======================================================================
// test
IRIS_UNITTEST(CSqVMUnitTest, UserSelect)
{
	CSquirrelVM sq;
	SQChar path[MAX_PATH] = _SC("../../../data/script/squirrel/hello.nut");

#if defined(_IRIS_SUPPORT_AUTO_UNITTEST)
#else
	std::clog << "squirrel t@Cw" << std::endl;
	std::tcin >> path;
#endif

	sq.Open(4096);

	sq.DoFile(path, SQFalse, SQTrue);

	std::clog << std::endl;
}

IRIS_UNITTEST(CSqVMUnitTest, HelloWorld)
{
	CSquirrelVM sq;
	::iris::unit::CUtPath path(_SC("iris/framework/sample/data/script/squirrel/hello.nut"));

	sq.Open(4096);

	ASSERT_TRUE( SQ_SUCCEEDED(sq.DoFile(path, SQFalse, SQTrue)) );

	std::clog << std::endl;
}

IRIS_UNITTEST(CSqVMUnitTest, Function)
{
	CSquirrelVM sq;
	::iris::unit::CUtPath path(_SC("iris/framework/sample/data/script/squirrel/foo.nut"));
	//SQChar path[MAX_PATH] = _SC("../../../data/script/squirrel/foo.nut");

	sq.Open(4096);
	ASSERT_TRUE( SQ_SUCCEEDED(sq.DoFile(path, SQFalse)) );

	{
		CSqFunctor func = sq.Func(_SC("hello"));
		ASSERT_TRUE( func.IsValid() );
		ASSERT_TRUE( SQ_SUCCEEDED( func.Call(SQFalse) ) );
		func.GetReturnValue<void>();
		std::clog << std::endl;
	}

	{
		CTSqFunctor<SQInteger> func = sq.Func(_SC("add"));
		ASSERT_TRUE( func.IsValid() );
		SQInteger ret = func.Exec(101, 7);
		ASSERT_EQ( 108, ret );
	}

	{
		CTSqFunctor<SQFloat> func = sq.Func(_SC("add"));
		ASSERT_TRUE( func.IsValid() );
		SQFloat ret = func.Exec(2.0f, 1.2f);
		ASSERT_EQ( 3.2f, ret );
	}
}

#endif

#endif
