//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		SqStack.h
 * @brief		Squirrel Stack NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_SqStack_H_
#define INCG_IRIS_SqStack_H_

//======================================================================
// include
#include "SqScope.h"

#ifdef _IRIS_SUPPORT_SQUIRREL

namespace iris {
namespace sq
{

//======================================================================
// class
/**
 * @ingroup	squirrel
 * @bref	squirrel ֐R[NX
*/
class CSqStack : protected CSqScope
{
public:
	// RXgN^
	explicit CSqStack(HSQUIRRELVM vm);
	explicit CSqStack(CSquirrelVM* vm);
	// fXgN^
	~CSqStack(void);

public:

	// ̐擾
	SQInteger		GetParamCount(void)	const;

public:
	// ^擾
	SQObjectType	GetType(SQInteger idx) const;

	// l̎擾
	SQInteger		GetInteger(SQInteger idx)		const;
	SQBool			GetBool(SQInteger idx)			const;
	SQFloat			GetFloat(SQInteger idx)			const;
	SQUserPointer	GetUserPointer(SQInteger idx)	const;
	LPCSQSTR		GetString(SQInteger idx)		const;
	HSQOBJECT		GetObjectHandle(SQInteger idx)	const;
	SQUserPointer	GetInstanceUp(SQInteger idx, SQUserPointer tag)	const;
	SQUserPointer	GetUserData(SQInteger idx, SQUserPointer tag=0)	const;

public:
	template<typename TN>
	TN				GetValue(SQInteger idx)	const	{ return GetValue<TN>(m_vm, idx); }

public:
	// ߂lݒ
	void		PushInteger(SQInteger n);
	void		PushBool(SQBool b);
	void		PushFloat(SQFloat f);
	void		PushNull(void);
	void		PushUserPointer(SQUserPointer p);
	void		PushString(LPCSQSTR s, SQInteger len);

public:
	template<typename TN>
	void		Push(TN v)						{ if( m_vm != nullptr ) PushValue(m_vm, v); }

	template<typename TN, size_t SIZE>
	void		Push(TN (&v)[SIZE])				{ for( size_t i=0; i < SIZE; ++i ) Push(v[i]); return *this; }

	template<size_t SIZE>
	void		Push(const SQChar (&v)[SIZE])	{ return PushString(v, -1); }

public:
	static SQObjectType		GetType(HSQUIRRELVM vm, SQInteger idx)				{ return sq_gettype(vm, idx); }
	static SQInteger		GetInteger(HSQUIRRELVM vm, SQInteger idx)			{ SQInteger v=0; sq_getinteger(vm, idx, &v); return v; }
	static SQBool			GetBool(HSQUIRRELVM vm, SQInteger idx)				{ SQBool v=0; sq_getbool(vm, idx, &v); return v; }
	static SQFloat			GetFloat(HSQUIRRELVM vm, SQInteger idx)				{ SQFloat v=0; sq_getfloat(vm, idx, &v); return v; }
	static SQUserPointer	GetUserPointer(HSQUIRRELVM vm, SQInteger idx)		{ SQUserPointer v=0; sq_getuserpointer(vm, idx, &v); return v; }
	static LPCSQSTR			GetString(HSQUIRRELVM vm, SQInteger idx)			{ LPCSQSTR v=nullptr; sq_getstring(vm, idx, &v); return v; }
	static HSQOBJECT		GetObjectHandle(HSQUIRRELVM vm, SQInteger idx)		{ HSQOBJECT v; sq_resetobject(&v); sq_getstackobj(vm, idx, &v); return v; }
	static SQUserPointer	GetUserData(HSQUIRRELVM vm, SQInteger idx, SQUserPointer tag=0)		{ SQUserPointer v=0, otag=0; sq_getuserdata(vm, idx, &v, &otag); if( tag == otag ) return v; return NULL; }
	static SQUserPointer	GetInstanceUp(HSQUIRRELVM vm, SQInteger idx, SQUserPointer tag)		{  SQUserPointer v=0; sq_getinstanceup(vm, idx, &v, tag); return v; }

	template<typename TN>
	static TN				GetValue(HSQUIRRELVM vm, SQInteger idx);

public:
	static void		PushInteger(HSQUIRRELVM vm, SQInteger n)		{ sq_pushinteger(vm, n); }
	static void		PushBool(HSQUIRRELVM vm, SQBool b)				{ sq_pushbool(vm, b); }
	static void		PushFloat(HSQUIRRELVM vm, SQFloat f)			{ sq_pushfloat(vm, f); }
	static void		PushNull(HSQUIRRELVM vm)						{ sq_pushnull(vm); }
	static void		PushUserPointer(HSQUIRRELVM vm, SQUserPointer p)		{ sq_pushuserpointer(vm, p); }
	static void		PushString(HSQUIRRELVM vm, LPCSQSTR s, SQInteger len)	{ sq_pushstring(vm, s, len); }

	template<typename TN>
	static void		PushValue(HSQUIRRELVM vm, TN v);

	template<typename TN, size_t SIZE>
	static void		PushValue(HSQUIRRELVM vm, TN (&v)[SIZE])						{ for( size_t i=0; i < SIZE; ++i ) PushValue(vm, v[i]); return *this; }

	template<size_t SIZE>
	static void		PushValue(HSQUIRRELVM vm, const SQChar (&v)[SIZE])				{ return PushString(vm, v, -1); }
};

}	// end of namespace sq
}	// end of namespace iris

#endif

#endif
