//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		SqStack.cpp
 * @brief		Squirrel Scope t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_SqStack_CPP_

//======================================================================
// include
#include "SqStack.h"
#include "SqVM.h"
#include "../../iris_debug.h"

#ifdef _IRIS_SUPPORT_SQUIRREL

namespace iris {
namespace sq
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	vm = z}V
*//***********************************************************************/
CSqStack::CSqStack(HSQUIRRELVM vm)
: CSqScope(vm)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	vm = z}V
*//***********************************************************************/
CSqStack::CSqStack(CSquirrelVM* vm)
: CSqScope(vm)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CSqStack::~CSqStack(void)
{
	Detach();
}

/**********************************************************************//**
 *
 * ̑擾
 *
 ----------------------------------------------------------------------
 * @return	̐
*//***********************************************************************/
SQInteger CSqStack::GetParamCount(void) const
{
	return m_Top;
}

/**********************************************************************//**
 *
 * ^擾
 *
 ----------------------------------------------------------------------
 * @param [in]	idx	= CfbNX
 * @return	^̃^Cv
*//***********************************************************************/
SQObjectType CSqStack::GetType(SQInteger idx) const
{
	IRIS_ASSERT( idx > 0 && idx <= m_Top);
	IRIS_ASSERT( m_vm != nullptr );
	return GetType(m_vm, idx);
}

/**********************************************************************//**
 *
 * l擾
 *
 ----------------------------------------------------------------------
 * @param [in]	idx	= CfbNX
 * @return	l
*//***********************************************************************/
SQInteger		CSqStack::GetInteger(SQInteger idx) const
{
	IRIS_VERIFYRETURN( idx > 0 && idx <= m_Top, 0 );
	IRIS_ASSERT( m_vm != nullptr );
	return GetInteger(m_vm, idx);
}

/**********************************************************************//**
 *
 * l擾
 *
 ----------------------------------------------------------------------
 * @param [in]	idx	= CfbNX
 * @return	l
*//***********************************************************************/
SQBool			CSqStack::GetBool(SQInteger idx) const
{
	IRIS_VERIFYRETURN( idx > 0 && idx <= m_Top, 0 );
	IRIS_ASSERT( m_vm != nullptr );
	return GetBool(m_vm, idx);
}

/**********************************************************************//**
 *
 * l擾
 *
 ----------------------------------------------------------------------
 * @param [in]	idx	= CfbNX
 * @return	l
*//***********************************************************************/
SQFloat			CSqStack::GetFloat(SQInteger idx) const
{
	IRIS_VERIFYRETURN( idx > 0 && idx <= m_Top, 0 );
	IRIS_ASSERT( m_vm != nullptr );
	return GetFloat(m_vm, idx);
}

/**********************************************************************//**
 *
 * l擾
 *
 ----------------------------------------------------------------------
 * @param [in]	idx	= CfbNX
 * @return	l
*//***********************************************************************/
SQUserPointer	CSqStack::GetUserPointer(SQInteger idx) const
{
	IRIS_VERIFYRETURN( idx > 0 && idx <= m_Top, NULL );
	IRIS_ASSERT( m_vm != nullptr );
	return GetUserPointer(m_vm, idx);
}

/**********************************************************************//**
 *
 * 擾
 *
 ----------------------------------------------------------------------
 * @param [in]	idx	= CfbNX
 * @return	
*//***********************************************************************/
LPCSQSTR		CSqStack::GetString(SQInteger idx) const
{
	IRIS_VERIFYRETURN( idx > 0 && idx <= m_Top, nullptr );
	IRIS_ASSERT( m_vm != nullptr );
	return GetString(m_vm, idx);
}

/**********************************************************************//**
 *
 * l擾
 *
 ----------------------------------------------------------------------
 * @param [in]	idx	= CfbNX
 * @return	l
*//***********************************************************************/
HSQOBJECT		CSqStack::GetObjectHandle(SQInteger idx) const
{
	IRIS_ASSERT( idx > 0 && idx <= m_Top );
	IRIS_ASSERT( m_vm != nullptr );
	return GetObjectHandle(m_vm, idx);
}

/**********************************************************************//**
 *
 * l擾
 *
 ----------------------------------------------------------------------
 * @param [in]	idx	= CfbNX
 * @param [in]	tag	= CX^X
 * @return	l
*//***********************************************************************/
SQUserPointer	CSqStack::GetInstanceUp(SQInteger idx, SQUserPointer tag) const
{
	IRIS_VERIFYRETURN( idx > 0 && idx <= m_Top, NULL );
	IRIS_ASSERT( m_vm != nullptr );
	return GetInstanceUp(m_vm, idx, tag);
}

/**********************************************************************//**
 *
 * l擾
 *
 ----------------------------------------------------------------------
 * @param [in]	idx	= CfbNX
 * @param [in]	tag	= [U[f[^
 * @return	l
*//***********************************************************************/
SQUserPointer	CSqStack::GetUserData(SQInteger idx, SQUserPointer tag) const
{
	IRIS_VERIFYRETURN( idx > 0 && idx <= m_Top, NULL );
	IRIS_ASSERT( m_vm != nullptr );
	return GetUserData(m_vm, idx, tag);
}

/**********************************************************************//**
 *
 * PushInteger
 *
 ----------------------------------------------------------------------
 * @param [in]	n	= l
*//***********************************************************************/
void CSqStack::PushInteger(SQInteger n)
{
	IRIS_ASSERT( m_vm != nullptr );
	PushInteger(m_vm, n);
}

/**********************************************************************//**
 *
 * PushBool
 *
 ----------------------------------------------------------------------
 * @param [in]	b	= l
*//***********************************************************************/
void CSqStack::PushBool(SQBool b)
{
	IRIS_ASSERT( m_vm != nullptr );
	PushBool(m_vm, b);
}

/**********************************************************************//**
 *
 * PushFloat
 *
 ----------------------------------------------------------------------
 * @param [in]	f	= l
*//***********************************************************************/
void CSqStack::PushFloat(SQFloat f)
{
	IRIS_ASSERT( m_vm != nullptr );
	PushFloat(m_vm, f);
}

/**********************************************************************//**
 *
 * PushNull
 *
*//***********************************************************************/
void CSqStack::PushNull(void)
{
	IRIS_ASSERT( m_vm != nullptr );
	PushNull(m_vm);
}

/**********************************************************************//**
 *
 * PushUserPointer
 *
 ----------------------------------------------------------------------
 * @param [in]	p	= l
*//***********************************************************************/
void CSqStack::PushUserPointer(SQUserPointer p)
{
	IRIS_ASSERT( m_vm != nullptr );
	PushUserPointer(m_vm, p);
}

/**********************************************************************//**
 *
 * PushString
 *
 ----------------------------------------------------------------------
 * @param [in]	s	= 
 * @param [in]	len	= (-1:vZ)
*//***********************************************************************/
void CSqStack::PushString(LPCSQSTR s, SQInteger len)
{
	IRIS_ASSERT( m_vm != nullptr );
	PushString(m_vm, s, len);
}

/**********************************************************************//**
 *
 * Get
 *
 ----------------------------------------------------------------------
 * @return	l
*//***********************************************************************/
template<>
SQInteger		CSqStack::GetValue<SQInteger>(HSQUIRRELVM vm, SQInteger idx)		{ return GetInteger(vm, idx); }
template<>
SQBool			CSqStack::GetValue<SQBool>(HSQUIRRELVM vm, SQInteger idx)			{ return GetBool(vm, idx); }
template<>
SQFloat			CSqStack::GetValue<SQFloat>(HSQUIRRELVM vm, SQInteger idx)			{ return GetFloat(vm, idx); }
template<>
SQUserPointer	CSqStack::GetValue<SQUserPointer>(HSQUIRRELVM vm, SQInteger idx)	{ return GetUserPointer(vm, idx); }
template<>
LPCSQSTR		CSqStack::GetValue<LPCSQSTR>(HSQUIRRELVM vm, SQInteger idx)			{ return GetString(vm, idx); }
template<>
HSQOBJECT		CSqStack::GetValue<HSQOBJECT>(HSQUIRRELVM vm, SQInteger idx)		{ return GetObjectHandle(vm, idx); }

/**********************************************************************//**
 *
 * Push
 *
 ----------------------------------------------------------------------
 * @param [in]	v	= l
*//***********************************************************************/
template<>
void	CSqStack::PushValue<SQInteger>(HSQUIRRELVM vm, SQInteger v)			{ return PushInteger(vm, v); }
template<>
void	CSqStack::PushValue<SQBool>(HSQUIRRELVM vm, SQBool v)				{ return PushBool(vm, v); }
template<>
void	CSqStack::PushValue<SQFloat>(HSQUIRRELVM vm, SQFloat v)				{ return PushFloat(vm, v); }
template<>
void	CSqStack::PushValue<LPCSQSTR>(HSQUIRRELVM vm, LPCSQSTR v)			{ return PushString(vm, v, -1); }
template<>
void	CSqStack::PushValue<SQUserPointer>(HSQUIRRELVM vm, SQUserPointer v)	{ return PushUserPointer(vm, v); }

}	// end of namespace sq
}	// end of namespace iris

#endif
