//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		SqCompiler.cpp
 * @brief		Squirrel Compiler t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_SqCompiler_CPP_

//======================================================================
// include
#include "SqCompiler.h"
#include "SqVM.h"
#include "../../fnd/io/FndFile.h"
#include "../../iris_xchar.hpp"
#include "../../iris_debug.h"

#ifdef _IRIS_SUPPORT_SQUIRREL

namespace iris {
namespace sq
{

namespace
{
	static LPCSQSTR _dummyName = IRIS_XTEXT(SQChar, "");

	void _defaultErrorHandle(HSQUIRRELVM vm, LPCSTR desc, LPCSTR source, SQInteger line, SQInteger column)
	{
		IRIS_UNUSED_VAR(vm);
		IRIS_UNUSED_VAR(column);
		CHAR msg[32];
		dprintfA(source);
		dprintfA(":");
		wsprintfA(msg, "%d", line);
		dprintfA(msg);
		dprintfA(": error: ");
		dprintfA(desc);
	}
	void _defaultErrorHandle(HSQUIRRELVM vm, LPCWSTR desc, LPCWSTR source, SQInteger line, SQInteger column)
	{
		IRIS_UNUSED_VAR(vm);
		IRIS_UNUSED_VAR(column);
		WCHAR msg[32];
		dprintfW(source);
		dprintfW(L":");
		wsprintfW(msg, L"%d", line);
		dprintfW(msg);
		dprintfW(L": error: ");
		dprintfW(desc);
	}

	SQInteger _readAscii(SQUserPointer p)
	{
		fnd::CFile *pFile = pointer_cast<fnd::CFile*>(p);
		char c;
		if( pFile->Read(&c, sizeof(c), 1) > 0 ) return c;
		return 0;
	}
}

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	sq		= squirrel NX
*//***********************************************************************/
CSqCompiler::CSqCompiler(CSquirrelVM* sq)
: m_sq(sq)
{
	IRIS_ASSERT( sq != nullptr );
	// G[nh̐ݒ
#if defined(_IRIS_SUPPORT_SQSTD)
	sqstd_seterrorhandlers(m_sq->GetVM());
#else
	sq_setcompilererrorhandler(m_sq->GetVM(), _defaultErrorHandle);
#endif

#ifdef _DEBUG
	sq_enabledebuginfo(m_sq->GetVM(), SQTrue);
#endif
}

/**********************************************************************//**
 *
 * t@CRpC
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszFilename	= t@C
 * @param [in]	raiseerror		= RpCG[ɃG[nhR[邩
*//***********************************************************************/
SQRESULT CSqCompiler::Compile(LPCSQSTR lpszFilename, SQBool raiseerror)
{
#if defined(_IRIS_SUPPORT_SQSTD)
	return sqstd_loadfile(m_sq->GetVM(), lpszFilename, raiseerror);
#else
	fnd::CFile file;
	if( !file.Open(lpszFilename, fnd::FOPEN_READ) ) return SQ_ERROR;
	return sq_compile(m_sq->GetVM(), _readAscii, &file, lpszFilename, raiseerror);
#endif
}

/**********************************************************************//**
 *
 * obt@RpC
 *
 ----------------------------------------------------------------------
 * @param [in]	s				= obt@
 * @param [in]	size			= obt@TCY
 * @param [in]	raiseerror		= RpCG[ɃG[nhR[邩
 * @param [in]	lpszName		= V{
*//***********************************************************************/
SQRESULT CSqCompiler::CompileBuffer(const SQChar *s, SQInteger size, SQBool raiseerror, LPCSQSTR lpszName)
{
#if defined(_IRIS_SUPPORT_SQSTD)
	return sqstd_loadfile(m_sq->GetVM(), lpszName, raiseerror);
#else
	if( size < 0 )
	{
		size = static_cast<SQInteger>(xcslen(s));
	}
	if( lpszName == nullptr )
	{
		lpszName = _dummyName;
	}
	return sq_compilebuffer(m_sq->GetVM(), s, size, lpszName, raiseerror);
#endif
}


}	// end of namespace sq
}	// end of namespace iris

#endif
