//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		PerlSystem.h
 * @brief		perl VXe t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_PerlSystem_H_
#define INCG_IRIS_PerlSystem_H_

//======================================================================
// include
#include "perl_inchead.h"
#include "../../iris_object.h"

#ifdef _IRIS_SUPPORT_PERL

namespace iris {
namespace perl
{

//======================================================================
// class
/**
 * @ingroup	perl
 * @brief	perl NX
*/
class CPerl : private INonCopyable<>
{
protected:
	PerlInterpreter*	m_pIntrp;	//!< C^v^
public:
	// RXgN^
	CPerl(void);
	// fXgN^
	~CPerl(void);

public:
	// 
	void	Initialize(int* pargc, char*** pargv);
	// I
	void	Terminate(void);

public:
	// C^v^̍쐬
	bool	Create(void);
	// C^v^̍폜
	void	Delete(void);

public:
	// parser
	void	Parser(int argc, char** argv, char** env);

	// s
	void	Run(void);
};

}	// end of namespace perl
}	// end of namespace iris

#endif

#endif
