//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		lua_inchead.h
 * @brief		lua include header t@C
 * @note		http://www.lua.org/
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_lua_inchead_H_
#define INCG_IRIS_lua_inchead_H_

//======================================================================
// include
#include "../../iris_inchead.h"
#include "../../iris_variant.hpp"

#ifdef _IRIS_SUPPORT_LUA

#if _IRIS_SUPPORT_LUA
#else
#  undef  _IRIS_SUPPORT_LUA
#  define _IRIS_SUPPORT_LUA	 IRIS_DYNAMIC_LIB
#endif

/**
 * @defgroup	lua
*/

//======================================================================
// include
#include "lua.hpp"

//======================================================================
// define
#if (LUA_VERSION_NUM/100) == 5
#  define LUA_MAJOR_VERSION	5
#endif

#if (LUA_VERSION_NUM%10) == 0
#  define LUA_MINOR_VERSION	0
#endif

#if (LUA_VERSION_NUM%10) == 1
#  define LUA_MINOR_VERSION	1
#endif

//======================================================================
// link
#if		defined(_WIN32)

#  if		(_IRIS_SUPPORT_LUA == IRIS_DYNAMIC_LIB)
#    define	LUA_LIBNAME_TYPE	""
#    define LUA_LIBNAME_MODE	""
#    define LUA_LIBNAME_VC	""
#  else
#    define	LUA_LIBNAME_TYPE		"_static_"
#    define LUA_LIBNAME_MODE		IRIS_LIB_MODE
#    define LUA_LIBNAME_VC			IRIS_LIB_VCVER
#  endif

#pragma comment( lib, "lua" \
						IRIS_PP_TOSTRING(LUA_MAJOR_VERSION) "." \
						IRIS_PP_TOSTRING(LUA_MINOR_VERSION)		\
						LUA_LIBNAME_TYPE						\
						LUA_LIBNAME_MODE						\
						LUA_LIBNAME_VC							\
						".lib" )
#endif


#endif

#endif
