//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		LuaState.h
 * @brief		LuaState t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_LuaState_H_
#define INCG_IRIS_LuaState_H_

//======================================================================
// include
#include "lua_inchead.h"
#include "iris_object.h"

#ifdef _IRIS_SUPPORT_LUA

namespace iris {
namespace lua
{

//======================================================================
// class
/**
 * @ingroup	lua
 * @brief	lua state NX
*/
class CLuaState : public IIrisObject
{
private:
	lua_State*	m_pState;	//!< Xe[g
public:
	// RXgN^
	CLuaState(void);
	// fXgN^
	~CLuaState(void);

public:
	// VK쐬
	bool	New(void);

	// 폜
	void	Delete(void);

public:
	// ǂݍ
	bool	DoFile(LPCSTR lpszFile);

public:
	// X^bN̎擾
	int		GetStackCount(void)	const;
#if defined(IRIS_WIN32)
	// X^bN̎擾
	variant	GetStack(int idx)	const;
#endif

public:
	// Lǂ
	bool	IsValid(void)	const	{ return m_pState != nullptr; }

public:
	/**
	 * @name	operator
	 * @{
	*/
	operator lua_State*	(void)	const	{ return m_pState; }
	/**
	 * @}
	*/

public:
	// X^bN̏o
	void	PrintStacks(void)	const;
};

}	// end of namespace lua
}	// end of namespace iris

#endif

#endif
