//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AsVariant.h
 * @brief		angelscript Variant t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_AsVariant_H_
#define INCG_IRIS_AsVariant_H_

//======================================================================
// include
#include "as_inchead.h"
#include "../../iris_object.h"
#include "../../c++0x/cpp0x_enable_if.hpp"
#include "../../c++0x/cpp0x_type_traits.hpp"
#include "../../iris_debug.h"

#ifdef _IRIS_SUPPORT_ANGELSCRIPT

namespace iris {
namespace as
{


/**
 * @brief	angelscript Variant
*/
class CAsVariant : public IIrisObject
{
public:
	union Variant {
		BOOL	b;
		s8		i8;
		s16		i16;
		s32		i32;
		s64		i64;
		u8		ui8;
		u16		ui16;
		u32		ui32;
		u64		ui64;
		f32		f32;
		f64		f64;
		void*	obj;
		asBYTE	as_byte;
		asWORD	as_word;
		asDWORD	as_dword;
		asQWORD	as_qword;
		asINT64	as_i64;
		asPWORD	as_pword;
	};

	template<asETypeIdFlags F>
	struct TypeObject
	{
		static const asETypeIdFlags FLAG = F;
	};
private:
	asETypeIdFlags	m_Flag;
	Variant m_Var;

public:
	CAsVariant(void);
	CAsVariant(const CAsVariant& rhs);
	template<typename T>
	CAsVariant(const T& rhs)
		: m_Flag(TypeFlag<T>::flag)
		, m_Var(VariantT<T>(rhs).var)
	{
	}
	template< template<asETypeIdFlags F>class TYPE, asETypeIdFlags FLAG, typename T>
	CAsVariant(TYPE<FLAG> t, T rhs)
		: m_Flag(FLAG)
		, m_Var(VariantT< FlagType<FLAG>::type >(rhs).var)
	{}

public:
	asETypeIdFlags	GetFlag(void) const	{ return m_Flag; }
	Variant			GetVar(void) const	{ return m_Var; }

	template<typename T>
	T	Get(typename disable_if_t< cpp0x::is_pointer<T> >::type*& = cpp0x::enabler::value)	const
	{
		IRIS_ASSERT( m_Flag != asTYPEID_MASK_SEQNBR );
		// TODO: Ђǂ
		switch( m_Flag )
		{
		case asTYPEID_BOOL:
			return static_cast<T>(m_Var.b);
		case asTYPEID_INT8:
			return static_cast<T>(m_Var.i8);
		case asTYPEID_INT16:
			return static_cast<T>(m_Var.i16);
		case asTYPEID_INT32:
			return static_cast<T>(m_Var.i32);
		case asTYPEID_INT64:
			return static_cast<T>(m_Var.i64);
		case asTYPEID_UINT8:
			return static_cast<T>(m_Var.ui8);
		case asTYPEID_UINT16:
			return static_cast<T>(m_Var.ui16);
		case asTYPEID_UINT32:
			return static_cast<T>(m_Var.ui32);
		case asTYPEID_UINT64:
			return static_cast<T>(m_Var.ui64);
		case asTYPEID_FLOAT:
			return static_cast<T>(m_Var.f32);
		case asTYPEID_DOUBLE:
			return static_cast<T>(m_Var.f64);
		default:
			IRIS_ASSERT(0);
			break;
		}
		return 0;
	}
	template<typename T>
	T	Get(typename enable_if_t< cpp0x::is_pointer<T> >::type*& = cpp0x::enabler::value)	const
	{
		IRIS_ASSERT( m_Flag != asTYPEID_VOID );
		if( m_Flag & 0x03FFFFFF )
		{
			// TODO: Ђǂ
			switch( m_Flag )
			{
			case asTYPEID_BOOL:
				return (T)(m_Var.b);
			case asTYPEID_INT8:
				return (T)(m_Var.i8);
			case asTYPEID_INT16:
				return (T)(m_Var.i16);
			case asTYPEID_INT32:
				return (T)(m_Var.i32);
			case asTYPEID_INT64:
				return (T)(m_Var.i64);
			case asTYPEID_UINT8:
				return (T)(m_Var.ui8);
			case asTYPEID_UINT16:
				return (T)(m_Var.ui16);
			case asTYPEID_UINT32:
				return (T)(m_Var.ui32);
			case asTYPEID_UINT64:
				return (T)(m_Var.ui64);
			case asTYPEID_FLOAT:
				return (T)(m_Var.f32);
			case asTYPEID_DOUBLE:
				return (T)(m_Var.f64);
			default:
				IRIS_ASSERT(0);
				break;
			}
		}
		else
		{
			return (T)(m_Var.obj);
		}
	}

private:
	template<typename T>
	union VariantT
	{
		T		t;
		Variant var;
		VariantT(T t_) : t(t_) {}
	};

	template<typename TN>
	class TypeFlag
	{
		template<typename T, typename DMY>
		struct no_integral {};
		template<typename DMY>
		struct no_integral<bool, DMY>
		{
			static const asETypeIdFlags flag = asTYPEID_BOOL;
		};
		template<typename DMY>
		struct no_integral<float, DMY>
		{
			static const asETypeIdFlags flag = asTYPEID_FLOAT;
		};
		template<typename DMY>
		struct no_integral<double, DMY>
		{
			static const asETypeIdFlags	flag = asTYPEID_DOUBLE;
		};
		template<typename DMY>
		struct no_integral<void*, DMY>
		{
			static const asETypeIdFlags	flag = asTYPEID_OBJHANDLE;
		};

		template<typename T, bool sign>
		struct integral 
		{
			static const asETypeIdFlags	flag = sizeof(T) == 1 ? asTYPEID_INT8
				: sizeof(T) == 2 ? asTYPEID_INT16
				: sizeof(T) == 4 ? asTYPEID_INT32
				: asTYPEID_INT64;
		};
		template<typename T>
		struct integral<T, false>
		{
			static const asETypeIdFlags	flag = sizeof(T) == 1 ? asTYPEID_UINT8
				: sizeof(T) == 2 ? asTYPEID_UINT16
				: sizeof(T) == 4 ? asTYPEID_UINT32
				: asTYPEID_UINT64;
		};

		template<typename T, bool is_integral>
		struct integral_filter
		{
			typedef no_integral<T, void>	type;
		};
		template<typename T>
		struct integral_filter<T, true>
		{
			typedef integral<T, cpp0x::is_signed<T>::value>	type;
		};

		template<typename T>
		struct impl
		{
			typedef typename integral_filter<T, cpp0x::is_integral<T>::value>::type type;
		};

	public:
		typedef typename impl< typename cpp0x::remove_cv<TN>::type >::type	type;
		static const asETypeIdFlags flag = type::flag;
	};

	template<asETypeIdFlags FLG>
	class FlagType
	{
		template<asETypeIdFlags F, typename DMY>
		struct impl 
		{
			typedef void*	type;
		};
		template<typename DMY>
		struct impl<asTYPEID_INT8, DMY>
		{
			typedef s8	type;
		};
		template<typename DMY>
		struct impl<asTYPEID_INT16, DMY>
		{
			typedef s16	type;
		};
		template<typename DMY>
		struct impl<asTYPEID_INT32, DMY>
		{
			typedef s32	type;
		};
		template<typename DMY>
		struct impl<asTYPEID_INT64, DMY>
		{
			typedef s64	type;
		};
		template<typename DMY>
		struct impl<asTYPEID_UINT8, DMY>
		{
			typedef u8	type;
		};
		template<typename DMY>
		struct impl<asTYPEID_UINT16, DMY>
		{
			typedef u16	type;
		};
		template<typename DMY>
		struct impl<asTYPEID_UINT32, DMY>
		{
			typedef u32	type;
		};
		template<typename DMY>
		struct impl<asTYPEID_UINT64, DMY>
		{
			typedef u64	type;
		};
		template<typename DMY>
		struct impl<asTYPEID_FLOAT, DMY>
		{
			typedef float	type;
		};
		template<typename DMY>
		struct impl<asTYPEID_DOUBLE, DMY>
		{
			typedef double	type;
		};
		template<typename DMY>
		struct impl<asTYPEID_BOOL, DMY>
		{
			typedef bool	type;
		};
	public:
		typedef typename impl<FLG, void>::type	type;
	};

};


}	// end of namespace as
}	// end of namespace iris

// iostream
#ifndef _IRIS_NOT_SUPPORT_IOSTREAM

#if defined(__cplusplus)
#include <iostream>

inline std::ostream& operator << (std::ostream& o, const iris::as::CAsVariant& v)
{
	switch( v.GetFlag() )
	{
	case asTYPEID_BOOL:
		return o << v.GetVar().b;
	case asTYPEID_INT8:
		return o << v.GetVar().i8;
	case asTYPEID_INT16:
		return o << v.GetVar().i16;
	case asTYPEID_INT32:
		return o << v.GetVar().i32;
	case asTYPEID_INT64:
		return o << v.GetVar().i64;
	case asTYPEID_UINT8:
		return o << v.GetVar().ui8;
	case asTYPEID_UINT16:
		return o << v.GetVar().ui16;
	case asTYPEID_UINT32:
		return o << v.GetVar().ui32;
	case asTYPEID_UINT64:
		return o << v.GetVar().ui64;
	case asTYPEID_FLOAT:
		return o << v.GetVar().f32;
	case asTYPEID_DOUBLE:
		return o << v.GetVar().f64;
	};
	return o << v.GetVar().obj;
}

#endif
#endif	// #ifndef _IRIS_NOT_SUPPORT_IOSTREAM

#endif

#endif