//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AsSystem.h
 * @brief		angelscript VXe t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_AsSystem_H_
#define INCG_IRIS_AsSystem_H_

//======================================================================
// include
#include "as_inchead.h"
#include "fnd/container/smart_ptr/FndRefCntPtr.h"
#include "AsContext.h"

#ifdef _IRIS_SUPPORT_ANGELSCRIPT

namespace iris {
namespace as
{

//======================================================================
// class
/**
 * @ingroup	as
 * @brief	AngelScript System NX
*/
class CAsSystem : public fnd::CObserverSubject<CAsContext>
{
	friend class CAsContext;
	typedef fnd::CRefCntPtr<asIScriptEngine>	ptr;
protected:
	asIScriptEngine*	m_pEngine;	//!< XNvgGW

public:
	// RXgN^
	CAsSystem(void);
	// fXgN^
	~CAsSystem(void);

public:
	// 
	bool	Initialize(void);
	// I
	void	Terminate(void);

public:
	// ReLXg̍쐬
	bool	CreateContext(CAsContext& context);

public:
	// W[̍쐬
	asIScriptModule*	CreateModule(LPCSTR lpszModuleName);
	// W[̎擾
	asIScriptModule*	GetModule(LPCSTR lpszModuleName);

public:
	// ֐̎擾
	LPCSTR	GetFunctionName(int funcId) const;

public:
	// ֐̎擾
	static LPCSTR	GetFunctionName(asIScriptEngine* engine, int funcId);

public:
	ptr		GetEngine(void)	const	{ return m_pEngine; }

private:
	// OR[obN
	void	ExceptionCallback(asIScriptContext* context);

private:
	virtual	void	OnDetach(CAsContext* observer);
};

}	// end of namespace as
}	// end of namespace iris

#endif

#endif
