//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AsFunction.cpp
 * @brief		angelscript ֐IuWFNg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_AsFunction_CPP_

//======================================================================
// include
#include "AsFunction.h"
#include "AsException.h"
#include "../../iris_debug.h"

#ifdef _IRIS_SUPPORT_ANGELSCRIPT

namespace iris {
namespace as
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CAsFunction::CAsFunction(void)
: m_pFunction(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CAsFunction::~CAsFunction(void)
{
	Release();
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @param [in]	system	= VXe
 * @param [in]	module	= W[
 * @param [in]	name	= O
 * @return	
*//***********************************************************************/
bool CAsFunction::Initialize(CAsSystem& system, asIScriptModule* module, LPCTSTR name)
{
	Release();
	if( module == nullptr ) return false;
	if( name == nullptr ) return false;
	asIScriptFunction* func = module->GetFunctionByName(name);
	if( func == nullptr )
	{
		func = module->GetFunctionByDecl(name);
	}
	if( func == nullptr ) return false;
	if( !system.CreateContext(m_Context) ) return false;
	int ret = m_Context.Prepare(func);
	if( AS_FAILED(ret) ) return false;
	m_pFunction = func;
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CAsFunction::Release(void)
{
	m_Context.Terminate();
	m_pFunction = nullptr;
}

/**********************************************************************//**
 *
 * LȃIuWFNgǂ
 *
 -----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
bool CAsFunction::IsValid(void) const
{
	return m_pFunction != nullptr;
}

/**********************************************************************//**
 *
 * ֐̂郂W[擾
 *
 -----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
asIScriptModule* CAsFunction::GetModule(void) const
{
	if( m_pFunction == nullptr ) return nullptr;
	asIScriptEngine* engine = m_pFunction->GetEngine();
	if( engine == nullptr ) return nullptr;
	return engine->GetModule(m_pFunction->GetModuleName());
}

/**********************************************************************//**
 *
 * s
 *
*//***********************************************************************/
void CAsFunction::Execute(void)
{
	int ret = m_Context.Execute();
	if( ret == asEXECUTION_FINISHED )
	{
		const char* p = m_Context.GetExceptionString();
		if( p != nullptr )
		{
#if _IRIS_ANGELSCRIPT_HAS_EXCEPTION
			asIScriptEngine* engine = nullptr;
			if( m_pFunction != nullptr ) engine = m_pFunction->GetEngine();
			int line, column;
			line = m_Context.GetExceptionLineNumber(&column);
			int funcId = m_Context.GetExceptionFunction();
			throw as_exception(p, CAsSystem::GetFunctionName(engine, funcId), line, column);
#endif
		}
	}
}

/**********************************************************************//**
 *
 * ߂l̎擾
 *
 -----------------------------------------------------------------------
 * @return	߂l
*//***********************************************************************/
CAsVariant CAsFunction::GetReturnValue(void) const
{
	if( m_pFunction != nullptr ) 
	{
		return m_Context.GetReturnValue(m_pFunction->GetReturnTypeId());
	}
	return CAsVariant();
}

}	// end of namespace as
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST) ) || defined(_IRIS_SUPPORT_GOOGLETEST)

//======================================================================
// include
#include "AsVM.h"
#include "../../unit/UnitCore.h"
#include "../../iris_using.h"
#include "../../iris_iostream.h"

//======================================================================
// test
IRIS_UNITTEST(CAsFunctionUnitTest, Run)
{
	char path[MAX_PATH] = "../../../data/script/angelscript/function.as";

	{
		// system
		CAsSystem system;
		system.Initialize();

		// compile
		CAsCompiler compiler;
		compiler.Initialize(system.CreateModule("test"));
		compiler.Include(path);
		compiler.Build();

		// context
		CAsVM vm(system);
		vm.Initialize(compiler);

		{
			CAsFunction func;
			if( vm.MakeFunctor(func, "as_func0") )
			{
				CAsVariant ret = func();
				std::cout << ret << std::endl;
			}
		}
		{
			CAsFunction func;
			if( vm.MakeFunctor(func, "as_func1") )
			{
				CAsVariant ret = func(100);
				std::cout << ret << std::endl;
				int x = ret.Get<int>();
				float f = ret.Get<float>();
				std::cout << x << ", " << f << std::endl;
			}
		}
		{
			CAsFunction func;
			if( vm.MakeFunctor(func, "as_func2") )
			{
				CAsVariant ret = func(-1, -90);
				std::cout << ret << std::endl;
			}
		}
	}
}

#endif

#endif
