//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AsError.cpp
 * @brief		angelscript G[ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_AsError_CPP_

//======================================================================
// include
#include "AsError.h"

#ifdef _IRIS_SUPPORT_ANGELSCRIPT

//======================================================================
// define
#define TEXTA(t)	t
#define TEXTW(t)	L##t

#define SCAS_SWITCH_ERROR_MESSAGE_(func, text)				\
	switch( Error )											\
	{														\
	case asSUCCESS:											\
		func(lpBuf, size, text("SUCCESS"));					\
		break;												\
	case asERROR:											\
		func(lpBuf, size, text("ERROR"));					\
		break;												\
	case asCONTEXT_ACTIVE:									\
		func(lpBuf, size, text("CONTEXT_ACTIVE"));			\
		break;												\
	case asCONTEXT_NOT_FINISHED:							\
		func(lpBuf, size, text("CONTEXT_NOT_FINISHED"));	\
		break;												\
	case asCONTEXT_NOT_PREPARED:							\
		func(lpBuf, size, text("CONTEXT_NOT_PREPARED"));	\
		break;												\
	case asINVALID_ARG:										\
		func(lpBuf, size, text("INVALID_ARG"));				\
		break;												\
	case asNO_FUNCTION:										\
		func(lpBuf, size, text("NO_FUNCTION"));				\
		break;												\
	case asNOT_SUPPORTED:									\
		func(lpBuf, size, text("NOT_SUPPORTED"));			\
		break;												\
	case asINVALID_NAME:									\
		func(lpBuf, size, text("INVALID_NAME"));			\
		break;												\
	case asNAME_TAKEN:										\
		func(lpBuf, size, text("NAME_TAKEN"));				\
		break;												\
	case asINVALID_DECLARATION:								\
		func(lpBuf, size, text("INVALID_DECLARATION"));		\
		break;												\
	case asINVALID_OBJECT:									\
		func(lpBuf, size, text("INVALID_OBJECT"));			\
		break;												\
	case asINVALID_TYPE:									\
		func(lpBuf, size, text("INVALID_TYPE"));			\
		break;												\
	case asALREADY_REGISTERED:								\
		func(lpBuf, size, text("ALREADY_REGISTERED"));		\
		break;												\
	case asMULTIPLE_FUNCTIONS:								\
		func(lpBuf, size, text("MULTIPLE_FUNCTIONS"));		\
		break;												\
	case asNO_MODULE:										\
		func(lpBuf, size, text("NO_MODULE"));				\
		break;												\
	case asNO_GLOBAL_VAR:									\
		func(lpBuf, size, text("NO_GLOBAL_VAR"));			\
		break;												\
	case asINVALID_CONFIGURATION:							\
		func(lpBuf, size, text("INVALID_CONFIGURATION"));	\
		break;												\
	case asINVALID_INTERFACE:								\
		func(lpBuf, size, text("INVALID_INTERFACE"));		\
		break;												\
	case asCANT_BIND_ALL_FUNCTIONS:							\
		func(lpBuf, size, text("CANT_BIND_ALL_FUNCTIONS"));	\
		break;												\
	case asLOWER_ARRAY_DIMENSION_NOT_REGISTERED:			\
		func(lpBuf, size, text("LOWER_ARRAY_DIMENSION_NOT_REGISTERED"));	\
		break;												\
	case asWRONG_CONFIG_GROUP:								\
		func(lpBuf, size, text("WRONG_CONFIG_GROUP"));		\
		break;												\
	case asCONFIG_GROUP_IS_IN_USE:							\
		func(lpBuf, size, text("CONFIG_GROUP_IS_IN_USE"));	\
		break;												\
	case asILLEGAL_BEHAVIOUR_FOR_TYPE:						\
		func(lpBuf, size, text("ILLEGAL_BEHAVIOUR_FOR_TYPE"));	\
		break;												\
	case asWRONG_CALLING_CONV:								\
		func(lpBuf, size, text("WRONG_CALLING_CONV"));		\
		break;												\
	case asBUILD_IN_PROGRESS:								\
		func(lpBuf, size, text("BUILD_IN_PROGRESS"));		\
		break;												\
	case asINIT_GLOBAL_VARS_FAILED:							\
		func(lpBuf, size, text("INIT_GLOBAL_VARS_FAILED"));	\
		break;												\
	}


namespace iris {
namespace as
{

//======================================================================
// function
/**********************************************************************//**
 *
 * G[̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	Error	= G[l
 * @param [out]	lpBuf	= o̓obt@
 * @param [in]	size	= o̓obt@TCY
*//***********************************************************************/
void	AsFormatMessage (int Error, LPTSTR lpBuf, size_t size)
{
#ifdef UNICODE
	AsFormatMessageW(Error, lpBuf, size);
#else
	AsFormatMessageA(Error, lpBuf, size);
#endif
}
/**
 * @ref	AsFormatMessage
*/
void	AsFormatMessageA(int Error, LPSTR  lpBuf, size_t size)
{
	if( lpBuf == nullptr ) return;
	SCAS_SWITCH_ERROR_MESSAGE_(strcpy_s, TEXTA);
}
/**
 * @ref	AsFormatMessage
*/
void	AsFormatMessageW(int Error, LPWSTR lpBuf, size_t size)
{
	if( lpBuf == nullptr ) return;
	SCAS_SWITCH_ERROR_MESSAGE_(wcscpy_s, TEXTW);
}

}	// end of namespace as
}	// end of namespace iris

#endif
