//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AsContext.cpp
 * @brief		angelscript ReLXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_AsContext_CPP_

//======================================================================
// include
#include "AsContext.h"
#include "../../iris_debug.h"

#ifdef _IRIS_SUPPORT_ANGELSCRIPT

namespace iris {
namespace as
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CAsContext::CAsContext(void)
: m_pContext(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CAsContext::~CAsContext(void)
{
	Terminate();
}

/**********************************************************************//**
 *
 * ֐o^
 *
 -----------------------------------------------------------------------
 * @param [in]	funcId	= ֐ID
 * @return	
*//***********************************************************************/
int CAsContext::Prepare(int funcId)
{
	IRIS_ASSERT( m_pContext != nullptr );
	return m_pContext->Prepare(funcId);
}

/**********************************************************************//**
 *
 * ֐o^
 *
 -----------------------------------------------------------------------
 * @param [in]	func	= ֐
 * @return	
*//***********************************************************************/
int CAsContext::Prepare(asIScriptFunction* func)
{
	IRIS_ASSERT( m_pContext != nullptr );
	return m_pContext->Prepare(func);
}

/**********************************************************************//**
 *
 * Oo^
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
int CAsContext::Unprepare(void)
{
	IRIS_ASSERT( m_pContext != nullptr );
	return m_pContext->Unprepare();
}

/**********************************************************************//**
 *
 * o^
 *
 -----------------------------------------------------------------------
 * @param [in]	arg		= ̃CfbNX
 * @param [in]	value	= l
*//***********************************************************************/
template<>
void CAsContext::SetArgument<asBYTE>(asUINT arg, asBYTE value)
{
	IRIS_ASSERT( m_pContext != nullptr );
	m_pContext->SetArgByte(arg, value);
}
template<>
void CAsContext::SetArgument<asWORD>(asUINT arg, asWORD value)
{
	IRIS_ASSERT( m_pContext != nullptr );
	m_pContext->SetArgWord(arg, value);
}
template<>
void CAsContext::SetArgument<asDWORD>(asUINT arg, asDWORD value)
{
	IRIS_ASSERT( m_pContext != nullptr );
	m_pContext->SetArgDWord(arg, value);
}
template<>
void CAsContext::SetArgument<asQWORD>(asUINT arg, asQWORD value)
{
	IRIS_ASSERT( m_pContext != nullptr );
	m_pContext->SetArgQWord(arg, value);
}
template<>
void CAsContext::SetArgument<float>(asUINT arg, float value)
{
	IRIS_ASSERT( m_pContext != nullptr );
	m_pContext->SetArgFloat(arg, value);
}
template<>
void CAsContext::SetArgument<double>(asUINT arg, double value)
{
	IRIS_ASSERT( m_pContext != nullptr );
	m_pContext->SetArgDouble(arg, value);
}
template<>
void CAsContext::SetArgument<void*>(asUINT arg, void* value)
{
	IRIS_ASSERT( m_pContext != nullptr );
	m_pContext->SetArgObject(arg, value);
}
template<>
void CAsContext::SetArgument<int>(asUINT arg, int value)
{
	IRIS_ASSERT( m_pContext != nullptr );
	m_pContext->SetArgDWord(arg, value);
}

/**********************************************************************//**
 *
 * ɃAhXo^
 *
 -----------------------------------------------------------------------
 * @param [in]	arg	= ̃CfbNX
 * @param [in]	obj	= AhX
*//***********************************************************************/
void CAsContext::SetArgAddress(asUINT arg, void* addr)
{
	IRIS_ASSERT( m_pContext != nullptr );
	m_pContext->SetArgAddress(arg, addr);
}

/**********************************************************************//**
 *
 * ɃIuWFNgo^
 *
 -----------------------------------------------------------------------
 * @param [in]	arg	= ̃CfbNX
 * @param [in]	obj	= IuWFNg
*//***********************************************************************/
void CAsContext::SetArgObject(asUINT arg, void* obj)
{
	IRIS_ASSERT( m_pContext != nullptr );
	m_pContext->SetArgObject(arg, obj);
}

/**********************************************************************//**
 *
 * ߂l̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	type	= v^^Cv
 * @return	߂l
*//***********************************************************************/
CAsVariant CAsContext::GetReturnValue(int type) const
{
	if( m_pContext != nullptr )
	{
		switch( type )
		{
		case asTYPEID_BOOL:
		case asTYPEID_INT8:
		case asTYPEID_UINT8:
			return CAsVariant(m_pContext->GetReturnByte());
		case asTYPEID_INT16:
		case asTYPEID_UINT16:
			return CAsVariant(m_pContext->GetReturnWord());
		case asTYPEID_INT32:
		case asTYPEID_UINT32:
			return CAsVariant(m_pContext->GetReturnDWord());
		case asTYPEID_INT64:
		case asTYPEID_UINT64:
			return CAsVariant(m_pContext->GetReturnQWord());
		case asTYPEID_FLOAT:
			return CAsVariant(m_pContext->GetReturnFloat());
		case asTYPEID_DOUBLE:
			return CAsVariant(m_pContext->GetReturnDouble());
		case asTYPEID_APPOBJECT:
			return CAsVariant(CAsVariant::TypeObject<asTYPEID_APPOBJECT>(), m_pContext->GetReturnObject());
		case asTYPEID_SCRIPTOBJECT:
			return CAsVariant(CAsVariant::TypeObject<asTYPEID_SCRIPTOBJECT>(), m_pContext->GetReturnObject());
		case asTYPEID_VOID:
		default:
			break;
		}
	}
	return CAsVariant();
}

/**********************************************************************//**
 *
 * s
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
int CAsContext::Execute(void)
{
	IRIS_ASSERT( m_pContext != nullptr );
	return m_pContext->Execute();
}

/**********************************************************************//**
 *
 * s
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
int CAsContext::Suspend(void)
{
	IRIS_ASSERT( m_pContext != nullptr );
	return m_pContext->Suspend();
}

/**********************************************************************//**
 *
 * I
 *
*//***********************************************************************/
void CAsContext::Terminate(void)
{
	// abort
	Abort();
	IRIS_SAFE_RELEASE(m_pContext);
}

/**********************************************************************//**
 *
 * ~
 *
*//***********************************************************************/
void CAsContext::Abort(void)
{
	if( m_pContext == nullptr ) return;
	m_pContext->Abort();
}

/**********************************************************************//**
 *
 * LȏԂǂ
 *
 -----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
bool CAsContext::IsValid(void) const
{
	return m_pContext != nullptr;
}

/**********************************************************************//**
 *
 * O擾
 *
 -----------------------------------------------------------------------
 * @return	O
*//***********************************************************************/
LPCSTR CAsContext::GetExceptionString(void)
{
	IRIS_ASSERT( m_pContext != nullptr );
	return m_pContext->GetExceptionString();
}

/**********************************************************************//**
 *
 * O֐ID擾
 *
 -----------------------------------------------------------------------
 * @return	O֐ID
*//***********************************************************************/
int CAsContext::GetExceptionFunction(void)
{
	IRIS_ASSERT( m_pContext != nullptr );
	return m_pContext->GetExceptionFunction();
}

/**********************************************************************//**
 *
 * OC擾
 *
 -----------------------------------------------------------------------
 * @param [out]	column	= ԍo
 * @param [out]	scetion	= ZNVo
 * @return	Cԍ
*//***********************************************************************/
int CAsContext::GetExceptionLineNumber(int* column, const char** sectionName)
{
	IRIS_ASSERT( m_pContext != nullptr );
	return m_pContext->GetExceptionLineNumber(column, sectionName);
}

/**********************************************************************//**
 *
 * OR[obN̐ݒ
 *
 -----------------------------------------------------------------------
 * @param [in]	callback	= R[obN֐
 * @param [in]	obj			= 
 * @param [in]	callConv	= 
 * @return	
*//***********************************************************************/
int CAsContext::SetExceptionCallback(asSFuncPtr callback, void *obj, int callConv)
{
	IRIS_ASSERT( m_pContext != nullptr );
	return m_pContext->SetExceptionCallback(callback, obj, callConv);
}

}	// end of namespace as
}	// end of namespace iris

#endif
